/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.logger.config;

import com.intel.stl.ui.common.UILabels;
import java.util.HashMap;

public enum LoggingValidatorError {
    MAX_FILE_SIZE_MISSING(0, UILabels.STL50034_MAX_FILE_SIZE_MISSING),
    MAX_FILE_SIZE_INVALID_TYPE(1, UILabels.STL50035_MAX_FILE_SIZE_INVALID_TYPE),
    MAX_FILE_SIZE_FORMAT_EXCEPTION(2, UILabels.STL50036_MAX_FILE_SIZE_FORMAT_EXCEPTION),
    MAX_FILE_SIZE_OUT_OF_RANGE(3, UILabels.STL50062_MAX_FILE_SIZE_OUT_OF_RANGE),
    MAX_NUM_FILES_OUT_OF_RANGE(4, UILabels.STL50037_MAX_NUM_FILES_OUT_OF_RANGE),
    MAX_NUM_FILES_MISSING(5, UILabels.STL50038_MAX_NUM_FILES_MISSING),
    MAX_NUM_FILES_INVALID_TYPE(6, UILabels.STL50039_MAX_NUM_FILES_INVALID_TYPE),
    MAX_NUM_FILES_TOO_LARGE(7, UILabels.STL50040_MAX_NUM_FILES_TOO_LARGE),
    MAX_NUM_FILES_FORMAT_EXCEPTION(8, UILabels.STL50041_MAX_NUM_FILES_FORMAT_EXCEPTION),
    FILE_LOCATION_MISSING(9, UILabels.STL50042_FILE_LOCATION_MISSING),
    FILE_LOCATION_CREATION_ERROR(10, UILabels.STL50043_FILE_LOCATION_CREATION_ERROR),
    FILE_LOCATION_HEADLESS_ERROR(11, UILabels.STL50044_FILE_LOCATION_HEADLESS_ERROR),
    FILE_LOCATION_IO_ERROR(12, UILabels.STL50045_FILE_LOCATION_IO_ERROR),
    FILE_LOCATION_DIRECTORY_ERROR(13, UILabels.STL50046_FILE_LOCATION_DIRECTORY_ERROR),
    FORMAT_STRING_EMPTY(14, UILabels.STL50047_FORMAT_STRING_EMPTY),
    FORMAT_STRING_INVALID(15, UILabels.STL50048_FORMAT_STRING_INVALID),
    UNSUPPORTED_APPENDER_TYPE(16, UILabels.STL50060_UNSUPPORTED_APPENDER_TYPE),
    INVALID_THRESHOLD_TYPE(17, UILabels.STL50061_INVALID_THRESHOLD_TYPE),
    OK(18, UILabels.STL50063_OK);

    private static final HashMap<Integer, LoggingValidatorError> validateErrorMap;
    private final int id;
    private final String value;
    public final UILabels label;
    public static Object data;

    private LoggingValidatorError(int id, UILabels label) {
        this.id = id;
        this.label = label;
        this.value = label.getDescription();
    }

    public UILabels getLabel() {
        return this.label;
    }

    public int getId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public static String getValue(int id) {
        LoggingValidatorError err = validateErrorMap.get(id);
        String description = null;
        if (err != null) {
            description = err.getLabel().getDescription(data);
        }
        return description;
    }

    public static Object getData() {
        return data;
    }

    static {
        validateErrorMap = new HashMap();
        for (LoggingValidatorError type : LoggingValidatorError.values()) {
            validateErrorMap.put(type.getId(), type);
        }
    }
}

