/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.api.SubnetContext;
import com.intel.stl.api.SubnetEvent;
import com.intel.stl.api.configuration.AppInfo;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.ui.admin.impl.AdminPage;
import com.intel.stl.ui.admin.view.AdminView;
import com.intel.stl.ui.common.EventSummaryBarPanelController;
import com.intel.stl.ui.common.EventTableController;
import com.intel.stl.ui.common.IContextAware;
import com.intel.stl.ui.common.IEventSummaryBarListener;
import com.intel.stl.ui.common.IPageController;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.EventSummaryBarPanel;
import com.intel.stl.ui.email.EmailSettingsController;
import com.intel.stl.ui.email.IEmailController;
import com.intel.stl.ui.event.JumpToEvent;
import com.intel.stl.ui.event.TaskStatusEvent;
import com.intel.stl.ui.framework.AbstractController;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.framework.IModelListener;
import com.intel.stl.ui.framework.ITask;
import com.intel.stl.ui.logger.config.ILoggingControl;
import com.intel.stl.ui.logger.config.LoggingConfigController;
import com.intel.stl.ui.main.CertsLoginController;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.FabricModel;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.main.HomePage;
import com.intel.stl.ui.main.IFabricController;
import com.intel.stl.ui.main.ISubnetManager;
import com.intel.stl.ui.main.PinBoardController;
import com.intel.stl.ui.main.SubnetRefreshTask;
import com.intel.stl.ui.main.SubnetSwitchTask;
import com.intel.stl.ui.main.UndoHandler;
import com.intel.stl.ui.main.UndoablePageSelection;
import com.intel.stl.ui.main.view.AboutDialog;
import com.intel.stl.ui.main.view.CredentialsGlassPanel;
import com.intel.stl.ui.main.view.FVMainFrame;
import com.intel.stl.ui.main.view.FabricView;
import com.intel.stl.ui.main.view.HomeView;
import com.intel.stl.ui.main.view.IFabricView;
import com.intel.stl.ui.main.view.IPageListener;
import com.intel.stl.ui.monitor.PerformancePage;
import com.intel.stl.ui.monitor.tree.FVTreeManager;
import com.intel.stl.ui.monitor.view.PerformanceTreeView;
import com.intel.stl.ui.network.GraphService;
import com.intel.stl.ui.network.OutlineService;
import com.intel.stl.ui.network.TopologyPage;
import com.intel.stl.ui.network.view.TopologyView;
import com.intel.stl.ui.publisher.TaskScheduler;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import javax.swing.JFrame;
import javax.swing.SwingWorker;
import net.engio.mbassy.bus.MBassador;
import net.engio.mbassy.bus.error.IPublicationErrorHandler;
import net.engio.mbassy.bus.error.PublicationError;
import net.engio.mbassy.listener.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricController
extends AbstractController<FabricModel, FabricView, FabricController>
implements IFabricController,
IPageListener,
IEventSummaryBarListener,
PropertyChangeListener {
    public static final String PROGRESS_AMOUNT_PROPERTY = "ProgressAmount";
    public static final String PROGRESS_NOTE_PROPERTY = "ProgressNote";
    private static Logger log = LoggerFactory.getLogger(FabricController.class);
    private IFabricView mainFrame;
    private final JFrame viewFrame;
    private final List<IPageController> pages = new CopyOnWriteArrayList<IPageController>();
    private int refreshCount;
    private final ISubnetManager subnetMgr;
    private final ILoggingControl loggingConfigController;
    private final IEmailController emailSettingsController;
    private EventSummaryBarPanel eventSummaryBarPanel;
    private EventSummaryBarPanelController eventSummaryBarPanelController;
    private EventTableController eventTableController;
    private boolean hasEventTableToggled;
    private ITask backgroundTask;
    private final List<ITask> pendingTasks = Collections.synchronizedList(new ArrayList());
    private final FVTreeManager builder;
    private int pageLoadWork;
    private int backgroundTotalWork;
    private double backgroundWork;
    private Rectangle lastBounds;
    private boolean maximized;
    private GraphService graphService;
    private OutlineService outlineService;
    private String subnetName;
    private final HelpAction helpAction;
    private final CertsLoginController certsLoginCtr;
    private final PinBoardController pinBoardCtr;
    private Boolean hideInactiveNodes;
    protected boolean isSystemUpdate;
    private UndoHandler undoHandler;

    public FabricController(String subnetName, FabricView view, ISubnetManager subnetMgr, MBassador<IAppEvent> eventBus) {
        super(new FabricModel(), view, eventBus);
        this.subnetMgr = subnetMgr;
        this.subnetName = subnetName;
        this.setupEventBus();
        this.builder = new FVTreeManager();
        this.mainFrame = view.getView();
        this.viewFrame = view.getMainFrame();
        this.loggingConfigController = this.createLoggingConfigController();
        this.helpAction = HelpAction.getInstance();
        this.helpAction.enableHelpMenu(view.getMainFrame().getOnlineHelpMenu());
        this.certsLoginCtr = this.createCertsLoginController();
        this.emailSettingsController = this.createEmailSettingsController(view.getMainFrame());
        this.pinBoardCtr = this.createPinBoardController();
        this.addModelListener(new IModelListener<FabricModel>(){

            @Override
            public void modelChanged(FabricModel model) {
                if (model.getPreviousSubnet() == null && model.getCurrentSubnet() != null) {
                    FabricController.this.pinBoardCtr.init();
                }
            }

            @Override
            public void modelUpdateFailed(FabricModel model, Throwable caught) {
            }
        });
        this.init();
    }

    protected CertsLoginController createCertsLoginController() {
        CredentialsGlassPanel cgp = new CredentialsGlassPanel();
        CertsLoginController ctr = new CertsLoginController(this, (FVMainFrame)this.mainFrame, cgp);
        return ctr;
    }

    protected PinBoardController createPinBoardController() {
        return new PinBoardController(((FabricView)this.view).getPinBoardView(), this);
    }

    protected void setupEventBus() {
        this.eventBus.subscribe((Object)this);
    }

    @Override
    public JFrame getViewFrame() {
        return this.viewFrame;
    }

    @Override
    public MBassador<IAppEvent> getEventBus() {
        return this.eventBus;
    }

    private void init() {
        this.eventSummaryBarPanel = this.mainFrame.getEventSummaryBarPanel();
        this.eventSummaryBarPanelController = new EventSummaryBarPanelController(this.eventSummaryBarPanel);
        this.eventSummaryBarPanelController.setEventSummaryBarListener(this);
        this.mainFrame.showEventSummaryTable();
        this.hasEventTableToggled = false;
        this.eventTableController = this.mainFrame.getEventTableController();
        this.installPages();
        this.installUndoHandler();
    }

    protected void installPages() {
        HomePage homePage = this.createHomePage();
        this.pages.add(homePage);
        PerformancePage perPage = this.createPerformancePage();
        this.pages.add(perPage);
        TopologyPage topologyPage = this.createTopologyPage();
        this.pages.add(topologyPage);
        AdminPage adminPage = this.createAdminPage();
        this.pages.add(adminPage);
        this.pageLoadWork = 0;
        for (IPageController page : this.pages) {
            this.pageLoadWork += page.getContextSwitchWeight().getWeight();
        }
    }

    protected void installUndoHandler() {
        this.undoHandler = new UndoHandler();
        ((FabricView)this.view).getView().setUndoAction(this.undoHandler.getUndoAction());
        ((FabricView)this.view).getView().setRedoAction(this.undoHandler.getRedoAction());
    }

    protected HomePage createHomePage() {
        return new HomePage(new HomeView(), (MBassador<IAppEvent>)this.eventBus);
    }

    protected PerformancePage createPerformancePage() {
        return new PerformancePage(new PerformanceTreeView(), (MBassador<IAppEvent>)this.eventBus, this.builder);
    }

    protected TopologyPage createTopologyPage() {
        this.graphService = new GraphService();
        this.outlineService = new OutlineService();
        TopologyView topologyView = new TopologyView(this.graphService, this.outlineService);
        return new TopologyPage(topologyView, (MBassador<IAppEvent>)this.eventBus, this.builder);
    }

    protected AdminPage createAdminPage() {
        Window owner = this.mainFrame != null && this.mainFrame instanceof Window ? (Window)((Object)this.mainFrame) : null;
        return new AdminPage(new AdminView((IFabricView)((Object)owner)), (MBassador<IAppEvent>)this.eventBus);
    }

    protected LoggingConfigController createLoggingConfigController() {
        return LoggingConfigController.getInstance(((FabricView)this.view).getMainFrame(), this.subnetMgr);
    }

    protected EmailSettingsController createEmailSettingsController(FVMainFrame owner) {
        return EmailSettingsController.getInstance(owner, this.subnetMgr);
    }

    protected boolean isAddRandomValues() {
        return ((FabricModel)this.model).isAddRandomValues();
    }

    @Override
    public IFabricView getView() {
        return this.mainFrame;
    }

    @Override
    public SubnetDescription getCurrentSubnet() {
        return ((FabricModel)this.model).getCurrentSubnet();
    }

    @Override
    public Context getCurrentContext() {
        return super.getContext();
    }

    @Override
    public void initializeContext(Context context) {
        this.subnetName = context.getSubnetDescription().getName();
        this.checkBackgroundTask();
        this.mainFrame.setSubnetName(this.subnetName);
        this.mainFrame.setReady(false);
        this.mainFrame.showProgress(UILabels.STL10104_INIT_SUBNET.getDescription(this.subnetName), true);
        this.mainFrame.setProgress(0);
        ArrayList<IContextAware> foregroundContextPages = new ArrayList<IContextAware>();
        foregroundContextPages.add(this.builder);
        ArrayList<IContextAware> backgroundContextPages = new ArrayList<IContextAware>();
        backgroundContextPages.addAll(this.pages);
        backgroundContextPages.add(this.eventSummaryBarPanelController);
        backgroundContextPages.add(this.eventTableController);
        this.backgroundTotalWork = this.builder.getContextSwitchWeight().getWeight() + this.eventSummaryBarPanelController.getContextSwitchWeight().getWeight() + this.eventTableController.getContextSwitchWeight().getWeight();
        this.backgroundTotalWork += this.pageLoadWork;
        this.backgroundWork = 0.0;
        this.backgroundTask = new SubnetSwitchTask((FabricModel)this.model, context, foregroundContextPages, backgroundContextPages);
        this.backgroundTask.addPropertyChangeListener(this);
        this.mainFrame.setTitle(STLConstants.K0001_FABRIC_VIEWER_TITLE.getValue());
        this.submitTask(this.backgroundTask);
    }

    @Override
    public void resetContext(Context newContext) {
        this.checkBackgroundTask();
        SubnetDescription subnet = newContext.getSubnetDescription();
        this.subnetName = subnet.getName();
        this.mainFrame.setSubnetName(this.subnetName);
        this.mainFrame.setReady(false);
        this.mainFrame.showProgress(UILabels.STL10104_INIT_SUBNET.getDescription(this.subnetName), true);
        this.mainFrame.setProgress(0);
        ArrayList<IContextAware> foregroundContextPages = new ArrayList<IContextAware>();
        foregroundContextPages.add(this.builder);
        ArrayList<IContextAware> backgroundContextPages = new ArrayList<IContextAware>();
        backgroundContextPages.addAll(this.pages);
        backgroundContextPages.add(this.eventSummaryBarPanelController);
        backgroundContextPages.add(this.eventTableController);
        this.backgroundTotalWork = this.builder.getContextSwitchWeight().getWeight() + this.eventSummaryBarPanelController.getContextSwitchWeight().getWeight() + this.eventTableController.getContextSwitchWeight().getWeight();
        this.backgroundTotalWork += this.pageLoadWork;
        this.backgroundWork = 0.0;
        this.backgroundTask = new SubnetSwitchTask((FabricModel)this.model, newContext, foregroundContextPages, backgroundContextPages);
        this.backgroundTask.addPropertyChangeListener(this);
        this.mainFrame.setTitle(STLConstants.K0001_FABRIC_VIEWER_TITLE.getValue());
        this.submitTask(this.backgroundTask);
    }

    @Handler
    protected synchronized void onNoticeTaskStatus(TaskStatusEvent<?> evt) {
        this.refreshCount = evt.isStarted() ? ++this.refreshCount : --this.refreshCount;
        if (this.refreshCount == 1 && evt.isStarted()) {
            Util.runInEDT(new Runnable(){

                @Override
                public void run() {
                    FabricController.this.mainFrame.setRefreshRunning(true);
                }
            });
        } else if (this.refreshCount == 0) {
            Util.runInEDT(new Runnable(){

                @Override
                public void run() {
                    if (FabricController.this.mainFrame != null) {
                        FabricController.this.mainFrame.setRefreshRunning(false);
                    }
                }
            });
        }
    }

    public synchronized void onRefresh() {
        if (!this.mainFrame.isReady()) {
            return;
        }
        this.isSystemUpdate = true;
        Context context = this.getContext();
        if (context != null && context.isValid()) {
            this.checkBackgroundTask();
            this.mainFrame.setReady(false);
            this.mainFrame.showProgress(UILabels.STL10110_REFRESHING_PAGES.getDescription(this.getCurrentSubnet().getName()), true);
            this.mainFrame.setProgress(0);
            this.backgroundTotalWork = this.pageLoadWork;
            this.backgroundWork = 0.0;
            this.backgroundTask = new SubnetRefreshTask((FabricModel)this.model, this.builder, this.pages, context);
            this.backgroundTask.addPropertyChangeListener(this);
            this.submitTask(this.backgroundTask);
        } else if (context == null) {
            if (this.backgroundTask != null && !this.backgroundTask.isDone()) {
                this.mainFrame.setReady(false);
                this.mainFrame.showProgress(UILabels.STL10104_INIT_SUBNET.getDescription(this.subnetName), true);
                this.backgroundTask.addPropertyChangeListener(this);
            } else {
                this.selectSubnet(this.subnetName);
            }
        } else {
            this.checkBackgroundTask();
            this.selectSubnet(this.subnetName);
        }
        this.certsLoginCtr.sslReconnectCleanup();
    }

    private void checkBackgroundTask() {
        if (this.backgroundTask != null && !this.backgroundTask.isDone()) {
            this.backgroundTask.removePropertyChangeListener(this);
            try {
                System.out.println("FabricController cancelling backgroundTask!");
                this.backgroundTask.cancel(true);
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onTaskSuccess() {
    }

    @Override
    public void onTaskFailure(Throwable caught) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (PROGRESS_AMOUNT_PROPERTY == evt.getPropertyName()) {
            double progress = (Double)evt.getNewValue();
            this.backgroundWork += progress;
            double percentProgress = this.backgroundWork / (double)this.backgroundTotalWork * 100.0;
            if (percentProgress > 100.0) {
                percentProgress = 100.0;
            }
            if (this.mainFrame != null) {
                this.mainFrame.setProgress((int)percentProgress);
            }
        } else if (PROGRESS_NOTE_PROPERTY == evt.getPropertyName()) {
            String note = (String)evt.getNewValue();
            if (this.mainFrame == null) {
                System.out.println("=========== " + note);
                return;
            }
            if (this.mainFrame != null) {
                this.mainFrame.setProgressNote(note);
            }
        }
    }

    @Override
    public void selectSubnet(final String subnetName) {
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                FabricController.this.subnetMgr.selectSubnet(subnetName);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException e) {
                    Util.showError(FabricController.this.mainFrame.getView(), e);
                }
            }
        };
        worker.execute();
    }

    @Override
    public void resetConnectMenu() {
        if (this.mainFrame != null) {
            this.mainFrame.resetConnectMenu();
        }
    }

    @Override
    public void resetSubnet(SubnetDescription subnet) {
        Context context;
        SubnetDescription currSubnet = ((FabricModel)this.model).getCurrentSubnet();
        this.subnetName = subnet.getName();
        if (currSubnet != null) {
            currSubnet.setName(this.subnetName);
        }
        if ((context = this.getContext()) != null) {
            context.getSubnetDescription().setName(this.subnetName);
        }
        this.notifyModelChanged();
    }

    private void clearContext(Context context) {
        context.getTaskScheduler().clear();
    }

    @Override
    public void doShowInitScreen(Rectangle bounds, boolean maximized) {
        if (this.mainFrame != null) {
            this.mainFrame.showInitScreen(bounds, maximized);
        }
    }

    @Override
    public void doShowMessageAndExit(final String message, final String title) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                if (FabricController.this.mainFrame != null) {
                    FabricController.this.mainFrame.showMessageAndExit(message, title);
                }
            }
        });
    }

    @Override
    public void doShowErrors(final List<Throwable> errors) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                if (FabricController.this.mainFrame != null) {
                    FabricController.this.mainFrame.showErrors(errors);
                }
            }
        });
    }

    @Override
    public void doShowContent() {
        if (this.mainFrame != null) {
            this.mainFrame.showContent(this.pages);
        }
    }

    public List<SubnetDescription> getSubnets() {
        return this.subnetMgr.getSubnets();
    }

    @Override
    public void reset() {
        this.subnetName = null;
        try {
            this.resetView();
            this.pinBoardCtr.cleanup();
            this.init();
        }
        catch (Throwable throwable) {
            this.init();
            this.eventBus.shutdown();
            this.eventBus = new MBassador(new IPublicationErrorHandler(){

                public void handleError(PublicationError error) {
                    log.error(null, (Object)error);
                    error.getCause().printStackTrace();
                }
            });
            Context context = this.getContext();
            if (context != null) {
                this.clearContext(context);
                this.setContext(null);
            }
            throw throwable;
        }
        this.eventBus.shutdown();
        this.eventBus = new MBassador(new /* invalid duplicate definition of identical inner class */);
        Context context = this.getContext();
        if (context != null) {
            this.clearContext(context);
            this.setContext(null);
        }
    }

    @Override
    public void doClose() {
        if (this.mainFrame != null) {
            this.mainFrame.close();
            this.mainFrame = null;
        }
    }

    @Override
    public void showSetupWizard(String subnetName) {
        this.subnetMgr.showSetupWizard(subnetName, this);
    }

    @Override
    public void showLoggingConfig() {
        this.loggingConfigController.showLoggingConfig();
    }

    @Override
    public void showEmailSettingsDialog() {
        this.emailSettingsController.showEmailSettingsDlg((FVMainFrame)this.mainFrame);
    }

    @Override
    public void addPendingTask(ITask task) {
        this.pendingTasks.add(task);
        if (this.mainFrame.isReady()) {
            this.processPendingTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPendingTasks() {
        List<ITask> list = this.pendingTasks;
        synchronized (list) {
            Iterator<ITask> it = this.pendingTasks.iterator();
            while (it.hasNext()) {
                this.submitTask(it.next());
                it.remove();
            }
        }
    }

    public void onWindowClose() {
        this.resetView(true);
    }

    public void onMenuClose() {
        this.resetView(false);
    }

    private void resetView(boolean forceWindowClose) {
        try {
            this.resetView();
        }
        finally {
            this.subnetMgr.stopSubnet(this.subnetName, forceWindowClose);
        }
    }

    private void resetView() {
        try {
            if (this.graphService != null) {
                this.graphService.shutdown();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.outlineService != null) {
                this.outlineService.shutdown();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (IPageController page : this.pages) {
            page.cleanup();
        }
        this.pages.clear();
        try {
            ((FabricModel)this.model).setCurrentSubnet(null);
            this.notifyModelChanged();
        }
        finally {
            if (this.mainFrame != null) {
                this.lastBounds = this.mainFrame.getFrameBounds();
                this.maximized = this.mainFrame.isFrameMaximized();
            }
        }
    }

    @Override
    public void bringToFront() {
        if (this.mainFrame != null) {
            Util.runInEDT(new Runnable(){

                @Override
                public void run() {
                    FabricController.this.mainFrame.bringToFront();
                }
            });
        }
    }

    @Override
    public Rectangle getBounds() {
        if (this.mainFrame == null) {
            return this.lastBounds;
        }
        return this.mainFrame.getFrameBounds();
    }

    @Override
    public boolean isMaximized() {
        if (this.mainFrame == null) {
            return this.maximized;
        }
        return this.mainFrame.isFrameMaximized();
    }

    @Override
    public void cleanup() {
        this.subnetName = null;
        this.eventBus.shutdown();
        if (this.pinBoardCtr != null) {
            this.pinBoardCtr.cleanup();
        }
    }

    protected IPageController getPage(String name) {
        for (IPageController page : this.pages) {
            if (!page.getName().equals(name)) continue;
            return page;
        }
        throw new IllegalArgumentException("Couldn't find page with name '" + name + "'");
    }

    @Override
    public boolean canPageChange(String oldPageId, String newPageId) {
        if (oldPageId != null && !this.pages.isEmpty()) {
            IPageController oldPage = this.getPage(oldPageId);
            return oldPage.canExit();
        }
        return true;
    }

    public void selectPage(IPageController page) {
        this.isSystemUpdate = true;
        this.mainFrame.setCurrentTab(page);
    }

    @Override
    public void onPageChanged(String oldPageId, String newPageId) {
        IPageController oldPage = null;
        if (oldPageId != null) {
            oldPage = this.getPage(oldPageId);
            if (oldPage == this.pages.get(0) && !this.hasEventTableToggled) {
                this.mainFrame.hideEventSummaryTable();
            }
            oldPage.onExit();
        }
        IPageController newPage = null;
        if (newPageId != null) {
            newPage = this.getPage(newPageId);
            if (newPage == this.pages.get(0) && !this.hasEventTableToggled) {
                this.mainFrame.showEventSummaryTable();
            }
            newPage.onEnter();
        }
        if (!this.isSystemUpdate && !this.undoHandler.isInProgress()) {
            UndoablePageSelection undoSel = new UndoablePageSelection(this, oldPage, newPage);
            this.undoHandler.addUndoAction(undoSel);
        }
        if (this.isSystemUpdate) {
            this.isSystemUpdate = false;
        }
    }

    @Override
    public void toggleEventSummaryTable() {
        this.mainFrame.toggleEventSummaryTable();
        if (!this.hasEventTableToggled) {
            this.hasEventTableToggled = true;
        }
    }

    public void applyRandomValue(boolean selected) {
        ((FabricModel)this.model).setAddRandomValues(selected);
        Context context = this.getContext();
        if (context != null) {
            context.setRandom(selected);
            context.getPerformanceApi().setRandom(selected);
        }
    }

    public void startSimulatedFailover() {
        Context context = this.getContext();
        if (context != null && ((FabricModel)this.model).getCurrentSubnet() != null) {
            SubnetDescription subnet = ((FabricModel)this.model).getCurrentSubnet();
            context.getConfigurationApi().startSimulatedFailover(subnet.getName());
        }
    }

    @Handler
    protected void onJumpToEvent(JumpToEvent event) {
        for (IPageController page : this.pages) {
            if (!page.getName().equals(event.getDestination())) continue;
            this.selectPage(page);
            return;
        }
        log.warn("Unsupported destination " + event.getDestination());
    }

    @Override
    public void initModel() {
    }

    protected List<IPageController> getPages() {
        return this.pages;
    }

    @Override
    public TaskScheduler getTaskScheduler() {
        Context context = this.getContext();
        TaskScheduler taskScheduler = null;
        if (context != null) {
            taskScheduler = context.getTaskScheduler();
        }
        return taskScheduler;
    }

    @Override
    public void onSubnetManagerConnectionLost(SubnetEvent event) {
        SubnetContext subnetCtx = (SubnetContext)event.getSource();
        SubnetDescription subnet = subnetCtx.getSubnetDescription();
        this.backgroundWork = 0.0;
        if (subnet != null) {
            this.backgroundTotalWork = subnet.getFeList().size();
        }
        subnetCtx.addFailoverProgressListener(this);
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                FabricController.this.mainFrame.setReady(false);
                FabricController.this.mainFrame.setProgressNote("");
                FabricController.this.mainFrame.showFailoverProgress(UILabels.STL10113_CONNECTION_LOST.getDescription(), true);
                FabricController.this.mainFrame.setProgress(0);
            }
        });
    }

    @Override
    public void onFailoverCompleted(SubnetEvent event) {
        Context newContext;
        Context context = this.getContext();
        Context context2 = newContext = context == null ? null : this.subnetMgr.getContext(context.getSubnetDescription());
        if (newContext != null && context != newContext) {
            this.resetContext(newContext);
            return;
        }
        if (context != null) {
            context.removeFailoverProgressListener(this);
            TaskScheduler ts = context.getTaskScheduler();
            ts.updateRefreshRate(ts.getRefreshRate());
            context.getManagementApi().reset();
        }
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                FabricController.this.mainFrame.showFailoverProgress(UILabels.STL10110_REFRESHING_PAGES.getDescription(FabricController.this.getCurrentSubnet().getName()), true);
                FabricController.this.mainFrame.setReady(true);
                FabricController.this.onRefresh();
            }
        });
    }

    @Override
    public void onFailoverFailed(SubnetEvent event) {
        Context context = this.getContext();
        if (context != null) {
            context.removeFailoverProgressListener(this);
        }
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                if (FabricController.this.mainFrame != null) {
                    FabricController.this.mainFrame.showFailoverProgress(null, false);
                    FabricController.this.mainFrame.setReady(true);
                    FabricController.this.mainFrame.showMessage(UILabels.STL60009_PRESS_REFRESH.getDescription(), UILabels.STL60008_CONN_LOST.getDescription());
                    for (IPageController page : FabricController.this.pages) {
                        if (!(page instanceof AdminPage)) continue;
                        page.onRefresh(null);
                    }
                }
            }
        });
    }

    @Override
    public void onSubnetManagerConnected(SubnetEvent event) {
    }

    public void cancelFailover() {
        this.subnetMgr.cancelFailoverFor(this.subnetName);
    }

    public void showAboutDialog() {
        if (this.subnetMgr != null) {
            AppInfo appInfo = this.subnetMgr.getConfigurationApi().getAppInfo();
            String appVersion = appInfo.getOpaFmVersion();
            String buildId = appInfo.getAppBuildId();
            AboutDialog.showAboutDialog((JFrame)((Object)this.mainFrame), appInfo.getAppName(), appVersion, buildId, appInfo.getAppBuildDate());
        }
    }

    @Override
    public CertsLoginController getCertsLoginController() {
        return this.certsLoginCtr;
    }

    @Override
    public PinBoardController getPinBoardController() {
        return this.pinBoardCtr;
    }

    @Override
    public UndoHandler getUndoHandler() {
        return this.undoHandler;
    }

    public void onHideInactiveNodes(boolean hideInactiveNodes) {
        AppInfo appInfo = this.subnetMgr.getConfigurationApi().getAppInfo();
        Properties applicationProperties = new Properties();
        applicationProperties.put("hide.inactive.nodes", String.valueOf(hideInactiveNodes));
        appInfo.setProperty("FMGUIApp", applicationProperties);
        this.subnetMgr.getConfigurationApi().saveAppInfo(appInfo);
        this.hideInactiveNodes = hideInactiveNodes;
        this.onRefresh();
    }

    @Override
    public boolean getHideInactiveNodes() {
        if (this.hideInactiveNodes == null) {
            AppInfo appInfo = this.subnetMgr.getConfigurationApi().getAppInfo();
            Properties appProps = appInfo.getProperty("FMGUIApp");
            String hideNodes = "false";
            if (appProps != null) {
                hideNodes = (String)appProps.get("hide.inactive.nodes");
            }
            this.hideInactiveNodes = Boolean.valueOf(hideNodes);
        }
        return this.hideInactiveNodes;
    }
}

