/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.performance.ImageInfoBean;
import com.intel.stl.api.performance.SMInfoDataBean;
import com.intel.stl.api.subnet.FabricInfoBean;
import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.SMRecordBean;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.ui.common.IPageController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.ISectionController;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.JSectionView;
import com.intel.stl.ui.event.NodeUpdateEvent;
import com.intel.stl.ui.event.PageSelectedEvent;
import com.intel.stl.ui.event.TaskStatusEvent;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.FabricController;
import com.intel.stl.ui.main.PerformanceSection;
import com.intel.stl.ui.main.SummarySection;
import com.intel.stl.ui.main.view.HomeView;
import com.intel.stl.ui.main.view.PerformanceSectionView;
import com.intel.stl.ui.main.view.SummarySectionView;
import com.intel.stl.ui.model.GroupStatistics;
import com.intel.stl.ui.model.StateSummary;
import com.intel.stl.ui.publisher.CallbackAdapter;
import com.intel.stl.ui.publisher.EventCalculator;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.IStateChangeListener;
import com.intel.stl.ui.publisher.Task;
import com.intel.stl.ui.publisher.TaskScheduler;
import com.intel.stl.ui.publisher.subscriber.EventSubscriber;
import com.intel.stl.ui.publisher.subscriber.ImageInfoSubscriber;
import com.intel.stl.ui.publisher.subscriber.SubscriberType;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.engio.mbassy.bus.MBassador;
import net.engio.mbassy.listener.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomePage
implements IPageController,
IStateChangeListener {
    private static final Logger log = LoggerFactory.getLogger(HomePage.class);
    public static final String NAME = STLConstants.K0100_HOME.getValue();
    private TaskScheduler scheduler;
    private ISubnetApi subnetApi;
    private final HomeView view;
    private final List<ISectionController<?>> sections;
    private Context context;
    private SummarySection summary;
    private PerformanceSection performance;
    private GroupStatistics groupStatistics;
    private Task<ImageInfoBean> imageInfoTask;
    private ICallback<ImageInfoBean> imageInfoCallback;
    private final MBassador<IAppEvent> eventBus;
    private ImageInfoSubscriber imageInfoSubscriber;
    private EventSubscriber eventSubscriber;
    private ICallback<StateSummary> stateSummaryCallback;
    private Task<StateSummary> stateSummaryTask;
    private boolean isRefreshing;
    private ImageInfoBean lastImageInfo;
    private static final int DELAYED_REFRESH = 2;
    private int refreshDelayCount;

    public HomePage(HomeView view, MBassador<IAppEvent> eventBus) {
        this.view = view;
        this.eventBus = eventBus;
        eventBus.subscribe((Object)this);
        this.sections = this.getSections();
        ArrayList sectionViews = new ArrayList();
        for (ISectionController<?> section : this.sections) {
            sectionViews.add((JSectionView<?>)section.getView());
        }
        view.installSectionViews(sectionViews);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Handler(priority=1)
    protected synchronized void onNodeUpdate(NodeUpdateEvent evt) {
        TaskStatusEvent<NodeUpdateEvent> taskEvent = new TaskStatusEvent<NodeUpdateEvent>(this, evt, TaskStatusEvent.Status.STARTED);
        this.eventBus.publish(taskEvent);
        this.isRefreshing = true;
        try {
            if (this.scheduler != null) {
                IPerformanceApi perfApi = this.scheduler.getPerformanceApi();
                ImageInfoBean imgInfo = perfApi.getLatestImageInfo();
                if (imgInfo != null) {
                    this.processImageInfo(imgInfo);
                }
                this.performance.onRefresh(null);
            }
        }
        finally {
            this.isRefreshing = false;
            taskEvent = new TaskStatusEvent<NodeUpdateEvent>(this, evt, TaskStatusEvent.Status.FINISHED);
            this.eventBus.publish(taskEvent);
            this.refreshDelayCount = 2;
        }
    }

    protected List<ISectionController<?>> getSections() {
        ArrayList sections = new ArrayList();
        this.summary = new SummarySection(new SummarySectionView(), this.eventBus);
        sections.add(this.summary);
        this.performance = new PerformanceSection(new PerformanceSectionView(), this.eventBus);
        this.performance.setOrigin(new PageSelectedEvent(this, NAME));
        sections.add(this.performance);
        return sections;
    }

    @Override
    public void setContext(final Context context, IProgressObserver observer) {
        IProgressObserver[] subObservers = observer.createSubObservers(2);
        this.clear();
        this.context = context;
        this.subnetApi = this.context.getSubnetApi();
        this.scheduler = this.context.getTaskScheduler();
        this.imageInfoSubscriber = (ImageInfoSubscriber)this.scheduler.getSubscriber(SubscriberType.IMAGE_INFO);
        this.imageInfoCallback = new CallbackAdapter<ImageInfoBean>(){

            @Override
            public synchronized void onDone(ImageInfoBean result) {
                if (result != null) {
                    ImageInfoBean oldImageInfo = HomePage.this.lastImageInfo;
                    HomePage.this.processImageInfo(result);
                    if (oldImageInfo != null && oldImageInfo.hasChange(result)) {
                        HomePage.this.refreshDelayCount = 2;
                    } else if (HomePage.this.refreshDelayCount > 0) {
                        HomePage.this.refreshDelayCount = HomePage.this.refreshDelayCount - 1;
                        if (HomePage.this.refreshDelayCount == 0) {
                            Util.runInEDT(new Runnable(){

                                @Override
                                public void run() {
                                    ((FabricController)context.getController()).onRefresh();
                                }
                            });
                        }
                    }
                }
            }
        };
        this.imageInfoTask = this.imageInfoSubscriber.registerImageInfo(this.imageInfoCallback);
        if (observer.isCancelled()) {
            this.clear();
            return;
        }
        this.eventSubscriber = (EventSubscriber)this.scheduler.getSubscriber(SubscriberType.EVENT);
        this.stateSummaryCallback = new CallbackAdapter<StateSummary>(){

            @Override
            public synchronized void onDone(StateSummary result) {
                if (result != null) {
                    HomePage.this.onStateChange(result);
                }
            }
        };
        this.stateSummaryTask = this.eventSubscriber.registerStateSummary(this.stateSummaryCallback);
        if (observer.isCancelled()) {
            this.clear();
            return;
        }
        subObservers[0].onFinish();
        this.summary.setContext(context);
        this.performance.setContext(context, subObservers[1]);
        subObservers[1].onFinish();
        this.context.getEvtCal().addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRefresh(IProgressObserver observer) {
        this.isRefreshing = true;
        try {
            IPerformanceApi perfApi = this.scheduler.getPerformanceApi();
            ImageInfoBean imgInfo = perfApi.getLatestImageInfo();
            this.imageInfoCallback.onDone(imgInfo);
            if (observer.isCancelled()) {
                return;
            }
            StateSummary ss = this.context.getEvtCal().getSummary();
            this.onStateChange(ss);
            if (observer.isCancelled()) {
                return;
            }
            this.performance.onRefresh(observer);
            observer.onFinish();
        }
        finally {
            this.isRefreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        for (ISectionController<?> section : this.sections) {
            section.clear();
        }
        if (this.scheduler != null) {
            if (this.imageInfoTask != null) {
                this.imageInfoSubscriber.deregisterImageInfo(this.imageInfoTask, this.imageInfoCallback);
            }
            if (this.stateSummaryTask != null) {
                this.eventSubscriber.deregisterStateSummary(this.stateSummaryTask, this.stateSummaryCallback);
            }
            if (this.context != null && this.context.getEvtCal() != null) {
                this.context.getEvtCal().removeListener(this);
            }
        }
        HomePage homePage = this;
        synchronized (homePage) {
            this.groupStatistics = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processImageInfo(ImageInfoBean imageInfo) {
        EventCalculator evtCal = this.context.getEvtCal();
        FabricInfoBean fabricInfo = this.subnetApi.getFabricInfo();
        List<SMInfoDataBean> sms = this.getSMs();
        HomePage homePage = this;
        synchronized (homePage) {
            if (this.groupStatistics == null) {
                this.summary.clear();
            }
            this.groupStatistics = new GroupStatistics(this.subnetApi.getConnectionDescription(), imageInfo, sms);
            this.isRefreshing = this.isRefreshing || this.lastImageInfo == null || this.lastImageInfo.hasChange(imageInfo);
            try {
                this.groupStatistics.setPortTypesDist(this.subnetApi.getPortsTypeDist(true, this.isRefreshing));
            }
            catch (Exception e) {
                log.error("Couldn't get PortTypesDist!", (Throwable)e);
                e.printStackTrace();
            }
            int msmLid = imageInfo.getSMInfo()[0].getLid();
            SMRecordBean msm = null;
            try {
                msm = this.subnetApi.getSM(msmLid);
            }
            catch (Exception e) {
                log.error("Couldn't get SMRecordBean for lid=" + msmLid + "!", (Throwable)e);
            }
            if (msm != null && msm.getSmInfo() != null) {
                this.groupStatistics.setMsmUptimeInSeconds(msm.getSmInfo().getElapsedTime());
            }
            this.lastImageInfo = imageInfo;
            this.isRefreshing = false;
            evtCal.processHealthScoreStats(fabricInfo, imageInfo);
        }
        this.summary.updateStatistics(this.groupStatistics);
    }

    protected List<SMInfoDataBean> getSMs() {
        List<SMRecordBean> sms = this.subnetApi.getSMs();
        ArrayList<SMInfoDataBean> res = new ArrayList<SMInfoDataBean>();
        for (SMRecordBean sm : sms) {
            try {
                NodeRecordBean node = this.subnetApi.getNode(sm.getLid());
                SMInfoDataBean smInfoData = new SMInfoDataBean();
                smInfoData.setLid(sm.getLid());
                smInfoData.setPriority(sm.getSmInfo().getPriority());
                smInfoData.setSmNodeDesc(node.getNodeDesc());
                smInfoData.setSmPortGuid(sm.getSmInfo().getPortGuid());
                smInfoData.setState(sm.getSmInfo().getSmStateCurrent());
                res.add(smInfoData);
            }
            catch (SubnetDataNotFoundException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    protected void processStateSummary(StateSummary stateSummary) {
        if (this.groupStatistics == null) {
            return;
        }
        int totalSWs = stateSummary.getBaseTotalSWs();
        if (this.lastImageInfo != null && this.lastImageInfo.getNumSwitchNodes() > totalSWs) {
            totalSWs = this.lastImageInfo.getNumSwitchNodes();
        }
        int totalHFIs = stateSummary.getBaseTotalHFIs();
        if (this.lastImageInfo != null && this.lastImageInfo.getNumHFIPorts() > totalHFIs) {
            totalHFIs = this.lastImageInfo.getNumHFIPorts();
        }
        this.summary.updateStates(stateSummary.getSwitchStates(), totalSWs, stateSummary.getHfiStates(), totalHFIs);
        this.summary.updateHealthScore(stateSummary.getHealthScore());
        this.summary.updateWorstNodes(stateSummary.getWorstNodes());
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return STLConstants.K0101_HOME_DESCRIPTION.getValue();
    }

    @Override
    public JPanel getView() {
        return this.view;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void onEnter() {
    }

    @Override
    public void onExit() {
    }

    @Override
    public boolean canExit() {
        return true;
    }

    @Override
    public PageWeight getContextSwitchWeight() {
        return PageWeight.MEDIUM;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return PageWeight.MEDIUM;
    }

    @Override
    public void onStateChange(StateSummary summary) {
        if (summary != null) {
            this.processStateSummary(summary);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

