/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.framework.AbstractTask;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.IFabricController;
import com.intel.stl.ui.main.SubnetManager;
import java.awt.Component;
import java.util.List;

public class RestartViewerTask
extends AbstractTask<String, Context, Void> {
    private final SubnetManager subnetMgr;
    private final SubnetDescription subnet;
    private final String existingHostId;
    private final String newHostId;

    public RestartViewerTask(String model, SubnetManager subnetMgr, SubnetDescription subnet, String existingHostId, String newHostId) {
        super(model);
        this.subnetMgr = subnetMgr;
        this.subnet = subnet;
        this.existingHostId = existingHostId;
        this.newHostId = newHostId;
    }

    @Override
    public Context processInBackground(Context context) throws Exception {
        IFabricController controller = context.getController();
        Context newContext = this.subnetMgr.createContext(this.subnet, controller);
        return newContext;
    }

    @Override
    public void onTaskSuccess(Context newContext) {
        IFabricController restartingController = (IFabricController)((Object)this.getController());
        String msg = (String)this.getModel();
        Util.showWarningMessage((Component)((Object)restartingController.getView()), msg);
        restartingController.resetContext(newContext);
    }

    @Override
    public void onTaskFailure(Throwable caught) {
        IFabricController thisController = (IFabricController)((Object)this.getController());
        Util.showError((Component)((Object)thisController.getView()), caught);
        Context context = thisController.getCurrentContext();
        context.close();
    }

    @Override
    public void onFinally() {
    }

    @Override
    protected void processIntermediateResults(List<Void> intermediateResults) {
    }
}

