/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.ui.common.IPinProvider;
import com.intel.stl.ui.common.PinDescription;
import com.intel.stl.ui.common.PinnableCardController;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.main.NodeStatusController;
import com.intel.stl.ui.main.view.IChartStyleListener;
import com.intel.stl.ui.main.view.StatusView;
import com.intel.stl.ui.model.ChartStyle;
import java.util.EnumMap;
import java.util.Properties;
import net.engio.mbassy.bus.MBassador;

public class StatusCard
extends PinnableCardController<IChartStyleListener, StatusView>
implements IChartStyleListener,
IPinProvider {
    private final NodeStatusController swStatusCtl;
    private final NodeStatusController fiStatusCtl;
    private NodeStatusController pinSwStatusCtl;
    private NodeStatusController pinFiStatusCtl;

    public StatusCard(StatusView view, MBassador<IAppEvent> eventBus) {
        super(view, eventBus);
        this.swStatusCtl = new NodeStatusController(view.getSwPanel());
        this.fiStatusCtl = new NodeStatusController(view.getFiPanel());
    }

    @Override
    public String getHelpID() {
        return HelpAction.getInstance().getStatus();
    }

    public void updateSwStates(EnumMap<NoticeSeverity, Integer> states, int total) {
        this.swStatusCtl.updateStates(states, total);
        if (this.pinSwStatusCtl != null) {
            this.pinSwStatusCtl.updateStates(states, total);
        }
    }

    public void updateFiStates(EnumMap<NoticeSeverity, Integer> states, int total) {
        this.fiStatusCtl.updateStates(states, total);
        if (this.pinFiStatusCtl != null) {
            this.pinFiStatusCtl.updateStates(states, total);
        }
    }

    @Override
    public void onStyleChange(ChartStyle style) {
        ChartStyle newStyle = null;
        if (style == ChartStyle.BAR) {
            newStyle = ChartStyle.PIE;
        } else if (style == ChartStyle.PIE) {
            newStyle = ChartStyle.BAR;
        } else {
            throw new IllegalArgumentException("Unknown chart style: " + (Object)((Object)style));
        }
        ((StatusView)this.view).setStyle(newStyle);
        this.swStatusCtl.setStyle(newStyle);
        this.fiStatusCtl.setStyle(newStyle);
        if (this.pinView != null) {
            ((StatusView)this.pinView).setStyle(newStyle);
            this.pinSwStatusCtl.setStyle(newStyle);
            this.pinFiStatusCtl.setStyle(newStyle);
        }
    }

    @Override
    public IChartStyleListener getCardListener() {
        return this;
    }

    @Override
    public void clear() {
        this.swStatusCtl.clear();
        this.fiStatusCtl.clear();
        if (this.pinSwStatusCtl != null) {
            this.pinSwStatusCtl.clear();
        }
        if (this.pinFiStatusCtl != null) {
            this.pinFiStatusCtl.clear();
        }
    }

    @Override
    protected void generateArgument(Properties arg) {
    }

    @Override
    protected StatusView createPinView() {
        StatusView pinView = new StatusView(){
            private static final long serialVersionUID = 461783273933437225L;

            @Override
            protected boolean isConcise() {
                return true;
            }
        };
        pinView.setCardListener(this.getCardListener());
        this.pinSwStatusCtl = new NodeStatusController(pinView.getSwPanel());
        this.pinFiStatusCtl = new NodeStatusController(pinView.getFiPanel());
        return pinView;
    }

    @Override
    protected void initPinView() {
        this.pinSwStatusCtl.updateStates(this.swStatusCtl.getLastStates(), this.swStatusCtl.getLastTotal());
        this.pinFiStatusCtl.updateStates(this.fiStatusCtl.getLastStates(), this.fiStatusCtl.getLastTotal());
    }

    @Override
    protected void clearPinView() {
        super.clearPinView();
        this.pinSwStatusCtl.clear();
        this.pinSwStatusCtl = null;
        this.pinFiStatusCtl.clear();
        this.pinFiStatusCtl = null;
    }

    @Override
    public PinDescription.PinID getPinID() {
        return PinDescription.PinID.STATUS;
    }
}

