/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.api.AppContext;
import com.intel.stl.api.ICertsAssistant;
import com.intel.stl.api.ISubnetEventListener;
import com.intel.stl.api.SubnetContext;
import com.intel.stl.api.SubnetEvent;
import com.intel.stl.api.Utils;
import com.intel.stl.api.configuration.AppInfo;
import com.intel.stl.api.configuration.ConfigurationException;
import com.intel.stl.api.configuration.IConfigurationApi;
import com.intel.stl.api.configuration.LoggingConfiguration;
import com.intel.stl.api.configuration.UserNotFoundException;
import com.intel.stl.api.configuration.UserSettings;
import com.intel.stl.api.performance.PMConfigBean;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.SubnetConnectionException;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.FabricController;
import com.intel.stl.ui.main.IFabricController;
import com.intel.stl.ui.main.ISubnetManager;
import com.intel.stl.ui.main.RestartViewerTask;
import com.intel.stl.ui.main.ShowWarningTask;
import com.intel.stl.ui.main.view.FVMainFrame;
import com.intel.stl.ui.main.view.FabricView;
import com.intel.stl.ui.main.view.IFabricView;
import com.intel.stl.ui.main.view.SplashScreen;
import com.intel.stl.ui.publisher.TaskScheduler;
import com.intel.stl.ui.wizards.impl.MultinetWizardController;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingWorker;
import net.engio.mbassy.bus.MBassador;
import net.engio.mbassy.bus.error.IPublicationErrorHandler;
import net.engio.mbassy.bus.error.PublicationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SubnetManager
implements ISubnetManager,
ISubnetEventListener {
    private static Logger log = LoggerFactory.getLogger(SubnetManager.class);
    private static final String PROPERTIES_SUBNET_STATE_SUFFIX = "-State";
    private static final double DEFAULT_SCREEN_SIZE_PERCENTAGE = 0.8;
    private static final int FRAME_OFFSET = 20;
    private static final String SM_THREAD_PREFIX = "smthread-";
    private final AtomicInteger threadCount = new AtomicInteger(1);
    private final String userName = "defaultuser";
    private final AppContext appContext;
    private final ICertsAssistant certsAssistant;
    protected final GraphicsDevice[] device;
    private final GraphicsDevice defaultDevice;
    private Rectangle lastBounds;
    protected boolean isFirstRun;
    protected LinkedHashMap<Long, SubnetDescription> subnets;
    private final Object tablesLock = new Object();
    protected final Map<SubnetDescription, Context> contexts = new HashMap<SubnetDescription, Context>();
    protected final Map<SubnetDescription, Rectangle> bounds = new HashMap<SubnetDescription, Rectangle>();
    protected final Map<SubnetDescription, Boolean> windowStates = new HashMap<SubnetDescription, Boolean>();
    protected final Map<String, Rectangle> savedBounds = new HashMap<String, Rectangle>();
    protected final Map<String, Boolean> savedStates = new HashMap<String, Boolean>();
    protected final AtomicReference<IFabricController> lastViewer = new AtomicReference<Object>(null);

    public SubnetManager(AppContext appContext, ICertsAssistant certsAssistant) {
        this.appContext = appContext;
        this.certsAssistant = certsAssistant;
        GraphicsEnvironment ge = this.getLocalGraphicsEnvironment();
        this.device = ge.getScreenDevices();
        this.defaultDevice = ge.getDefaultScreenDevice();
    }

    @Override
    public void init(boolean isFirstRun) {
        this.isFirstRun = isFirstRun;
        this.loadSubnets();
        this.loadFrameStates();
    }

    @Override
    public SubnetDescription saveSubnet(SubnetDescription subnet) throws SubnetDataNotFoundException {
        IFabricController controller;
        SubnetDescription ctxSubnet;
        if (subnet == null) {
            log.error("Attempting to save a null subnet");
            return null;
        }
        log.debug("saveSubnet {}", (Object)subnet);
        IConfigurationApi confApi = this.appContext.getConfigurationApi();
        if (subnet.getSubnetId() == 0L) {
            subnet.setLastStatus(SubnetDescription.Status.INVALID);
            SubnetDescription savedSubnet = confApi.defineSubnet(subnet);
            this.subnets.put(savedSubnet.getSubnetId(), savedSubnet);
            log.debug("New subnet: ", (Object)savedSubnet);
            this.resetConnectMenus();
            return savedSubnet;
        }
        Context context = this.contexts.get(subnet);
        if (context != null && (ctxSubnet = context.getSubnetDescription()).getSubnetId() == subnet.getSubnetId() && !ctxSubnet.getName().equalsIgnoreCase(subnet.getName()) && (controller = context.getController()) != null) {
            controller.resetSubnet(subnet);
        }
        this.resetConnectMenus();
        confApi.updateSubnet(subnet);
        return subnet;
    }

    @Override
    public void removeSubnet(SubnetDescription subnet) throws SubnetDataNotFoundException {
        log.debug("removeSubnet {}; subnets = {}", (Object)subnet, (Object)this.subnets.size());
        IConfigurationApi confApi = this.appContext.getConfigurationApi();
        long subnetId = subnet.getSubnetId();
        Context context = this.contexts.get(subnet);
        if (context != null) {
            context.setDeleted(true);
        }
        this.removeHost(subnet, false);
        confApi.removeSubnet(subnetId);
        this.subnets.remove(subnetId);
        this.resetConnectMenus();
    }

    private void resetConnectMenus() {
        for (Context context : this.contexts.values()) {
            IFabricController controller = context.getController();
            controller.resetConnectMenu();
        }
        if (this.lastViewer.get() != null) {
            this.lastViewer.get().resetConnectMenu();
        }
    }

    @Override
    public void saveUserSettings(String subnetName, UserSettings userSettings) {
        SubnetDescription subnet = this.getSubnet(subnetName);
        this.appContext.getConfigurationApi().saveUserSettings(subnetName, userSettings);
        Context context = this.contexts.get(subnet);
        if (context != null) {
            context.refreshUserSettings();
        }
    }

    @Override
    public String getHostIp(String hostName) throws SubnetConnectionException {
        return this.appContext.getConfigurationApi().getHostIp(hostName);
    }

    @Override
    public boolean isHostReachable(String hostName) {
        return this.appContext.getConfigurationApi().isHostReachable(hostName);
    }

    @Override
    public boolean isHostConnectable(SubnetDescription subnet) throws ConfigurationException {
        return this.appContext.getConfigurationApi().isHostConnectable(subnet);
    }

    @Override
    public boolean tryToConnect(SubnetDescription subnet) throws SubnetConnectionException {
        return this.appContext.getConfigurationApi().tryToConnect(subnet);
    }

    @Override
    public PMConfigBean getPMConfig(SubnetDescription subnet) {
        return this.appContext.getConfigurationApi().getPMConfig(subnet);
    }

    @Override
    public SubnetDescription getNewSubnet() {
        SubnetDescription newSubnet = new SubnetDescription();
        newSubnet.setSubnetId(0L);
        return newSubnet;
    }

    @Override
    public void startSubnet(String subnetName) throws SubnetConnectionException {
        SubnetDescription subnet = this.getSubnet(subnetName);
        this.startSubnet(subnet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopSubnet(String subnetName, boolean forceWindowClose) {
        log.debug("Stopping subnet '{}'. Existing contexts = {}", (Object)subnetName, (Object)this.contexts.size());
        try {
            if (subnetName != null) {
                SubnetDescription subnet = this.getSubnet(subnetName);
                this.removeHost(subnet, forceWindowClose);
            }
        }
        finally {
            if (!(subnetName != null || this.contexts.size() != 0 && this.hasRunningSubnetFrames())) {
                try {
                    this.saveFrameStates();
                }
                finally {
                    this.shutdownApplication();
                }
            }
        }
    }

    protected boolean hasRunningSubnetFrames() {
        Frame[] frames;
        for (Frame frame : frames = Frame.getFrames()) {
            if (!frame.isVisible() || !frame.getName().startsWith(STLConstants.K0001_FABRIC_VIEWER_TITLE.getValue())) continue;
            return true;
        }
        log.debug("No visible subnet frames!");
        return false;
    }

    protected void shutdownApplication() {
        this.startNewThread(new Runnable(){

            @Override
            public void run() {
                SubnetManager.this.appContext.shutdown();
            }
        });
    }

    @Override
    public void selectSubnet(String subnetName) throws SubnetConnectionException {
        this.startSubnet(subnetName);
    }

    @Override
    public List<SubnetDescription> getSubnets() {
        return Collections.unmodifiableList(new ArrayList<SubnetDescription>(this.subnets.values()));
    }

    @Override
    public boolean isFirstRun() {
        return this.isFirstRun;
    }

    @Override
    public UserSettings getUserSettings(String subnetName, String userName) throws UserNotFoundException {
        return this.appContext.getConfigurationApi().getUserSettings(subnetName, userName);
    }

    @Override
    public TaskScheduler getTaskScheduler(SubnetDescription subnet) {
        Context context = this.contexts.get(subnet);
        if (context == null) {
            return null;
        }
        return context.getTaskScheduler();
    }

    @Override
    public void saveLoggingConfiguration(LoggingConfiguration loggingConfig) {
        this.appContext.getConfigurationApi().saveLoggingConfiguration(loggingConfig);
    }

    @Override
    public LoggingConfiguration getLoggingConfig() {
        return this.appContext.getConfigurationApi().getLoggingConfig();
    }

    @Override
    public synchronized void startSubnets(SplashScreen splashScreen) {
        Rectangle bounds;
        IFabricController controller;
        AtomicBoolean splashClosed = new AtomicBoolean(false);
        List<SubnetDescription> toStart = this.getSubnetsToStart();
        if (toStart.size() == 0 && !this.isFirstRun) {
            controller = this.createFabricController(null);
            bounds = this.getBounds();
            this.lastViewer.set(controller);
            this.runInEDT(new Runnable(){

                @Override
                public void run() {
                    controller.doShowInitScreen(bounds, false);
                }
            });
        } else {
            StartSubnetsTask startSubnetsTask = this.createStartSubnetsTask(toStart, splashScreen);
            startSubnetsTask.execute();
            try {
                startSubnetsTask.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        if (this.isFirstRun) {
            controller = this.createFabricController(null);
            bounds = this.getBounds();
            this.lastViewer.set(controller);
            this.runInEDT(new Runnable(){

                @Override
                public void run() {
                    controller.doShowInitScreen(bounds, false);
                    controller.showSetupWizard(null);
                    SubnetManager.this.isFirstRun = false;
                }
            });
        }
        if (!splashClosed.get()) {
            splashScreen.close();
        }
    }

    @Override
    public void showSetupWizard(String subnetName, IFabricController controller) {
        IFabricView mainFrame = controller.getView();
        MultinetWizardController wizardController = MultinetWizardController.getInstance(mainFrame, this);
        SubnetDescription subnet = null;
        if (subnetName != null && subnetName.length() > 0) {
            subnet = this.getSubnet(subnetName);
        }
        if (subnet == null) {
            subnet = new SubnetDescription();
        }
        wizardController.showView(subnet, "defaultuser", controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        for (Context context : this.contexts.values()) {
            IFabricController controller = null;
            try {
                context.cleanup();
                controller = context.getController();
                if (controller == null) continue;
                controller.cleanup();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (controller == null) continue;
                this.closeViewer(controller);
            }
        }
        this.contexts.clear();
        this.subnets.clear();
    }

    @Override
    public void clearSubnetFactories(SubnetDescription subnet) {
        this.certsAssistant.clearSubnetFactories(subnet);
    }

    @Override
    public IConfigurationApi getConfigurationApi() {
        return this.appContext.getConfigurationApi();
    }

    @Override
    public void onFailoverCompleted(SubnetEvent event) {
    }

    @Override
    public void onFailoverFailed(SubnetEvent event) {
    }

    @Override
    public void onSubnetManagerConnected(SubnetEvent event) {
        SubnetDescription subnet = (SubnetDescription)event.getSource();
        VerifySubnetsTask verifyTask = new VerifySubnetsTask(subnet);
        verifyTask.execute();
    }

    @Override
    public void onSubnetManagerConnectionLost(SubnetEvent event) {
    }

    protected Context createContext(SubnetDescription subnet, IFabricController controller) throws Exception {
        try {
            SubnetContext subnetCtx = this.appContext.getSubnetContextFor(subnet, true);
            subnetCtx.addSubnetEventListener(this);
            return new Context(subnetCtx, controller, "defaultuser");
        }
        catch (Exception e) {
            log.error("Error creating Context for subnet '{}'", (Object)subnet.getName(), (Object)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHost(SubnetDescription subnet, boolean forceWindowClose) {
        Context context;
        IFabricController controller = null;
        Object object = this.tablesLock;
        synchronized (object) {
            context = this.contexts.remove(subnet);
            if (context != null) {
                controller = context.getController();
            }
            if (controller != null) {
                Rectangle frameBounds = controller.getBounds();
                boolean maximized = controller.isMaximized();
                if (frameBounds != null) {
                    this.bounds.put(subnet, frameBounds);
                    this.savedBounds.put(subnet.getName(), frameBounds);
                    this.windowStates.put(subnet, maximized);
                }
            }
        }
        if (context != null) {
            this.stopSubnet(controller, context, forceWindowClose);
        }
    }

    private void startSubnet(SubnetDescription subnet) throws SubnetConnectionException {
        ArrayList<SubnetDescription> toStart = new ArrayList<SubnetDescription>(1);
        toStart.add(subnet);
        StartSubnetsTask startSubnetsTask = this.createStartSubnetsTask(toStart, null);
        startSubnetsTask.execute();
    }

    private List<SubnetDescription> getSubnetsToStart() {
        ArrayList<SubnetDescription> startSubnets = new ArrayList<SubnetDescription>(this.subnets.values());
        ArrayList<SubnetDescription> autoConnectSubnets = new ArrayList<SubnetDescription>();
        Collections.sort(startSubnets, new Comparator<SubnetDescription>(){

            @Override
            public int compare(SubnetDescription o1, SubnetDescription o2) {
                return Long.compare(o1.getStatusTimestamp(), o2.getStatusTimestamp());
            }
        });
        for (SubnetDescription subnet : this.subnets.values()) {
            if (!subnet.isAutoConnect()) continue;
            autoConnectSubnets.add(subnet);
        }
        return autoConnectSubnets;
    }

    private void showInitialFrame(String subnetName, IFabricController controller) {
        Rectangle bounds = this.getBounds(subnetName);
        boolean maximized = this.getMaximized(subnetName);
        this.showInitScreen(controller, bounds, maximized);
    }

    private void showInitScreen(final IFabricController controller, final Rectangle bounds, final boolean maximized) {
        if (controller == null) {
            return;
        }
        this.runInEDT(new Runnable(){

            @Override
            public void run() {
                controller.doShowInitScreen(bounds, maximized);
            }
        });
    }

    private Rectangle getBounds(String subnetName) {
        if (subnetName == null) {
            return this.getBounds();
        }
        Rectangle bounds = this.savedBounds.get(subnetName);
        if (bounds != null) {
            if (!this.boundsDisplayable(bounds)) {
                bounds = this.getBounds();
            }
        } else {
            bounds = this.getBounds();
        }
        return bounds;
    }

    protected GraphicsEnvironment getLocalGraphicsEnvironment() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment();
    }

    protected boolean boundsDisplayable(Rectangle bounds) {
        boolean displayable = false;
        for (int i = 0; i < this.device.length; ++i) {
            if (!this.device[i].getDefaultConfiguration().getBounds().contains(bounds.getLocation())) continue;
            displayable = true;
            break;
        }
        return displayable;
    }

    private boolean getMaximized(String subnetName) {
        if (subnetName == null) {
            return false;
        }
        Boolean maximized = this.savedStates.get(subnetName);
        if (maximized == null) {
            return false;
        }
        return maximized;
    }

    private void saveFrameStates() {
        Properties subnetFrames = new Properties();
        AppInfo appInfo = this.appContext.getConfigurationApi().getAppInfo();
        appInfo.setProperty("SubnetFrames", subnetFrames);
        for (Long subnetId : this.subnets.keySet()) {
            SubnetDescription subnet = this.subnets.get(subnetId);
            Rectangle frameBounds = this.bounds.get(subnet);
            Boolean frameMaximized = this.windowStates.get(subnet);
            if (frameBounds == null || frameMaximized == null) continue;
            String subnetName = subnet.getName();
            subnetFrames.put(subnetName, subnetName);
            Properties frameLocation = new Properties();
            frameLocation.put("x", (Object)frameBounds.x);
            frameLocation.put("y", (Object)frameBounds.y);
            frameLocation.put("width", (Object)frameBounds.width);
            frameLocation.put("height", (Object)frameBounds.height);
            frameLocation.put("state", frameMaximized);
            appInfo.setProperty(subnetName + PROPERTIES_SUBNET_STATE_SUFFIX, frameLocation);
        }
        this.appContext.getConfigurationApi().saveAppInfo(appInfo);
    }

    private void loadFrameStates() {
        AppInfo appInfo = this.appContext.getConfigurationApi().getAppInfo();
        Map<String, Properties> appProps = appInfo.getPropertiesMap();
        Properties subnetFrames = appProps.get("SubnetFrames");
        if (subnetFrames != null) {
            for (Object key : subnetFrames.keySet()) {
                String subnetName = (String)key;
                Properties frameProps = appProps.get(subnetName + PROPERTIES_SUBNET_STATE_SUFFIX);
                if (frameProps == null) continue;
                try {
                    int x = Integer.parseInt(frameProps.getProperty("x"));
                    int y = Integer.parseInt(frameProps.getProperty("y"));
                    int width = Integer.parseInt(frameProps.getProperty("width"));
                    int height = Integer.parseInt(frameProps.getProperty("height"));
                    boolean maximized = Boolean.parseBoolean(frameProps.getProperty("state"));
                    Rectangle frameBounds = new Rectangle(x, y, width, height);
                    this.savedBounds.put(subnetName, frameBounds);
                    this.savedStates.put(subnetName, maximized);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    private Rectangle getBounds() {
        Rectangle frameBounds = null;
        GraphicsConfiguration screenConfig = this.defaultDevice.getDefaultConfiguration();
        Rectangle screenBounds = screenConfig.getBounds();
        if (this.lastBounds == null) {
            int width = (int)((double)screenBounds.width * 0.8);
            int height = (int)((double)screenBounds.height * 0.8);
            int x = screenBounds.x + (screenBounds.width - width) / 2;
            int y = screenBounds.y + (screenBounds.height - height) / 2;
            this.lastBounds = frameBounds = new Rectangle(x, y, width, height);
        } else {
            int x = this.lastBounds.x + 20;
            int y = this.lastBounds.y + 20;
            frameBounds = new Rectangle(x, y, this.lastBounds.width, this.lastBounds.height);
            if (!screenBounds.contains(frameBounds)) {
                if (x + this.lastBounds.width > screenBounds.x + screenBounds.width) {
                    x = screenBounds.x;
                }
                if (y + this.lastBounds.height > screenBounds.y + screenBounds.height) {
                    y = screenBounds.y;
                }
                frameBounds = new Rectangle(x, y, this.lastBounds.width, this.lastBounds.height);
            }
            this.lastBounds = frameBounds;
        }
        return frameBounds;
    }

    private void stopSubnet(final IFabricController controller, final Context context, final boolean forceWindowClose) {
        boolean keepLastViewer;
        boolean bl = keepLastViewer = this.contexts.size() == 0;
        if (keepLastViewer && controller != null) {
            this.lastViewer.set(controller);
        }
        final String subnetName = context.getSubnetDescription().getName();
        MDC.put((String)"subnet", (String)subnetName);
        final Map configMap = MDC.getCopyOfContextMap();
        MDC.remove((String)"subnet");
        this.startNewThread(new Runnable(){

            @Override
            public void run() {
                MDC.setContextMap((Map)configMap);
                try {
                    if (context != null) {
                        context.close();
                    }
                }
                finally {
                    try {
                        if (controller != null) {
                            if (keepLastViewer || !forceWindowClose) {
                                controller.reset();
                            } else {
                                controller.cleanup();
                            }
                        }
                    }
                    finally {
                        if (!keepLastViewer || forceWindowClose) {
                            log.info("Closing viewer for subnet '{}'", (Object)subnetName);
                            SubnetManager.this.closeViewer(controller);
                        }
                    }
                }
            }
        });
    }

    private void startNewThread(Runnable runnable) {
        Thread newThread = new Thread(runnable);
        String threadName = SM_THREAD_PREFIX + this.threadCount.getAndIncrement();
        newThread.setName(threadName);
        newThread.start();
    }

    private void closeViewer(final IFabricController controller) {
        if (controller == null) {
            return;
        }
        this.runInEDT(new Runnable(){

            @Override
            public void run() {
                controller.doClose();
            }
        });
    }

    private void loadSubnets() {
        List<SubnetDescription> dbSubnets = this.appContext.getSubnets();
        if (dbSubnets != null) {
            this.subnets = new LinkedHashMap();
            for (SubnetDescription dbSubnet : dbSubnets) {
                this.subnets.put(dbSubnet.getSubnetId(), dbSubnet);
            }
        }
    }

    private void restartViewer(SubnetDescription subnet, IFabricController controller, String existingHostId, String newHostId) {
        RestartViewerTask restarter = new RestartViewerTask("<html>This fabric viewer will restart</html>", this, subnet, existingHostId, newHostId);
        controller.addPendingTask(restarter);
    }

    protected IFabricController createFabricController(String subnetName) {
        FabricView view = new FabricView(new FVMainFrame(subnetName));
        MBassador eventBus = new MBassador(new IPublicationErrorHandler(){

            public void handleError(PublicationError error) {
                log.error(null, (Object)error);
                error.getCause().printStackTrace();
            }
        });
        FabricController controller = new FabricController(subnetName, view, this, (MBassador<IAppEvent>)eventBus);
        return controller;
    }

    @Override
    public SubnetDescription getSubnet(String subnetName) {
        for (SubnetDescription subnet : this.subnets.values()) {
            if (!subnet.getName().equalsIgnoreCase(subnetName)) continue;
            return subnet;
        }
        IllegalArgumentException iae = new IllegalArgumentException("Cannot find subnet with the name '" + subnetName + "'");
        throw iae;
    }

    @Override
    public void onEmailTest(String recipients) {
        if (recipients != null && !recipients.isEmpty()) {
            String subject = UILabels.STL92001_TEST_EMAIL_SUBJECT.getDescription();
            String body = "";
            List<String> recipientsList = Utils.concatenatedStringToList(recipients, ";");
            this.getConfigurationApi().submitMessage(subject, body, recipientsList);
        }
    }

    @Override
    public Context getContext(SubnetDescription subnetDescription) {
        return this.contexts.get(subnetDescription);
    }

    protected StartSubnetsTask createStartSubnetsTask(List<SubnetDescription> subnets, SplashScreen splashScreen) {
        return new StartSubnetsTask(subnets, splashScreen);
    }

    protected void runInEDT(Runnable runnable) {
        Util.runInEDT(runnable);
    }

    @Override
    public void cancelFailoverFor(String subnetName) {
        SubnetDescription subnet = this.getSubnet(subnetName);
        Context context = this.contexts.get(subnet);
        if (context != null) {
            context.cancelFailover();
        }
    }

    @Override
    public boolean isEmailValid(String email) {
        return this.getConfigurationApi().isEmailValid(email);
    }

    private class VerifySubnetsTask
    extends SwingWorker<Void, SubnetDescription> {
        private final SubnetDescription connectedSubnet;

        public VerifySubnetsTask(SubnetDescription connectedSubnet) {
            this.connectedSubnet = connectedSubnet;
        }

        @Override
        protected Void doInBackground() throws Exception {
            HostInfo hostInfo = this.connectedSubnet.getCurrentFE();
            String connIp = hostInfo.getInetAddress().getHostAddress();
            log.info("Verifying subnet '{}' connected to FE at {}", (Object)this.connectedSubnet.getName(), (Object)connIp);
            for (SubnetDescription subnet : SubnetManager.this.contexts.keySet()) {
                HostInfo currHost;
                String currIp;
                if (this.connectedSubnet.equals(subnet) || !connIp.equals(currIp = (currHost = subnet.getCurrentFE()).getInetAddress().getHostAddress()) || hostInfo.getPort() != currHost.getPort()) continue;
                System.out.println("Connected subnet " + this.connectedSubnet + "(" + connIp + ") connects to the same FE than subnet " + subnet + ")");
            }
            return null;
        }
    }

    protected class StartSubnetsTask
    extends SwingWorker<Void, SubnetDescription> {
        private final List<SubnetDescription> subnets;
        private final SplashScreen splashScreen;
        private final List<Throwable> errors = new ArrayList<Throwable>();
        private IFabricController lastController;
        private boolean splashClosed = false;
        private final Map<String, String> loggingContextMap;

        public StartSubnetsTask(List<SubnetDescription> subnets, SplashScreen splashScreen) {
            this.subnets = subnets;
            this.splashScreen = splashScreen;
            MDC.put((String)"subnet", (String)"all");
            MDC.remove((String)"subnet");
            this.loggingContextMap = MDC.getCopyOfContextMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Void doInBackground() throws Exception {
            MDC.setContextMap(this.loggingContextMap);
            for (SubnetDescription subnet : this.subnets) {
                try {
                    Context context;
                    IFabricController newController = null;
                    Object object = SubnetManager.this.tablesLock;
                    synchronized (object) {
                        context = SubnetManager.this.contexts.get(subnet);
                        if (context == null) {
                            IFabricController lastController = SubnetManager.this.lastViewer.get();
                            IFabricController tempController = lastController != null && lastController.getCurrentContext() == null ? (SubnetManager.this.lastViewer.compareAndSet(lastController, null) ? lastController : (newController = SubnetManager.this.createFabricController(subnet.getName()))) : (newController = SubnetManager.this.createFabricController(subnet.getName()));
                            Context newContext = SubnetManager.this.createContext(subnet, tempController);
                            SubnetManager.this.contexts.put(subnet, newContext);
                            newContext.addSubnetEventListener(tempController);
                            this.lastController = tempController;
                        }
                    }
                    if (context == null) {
                        if (newController != null) {
                            SubnetManager.this.showInitialFrame(subnet.getName(), newController);
                        }
                        this.publish(subnet);
                        continue;
                    }
                    if (!context.isValid()) {
                        IFabricController controller = context.getController();
                        context = SubnetManager.this.createContext(subnet, controller);
                        object = SubnetManager.this.tablesLock;
                        synchronized (object) {
                            SubnetManager.this.contexts.put(subnet, context);
                        }
                        context.addSubnetEventListener(controller);
                        this.publish(subnet);
                        continue;
                    }
                    this.checkSubnetAlreadyDisplayed(subnet.getName(), context);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.errors.add(e);
                }
            }
            return null;
        }

        @Override
        protected void done() {
            if (this.errors.size() > 0) {
                if (this.lastController == null) {
                    this.lastController = SubnetManager.this.createFabricController(null);
                    SubnetManager.this.showInitialFrame(null, this.lastController);
                }
                Util.showErrors((Component)((Object)this.lastController.getView()), this.errors);
            }
        }

        @Override
        protected void process(List<SubnetDescription> subnets) {
            for (SubnetDescription subnet : subnets) {
                log.info("Starting subnet {}", (Object)subnet.getName());
                IFabricController controller = null;
                Context context = SubnetManager.this.contexts.get(subnet);
                if (context != null) {
                    controller = context.getController();
                }
                if (controller != null) {
                    controller.doShowContent();
                    controller.initializeContext(context);
                }
                if (this.splashClosed) continue;
                if (this.splashScreen != null) {
                    this.splashScreen.close();
                }
                this.splashClosed = true;
            }
        }

        private void checkSubnetAlreadyDisplayed(String subnetName, Context context) {
            IFabricController controller = context.getController();
            controller.bringToFront();
            SubnetDescription targetSubnet = context.getSubnetDescription();
            if (!subnetName.equalsIgnoreCase(targetSubnet.getName())) {
                log.debug("Subnet " + subnetName + " definition resolves to this subnet " + targetSubnet.getName());
                StringBuffer sb = new StringBuffer();
                sb.append("Specified subnet '");
                sb.append(subnetName);
                sb.append("' resolves to this subnet '");
                sb.append(targetSubnet.getName());
                sb.append("'");
                ShowWarningTask warn = new ShowWarningTask(sb.toString());
                controller.addPendingTask(warn);
            }
        }
    }
}

