/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.api.StringUtils;
import com.intel.stl.ui.common.IPageController;
import com.intel.stl.ui.common.ProgressObserver;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.framework.AbstractTask;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.FabricModel;
import com.intel.stl.ui.monitor.tree.FVTreeManager;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubnetRefreshTask
extends AbstractTask<FabricModel, Void, String> {
    private static Logger log = LoggerFactory.getLogger(SubnetRefreshTask.class);
    private final Context context;
    private final List<IPageController> pages;
    private final FVTreeManager builder;

    public SubnetRefreshTask(FabricModel model, FVTreeManager builder, List<IPageController> pages, Context context) {
        super(model);
        this.pages = pages;
        this.builder = builder;
        this.context = context;
    }

    @Override
    public Void processInBackground(Context context) throws Exception {
        log.info("Refresh subnet '" + ((FabricModel)this.model).getCurrentSubnet() + "'");
        context.reset();
        this.builder.setDirty();
        for (int i = 0; i < this.pages.size(); ++i) {
            IPageController page = this.pages.get(i);
            this.setProgressNote(UILabels.STL10111_REFRESHING_PAGE.getDescription(page.getName()));
            short estimatedWork = page.getRefreshWeight().getWeight();
            ProgressObserver observer = new ProgressObserver(this, estimatedWork);
            page.onRefresh(observer);
            observer.onFinish();
        }
        return null;
    }

    @Override
    public void onTaskSuccess(Void result) {
        this.getController().notifyModelChanged();
    }

    @Override
    public void onTaskFailure(Throwable caught) {
        ((FabricModel)this.model).setErrorMessage(StringUtils.getErrorMessage(caught));
        this.getController().notifyModelUpdateFailed(caught);
    }

    @Override
    public void onFinally() {
    }

    @Override
    public void processIntermediateResults(List<String> intermediateResults) {
    }

    protected void setProgressNote(String note) {
        this.firePropertyChange("ProgressNote", null, note);
    }
}

