/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ImagePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.swingx.JXHyperlink;

public class AboutDialog
extends JDialog {
    private static final long serialVersionUID = 7460752071806970217L;
    private JPanel rightMainPanel;
    private JPanel topBanner;
    private JLabel appNameLabel;
    private JLabel appBuildIdLabel;
    private JLabel appBuildDateLabel;
    private JPanel mainContentPanel;
    private JXHyperlink copyrightBtn;
    private JXHyperlink thirdPartyBtn;
    private JButton okBtn;
    private JEditorPane editor;
    private static AboutDialog dlgInstance;
    private final Color bgColor = UIConstants.INTEL_WHITE;
    private final Color tabBgColor = UIConstants.INTEL_SKY_BLUE;
    private final String appNameStr;
    private final String appBuildIdStr;
    private final String appBuildDateStr;
    private final String appVersion;
    private boolean desktopBrowseSupported = true;

    private AboutDialog(JFrame parent, String appName, String appVersion, String appBuildId, String appBuildDate) {
        super(parent, STLConstants.K3100_ABOUT_DIALOG.getValue() + " " + appName, true);
        this.appNameStr = appName;
        this.appVersion = appVersion;
        this.appBuildIdStr = appBuildId;
        this.appBuildDateStr = appBuildDate;
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 300));
        this.setSize(600, 450);
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        Container container = this.getContentPane();
        container.setBackground(this.bgColor);
        container.setLayout(new BorderLayout(0, 0));
        ImagePanel leftBanner = new ImagePanel(UIImages.ABOUT_DIALOG_LEFT_BANNER_IMG.getImage(), ImagePanel.Style.FIT_IMAGE_WIDTH);
        leftBanner.setOpaque(false);
        container.add((Component)leftBanner, "West");
        JPanel rightMainPanel = this.getRightMainPanel();
        container.add((Component)rightMainPanel, "Center");
    }

    protected JPanel getRightMainPanel() {
        if (this.rightMainPanel == null) {
            this.rightMainPanel = new JPanel(new BorderLayout());
            this.rightMainPanel.setOpaque(false);
            JPanel topBanner = this.getTopBanner();
            this.rightMainPanel.add((Component)topBanner, "North");
            JPanel contentPanel = this.getMainContentPanel();
            this.rightMainPanel.add((Component)contentPanel, "Center");
            JPanel panel = new JPanel(new FlowLayout(4));
            panel.setOpaque(false);
            this.okBtn = new JButton(STLConstants.K0645_OK.getValue());
            this.okBtn.setName(WidgetName.ABOUT_OK.name());
            this.okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AboutDialog.this.dispose();
                }
            });
            this.okBtn.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    JComponent component = event.getComponent();
                    component.requestFocusInWindow();
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }
            });
            panel.add(this.okBtn);
            this.rightMainPanel.add((Component)panel, "South");
            this.showCopyright();
        }
        return this.rightMainPanel;
    }

    protected JPanel getTopBanner() {
        if (this.topBanner == null) {
            this.topBanner = new ImagePanel(UIImages.ABOUT_DIALOG_TOP_BANNER_IMG.getImage(), ImagePanel.Style.FIT_PANEL);
            this.topBanner.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.insets = new Insets(2, 2, 2, 2);
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.gridwidth = 0;
            gc.fill = 1;
            this.appNameLabel = new JLabel(UILabels.STL91000_ABOUT_APP.getDescription(this.appNameStr, this.appVersion));
            this.appNameLabel.setName(WidgetName.ABOUT_PRODUCT_NAME_VERSION.name());
            this.appNameLabel.setFont(UIConstants.H2_FONT.deriveFont(1));
            this.appNameLabel.setForeground(UIConstants.INTEL_WHITE);
            this.appNameLabel.setHorizontalAlignment(0);
            this.appNameLabel.setVerticalAlignment(0);
            this.appNameLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.topBanner.add((Component)this.appNameLabel, gc);
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            gc.gridwidth = 1;
            this.appBuildIdLabel = new JLabel(UILabels.STL91001_BUILD_ID.getDescription(this.appBuildIdStr));
            gc.weightx = 1.0;
            this.topBanner.add(Box.createGlue(), gc);
            gc.weightx = 0.0;
            gc.gridwidth = 0;
            this.appBuildDateLabel = new JLabel(UILabels.STL91002_BUILD_DATE.getDescription(this.appBuildDateStr));
            this.appBuildDateLabel.setName(WidgetName.ABOUT_BUILD_DATE.name());
            this.appBuildDateLabel.setFont(UIConstants.H5_FONT);
            this.appBuildDateLabel.setForeground(UIConstants.INTEL_WHITE);
            this.appBuildDateLabel.setHorizontalTextPosition(10);
            this.topBanner.add((Component)this.appBuildDateLabel, gc);
        }
        return this.topBanner;
    }

    protected JPanel getMainContentPanel() {
        if (this.mainContentPanel == null) {
            this.mainContentPanel = new JPanel(new BorderLayout());
            this.mainContentPanel.setOpaque(false);
            if (!Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                this.desktopBrowseSupported = false;
            }
            JPanel ctrPanel = new JPanel(new FlowLayout(3, 10, 0));
            ctrPanel.setBackground(this.tabBgColor);
            ctrPanel.setBorder(BorderFactory.createMatteBorder(5, 0, 0, 0, UIConstants.INTEL_ORANGE));
            this.copyrightBtn = new JXHyperlink((Action)new AbstractAction(STLConstants.K3101_COPYRIGHT.getValue()){
                private static final long serialVersionUID = -7817099734925336713L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AboutDialog.this.showCopyright();
                }
            });
            this.copyrightBtn.setOpaque(true);
            this.copyrightBtn.setBorder(BorderFactory.createEmptyBorder(2, 10, 3, 10));
            this.copyrightBtn.setFont(UIConstants.H4_FONT.deriveFont(1));
            ctrPanel.add((Component)this.copyrightBtn);
            this.thirdPartyBtn = new JXHyperlink((Action)new AbstractAction(STLConstants.K3102_THIRD_PARTY_LIBS.getValue()){
                private static final long serialVersionUID = 8193708188358869864L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AboutDialog.this.showThirdParty();
                }
            });
            this.thirdPartyBtn.setOpaque(true);
            this.thirdPartyBtn.setBorder(BorderFactory.createEmptyBorder(2, 10, 3, 10));
            this.thirdPartyBtn.setFont(UIConstants.H4_FONT.deriveFont(1));
            ctrPanel.add((Component)this.thirdPartyBtn);
            this.mainContentPanel.add((Component)ctrPanel, "North");
            JEditorPane editor = this.getEditorPane();
            JScrollPane scrollPane = new JScrollPane(editor);
            scrollPane.setBorder(BorderFactory.createMatteBorder(0, 2, 2, 2, UIConstants.INTEL_WHITE));
            this.mainContentPanel.add((Component)scrollPane, "Center");
        }
        return this.mainContentPanel;
    }

    protected JEditorPane getEditorPane() {
        if (this.editor == null) {
            this.editor = new JEditorPane();
            this.editor.setBackground(this.bgColor);
            this.editor.setEditable(false);
            this.editor.setEditorKit(JEditorPane.createEditorKitForContentType("text/html"));
            this.editor.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if (Desktop.isDesktopSupported()) {
                            try {
                                Desktop.getDesktop().browse(e.getURL().toURI());
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        } else {
                            System.err.println("Unsupported Desktop");
                        }
                    }
                }
            });
        }
        return this.editor;
    }

    public static void showAboutDialog(JFrame parent, String appName, String appVersion, String appBuildId, String appBuildDate) {
        if (dlgInstance == null) {
            dlgInstance = new AboutDialog(parent, appName, appVersion, appBuildId, appBuildDate);
        }
        dlgInstance.setVisible(true);
    }

    protected void showCopyright() {
        this.copyrightBtn.setForeground(UIConstants.INTEL_DARK_GRAY);
        this.copyrightBtn.setBackground(UIConstants.INTEL_WHITE);
        this.thirdPartyBtn.setForeground(UIConstants.INTEL_BLUE);
        this.thirdPartyBtn.setBackground(this.tabBgColor);
        String copyrightFileName = this.desktopBrowseSupported ? "/help/Copyright.html" : "/help/CopyrightLite.html";
        URL copyrightURL = this.getClass().getResource(copyrightFileName);
        if (copyrightURL != null) {
            try {
                this.editor.setPage(copyrightURL);
            }
            catch (IOException ioe) {
                System.err.println("Copyright.html file is not found.");
                ioe.printStackTrace();
            }
        }
        this.okBtn.requestFocusInWindow();
    }

    protected void showThirdParty() {
        this.thirdPartyBtn.setForeground(UIConstants.INTEL_DARK_GRAY);
        this.thirdPartyBtn.setBackground(UIConstants.INTEL_WHITE);
        this.copyrightBtn.setForeground(UIConstants.INTEL_BLUE);
        this.copyrightBtn.setBackground(this.tabBgColor);
        String thirdPartyFileName = this.desktopBrowseSupported ? "/help/ThirdPartyJars.html" : "/help/ThirdPartyJarsLite.html";
        URL otherJarsURL = this.getClass().getResource(thirdPartyFileName);
        if (otherJarsURL != null) {
            try {
                this.editor.setPage(otherJarsURL);
            }
            catch (IOException ioe) {
                System.err.println("ThirdPartyJars.html file is not found.");
                ioe.printStackTrace();
            }
        }
        this.okBtn.requestFocusInWindow();
    }
}

