/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.view.ComponentFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CertsPanel
extends JPanel {
    private static final long serialVersionUID = 1430723933878902327L;
    private JFileChooser chooser;
    private StorePanel keyStorePanel;
    private StorePanel trustStorePanel;

    public CertsPanel() {
        this.initComponents();
    }

    protected void initComponents() {
        this.setBackground(UIConstants.INTEL_WHITE);
        this.setLayout(new GridLayout(2, 1, 0, 5));
        this.chooser = new JFileChooser();
        this.keyStorePanel = new StorePanel(STLConstants.K2001_KEY_STORE.getValue(), this.chooser);
        this.add(this.keyStorePanel);
        this.trustStorePanel = new StorePanel(STLConstants.K2002_TRUST_STORE.getValue(), this.chooser);
        this.add(this.trustStorePanel);
    }

    public void reset() {
        this.keyStorePanel.reset();
        this.trustStorePanel.reset();
    }

    public void setKeyStoreLocation(String location) {
        this.keyStorePanel.setStoreLocation(location);
    }

    public String getKeyStoreLocation() {
        return this.keyStorePanel.getStoreLocation();
    }

    public char[] getKeyStorePwd() {
        return this.keyStorePanel.getStorePassword();
    }

    public void setKeyStoreLocError(String msg) {
        this.keyStorePanel.setLocError(msg);
    }

    public void setKeyStorePwdError(String msg) {
        this.keyStorePanel.setPwdError(msg);
    }

    public void setTrustStoreLocation(String location) {
        this.trustStorePanel.setStoreLocation(location);
    }

    public String getTrustStoreLocation() {
        return this.trustStorePanel.getStoreLocation();
    }

    public char[] getTrustStorePwd() {
        return this.trustStorePanel.getStorePassword();
    }

    public void setTrustStoreLocError(String msg) {
        this.trustStorePanel.setLocError(msg);
    }

    public void setTrustStorePwdError(String msg) {
        this.trustStorePanel.setPwdError(msg);
    }

    class ErrorCorrectListener
    implements DocumentListener {
        private final JPanel parent;
        private final JTextField field;
        private final JLabel errorLabel;

        public ErrorCorrectListener(JPanel parent, JTextField field, JLabel errorLabel) {
            this.parent = parent;
            this.field = field;
            this.errorLabel = errorLabel;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.clearError();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.clearError();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.clearError();
        }

        protected void clearError() {
            if (!this.errorLabel.getText().isEmpty()) {
                this.errorLabel.setText(" ");
                this.field.setBackground(UIConstants.INTEL_WHITE);
                this.parent.revalidate();
            }
        }
    }

    class StorePanel
    extends JPanel {
        private static final long serialVersionUID = -4039456864583682621L;
        private final String title;
        private JTextField location;
        private JLabel locErrLabel;
        private ErrorCorrectListener locDocListener;
        private JButton browseBtn;
        private JPasswordField password;
        private JLabel pwdErrLabel;
        private ErrorCorrectListener pwdDocListener;
        private JFileChooser chooser;

        public StorePanel(String title, JFileChooser chooser) {
            this.title = title;
            this.chooser = chooser;
            this.initComponents();
            this.installListeners();
        }

        protected void initComponents() {
            this.setBackground(UIConstants.INTEL_WHITE);
            GridBagLayout gridBag = new GridBagLayout();
            this.setLayout(gridBag);
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 1;
            gc.insets = new Insets(2, 2, 8, 2);
            gc.gridy = 0;
            gc.gridx = 0;
            gc.gridwidth = 0;
            JLabel label = ComponentFactory.getH4Label(this.title, 1);
            label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIConstants.INTEL_ORANGE));
            this.add((Component)label, gc);
            ++gc.gridy;
            gc.gridwidth = 1;
            gc.insets = new Insets(2, 10, 1, 2);
            label = ComponentFactory.getFieldLabel(STLConstants.K0641_FILE_LOC.getValue());
            this.add((Component)label, gc);
            gc.weightx = 1.0;
            ++gc.gridx;
            gc.insets = new Insets(2, 2, 1, 5);
            this.location = new JTextField(24);
            this.location.setBackground(UIConstants.INTEL_WHITE);
            this.add((Component)this.location, gc);
            gc.weightx = 0.0;
            ++gc.gridx;
            gc.insets = new Insets(2, 2, 1, 2);
            this.browseBtn = ComponentFactory.getImageButton(UIImages.FOLDER_ICON.getImageIcon());
            this.browseBtn.setToolTipText(STLConstants.K0642_BROWSE.getValue());
            this.browseBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int returnVal;
                    String fileLoc;
                    if (StorePanel.this.chooser == null) {
                        StorePanel.this.chooser = new JFileChooser();
                    }
                    if (!(fileLoc = StorePanel.this.location.getText()).isEmpty()) {
                        File file = new File(fileLoc);
                        StorePanel.this.chooser.setCurrentDirectory(file.getParentFile());
                    }
                    if ((returnVal = StorePanel.this.chooser.showOpenDialog(StorePanel.this)) == 0) {
                        StorePanel.this.location.setText(StorePanel.this.chooser.getSelectedFile().getAbsolutePath());
                    }
                }
            });
            this.add((Component)this.browseBtn, gc);
            gc.gridx = 1;
            ++gc.gridy;
            gc.insets = new Insets(1, 2, 2, 2);
            gc.gridwidth = 0;
            this.locErrLabel = this.cerateErrLabel();
            this.add((Component)this.locErrLabel, gc);
            gc.gridx = 0;
            ++gc.gridy;
            gc.gridwidth = 1;
            gc.insets = new Insets(4, 10, 1, 2);
            label = ComponentFactory.getFieldLabel(STLConstants.K1049_PASSWORD.getValue());
            this.add((Component)label, gc);
            ++gc.gridx;
            gc.fill = 0;
            gc.anchor = 17;
            gc.insets = new Insets(4, 2, 1, 5);
            gc.weightx = 1.0;
            gc.gridwidth = 0;
            this.password = new JPasswordField(12);
            this.password.setBackground(UIConstants.INTEL_WHITE);
            this.add((Component)this.password, gc);
            gc.gridx = 1;
            ++gc.gridy;
            gc.insets = new Insets(1, 2, 2, 2);
            this.pwdErrLabel = this.cerateErrLabel();
            this.password.getDocument().addDocumentListener(new ErrorCorrectListener(this, this.password, this.pwdErrLabel));
            this.add((Component)this.pwdErrLabel, gc);
        }

        protected JLabel cerateErrLabel() {
            JLabel label = ComponentFactory.getFieldContent(" ");
            label.setForeground(UIConstants.INTEL_DARK_RED);
            return label;
        }

        protected void installListeners() {
            this.locDocListener = new ErrorCorrectListener(this, this.location, this.locErrLabel);
            this.location.getDocument().addDocumentListener(this.locDocListener);
            this.pwdDocListener = new ErrorCorrectListener(this, this.password, this.pwdErrLabel);
            this.password.getDocument().addDocumentListener(this.pwdDocListener);
        }

        public void reset() {
            this.location.setText(null);
            this.locDocListener.clearError();
            this.password.setText(null);
            this.pwdDocListener.clearError();
        }

        public void setLocError(String msg) {
            this.locErrLabel.setText(msg);
            this.location.setBackground(UIConstants.INTEL_LIGHT_RED);
            this.revalidate();
        }

        public void setPwdError(String msg) {
            this.pwdErrLabel.setText(msg);
            this.password.setBackground(UIConstants.INTEL_LIGHT_RED);
            this.revalidate();
        }

        public void setStoreLocation(String loc) {
            this.location.setText(loc);
        }

        public String getStoreLocation() {
            return this.location.getText();
        }

        public char[] getStorePassword() {
            char[] res = this.password.getPassword();
            return res;
        }
    }
}

