/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.main.view.AbstractPacketChartRangeUpdater;
import com.intel.stl.ui.main.view.ShiftedNumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;

public class PacketRateChartRangeUpdater
extends AbstractPacketChartRangeUpdater {
    @Override
    public TickUnitSource createTickUnits(long upper) {
        long tenMultiplier;
        long upperOrig = upper;
        long numOfTicks = 10L;
        for (tenMultiplier = 1L; upper >= 10L && tenMultiplier < 0xCCCCCCCCCCCCCCCL; tenMultiplier *= 10L, upper /= 10L) {
        }
        if (tenMultiplier >= 1000000000L) {
            this.tickUnit = 1000000000L;
            this.unitStr = STLConstants.K0753_GPPS.getValue();
            this.unitDes = STLConstants.K3307_GPPS_DESCRIPTION.getValue();
        } else if (tenMultiplier >= 1000000L) {
            this.tickUnit = 1000000L;
            this.unitStr = STLConstants.K0752_MPPS.getValue();
            this.unitDes = STLConstants.K3306_MPPS_DESCRIPTION.getValue();
        } else if (tenMultiplier >= 1000L) {
            this.tickUnit = 1000L;
            this.unitStr = STLConstants.K0751_KPPS.getValue();
            this.unitDes = STLConstants.K3305_KPPS_DESCRIPTION.getValue();
        } else {
            this.tickUnit = 1L;
            this.unitStr = STLConstants.K0750_PPS.getValue();
            this.unitDes = STLConstants.K3304_PPS_DESCRIPTION.getValue();
            return null;
        }
        TickUnits units = new TickUnits();
        double unit = Math.max(upperOrig / (numOfTicks * this.tickUnit), 1L) * this.tickUnit;
        units.add((TickUnit)new ShiftedNumberTickUnit(unit, this.tickUnit));
        return units;
    }
}

