/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main.view;

import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;

public class SplashScreen
extends JWindow {
    private static final long serialVersionUID = 1L;
    private ImageIcon imageIcon = null;
    private final BorderLayout borderLayout = new BorderLayout();
    private final JLabel imageLabel = new JLabel();
    private final JProgressBar progressBar = new JProgressBar(0, 100);
    private boolean closed = false;

    public SplashScreen() {
        this.imageLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 3, 0));
        this.setAlwaysOnTop(true);
        this.setLayout(this.borderLayout);
        this.add((Component)this.imageLabel, "Center");
        this.add((Component)this.progressBar, "South");
        this.setSplashImage();
    }

    public void setSplashImage() {
        this.imageIcon = UIImages.SPLASH_IMAGE.getImageIcon();
        this.imageLabel.setIcon(this.imageIcon);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void setShutdownImage() {
        this.imageIcon = UIImages.SHUTDOWN_IMAGE.getImageIcon();
        this.imageLabel.setIcon(this.imageIcon);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void showScreen() {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                SplashScreen.this.closed = false;
                SplashScreen.this.setVisible(true);
            }
        });
    }

    public void close() {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                SplashScreen.this.closed = true;
                SplashScreen.this.setVisible(false);
                SplashScreen.this.dispose();
            }
        });
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setProgress(final int progress) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                SplashScreen.this.progressBar.setValue(progress);
            }
        });
    }

    public void setProgress(final String message) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                if (message == null) {
                    SplashScreen.this.progressBar.setStringPainted(false);
                } else {
                    SplashScreen.this.progressBar.setStringPainted(true);
                }
                SplashScreen.this.progressBar.setString(message);
            }
        });
    }

    public void setProgress(final String message, final int progress) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                SplashScreen.this.setProgress(progress);
                SplashScreen.this.setProgress(message);
            }
        });
    }
}

