/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.model.NodeTypeViz;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class StaDetailsPanel
extends JPanel {
    private static final long serialVersionUID = -8248761594760146918L;
    private static final double[] STATE_THRESHOLDS = new double[]{0.2, 0.5, 1.0};
    private static final Color[] STATE_COLORS = new Color[]{UIConstants.INTEL_GRAY, UIConstants.INTEL_LIGHT_GRAY, UIConstants.INTEL_TABLE_BORDER_GRAY};
    private final NodeTypeViz[] types;
    private JLabel numberLabel;
    private JLabel nameLabel;
    private ChartPanel failedChartPanel;
    private JLabel failedNumberLabel;
    private JLabel failedNameLabel;
    private ChartPanel skippedChartPanel;
    private JLabel skippedNumberLabel;
    private JLabel skippedNameLabel;
    private ChartPanel typeChartPanel;
    private JLabel[] typeNumberLabels;
    private JLabel[] typeNameLabels;

    public StaDetailsPanel(NodeTypeViz[] types) {
        this.types = types;
        this.initComponent();
    }

    protected void initComponent() {
        this.setLayout(new BorderLayout(0, 10));
        this.setOpaque(false);
        this.setBorder(BorderFactory.createTitledBorder((Border)null));
        JPanel titlePanel = new JPanel(new BorderLayout(5, 1));
        titlePanel.setOpaque(false);
        this.numberLabel = ComponentFactory.getH1Label(STLConstants.K0039_NOT_AVAILABLE.getValue(), 0);
        this.numberLabel.setName(WidgetName.HP_STA_SUM_TOTAL.name());
        this.numberLabel.setHorizontalAlignment(4);
        titlePanel.add((Component)this.numberLabel, "Center");
        this.nameLabel = ComponentFactory.getH3Label("", 0);
        this.nameLabel.setName(WidgetName.HP_STA_SUM_NAME.name());
        this.nameLabel.setHorizontalAlignment(2);
        this.nameLabel.setVerticalAlignment(3);
        titlePanel.add((Component)this.nameLabel, "East");
        this.add((Component)titlePanel, "North");
        JPanel mainPanel = new JPanel();
        mainPanel.setOpaque(false);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        GridBagLayout gridBag = new GridBagLayout();
        mainPanel.setLayout(gridBag);
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(2, 2, 2, 2);
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridwidth = 1;
        gc.weighty = 0.0;
        this.failedChartPanel = new ChartPanel(null);
        this.failedChartPanel.setName(WidgetName.HP_STA_SUM_FAILED_CHART.name());
        this.failedChartPanel.setPreferredSize(new Dimension(60, 20));
        mainPanel.add((Component)this.failedChartPanel, gc);
        gc.fill = 1;
        gc.weightx = 0.0;
        this.failedNumberLabel = ComponentFactory.getH2Label(STLConstants.K0039_NOT_AVAILABLE.getValue(), 1);
        this.failedNumberLabel.setName(WidgetName.HP_STA_SUM_FAILED_NUM.name());
        this.failedNumberLabel.setForeground(UIConstants.INTEL_DARK_RED);
        this.failedNumberLabel.setHorizontalAlignment(0);
        mainPanel.add((Component)this.failedNumberLabel, gc);
        gc.gridwidth = 0;
        this.failedNameLabel = ComponentFactory.getH5Label(STLConstants.K0140_NO_RESP.getValue(), 0);
        this.failedNameLabel.setVerticalAlignment(3);
        mainPanel.add((Component)this.failedNameLabel, gc);
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridwidth = 1;
        this.skippedChartPanel = new ChartPanel(null);
        this.skippedChartPanel.setName(WidgetName.HP_STA_SUM_SKIPPED_CHART.name());
        this.skippedChartPanel.setPreferredSize(new Dimension(60, 20));
        mainPanel.add((Component)this.skippedChartPanel, gc);
        gc.fill = 1;
        gc.weightx = 0.0;
        this.skippedNumberLabel = ComponentFactory.getH2Label(STLConstants.K0039_NOT_AVAILABLE.getValue(), 1);
        this.skippedNumberLabel.setName(WidgetName.HP_STA_SUM_SKIPPED_NUM.name());
        this.skippedNumberLabel.setForeground(UIConstants.INTEL_DARK_ORANGE);
        this.skippedNumberLabel.setHorizontalAlignment(0);
        mainPanel.add((Component)this.skippedNumberLabel, gc);
        gc.gridwidth = 0;
        this.skippedNameLabel = ComponentFactory.getH5Label(STLConstants.K0021_SKIPPED.getValue(), 0);
        this.skippedNameLabel.setVerticalAlignment(3);
        mainPanel.add((Component)this.skippedNameLabel, gc);
        gc.weighty = 0.0;
        gc.fill = 0;
        gc.insets = new Insets(8, 2, 2, 2);
        gc.weightx = 1.0;
        gc.gridwidth = 1;
        gc.gridheight = this.types.length;
        this.typeChartPanel = new ChartPanel(null);
        this.typeChartPanel.setName(WidgetName.HP_STA_SUM_TYPE_CHART.name());
        this.typeChartPanel.setPreferredSize(new Dimension(80, 60));
        mainPanel.add((Component)this.typeChartPanel, gc);
        this.typeNumberLabels = new JLabel[this.types.length];
        this.typeNameLabels = new JLabel[this.types.length];
        gc.fill = 1;
        gc.gridheight = 1;
        gc.insets = new Insets(12, 2, 2, 2);
        for (int i = 0; i < this.types.length; ++i) {
            if (i == 1) {
                gc.insets = new Insets(2, 2, 2, 2);
            }
            gc.weightx = 0.0;
            gc.gridwidth = 1;
            this.typeNumberLabels[i] = this.createNumberLabel();
            this.typeNumberLabels[i].setName(WidgetName.HP_STA_SUM_TYPE_NUM_.name() + i);
            mainPanel.add((Component)this.typeNumberLabels[i], gc);
            gc.gridwidth = 0;
            this.typeNameLabels[i] = this.createNameLabel(this.types[i].getName());
            this.typeNameLabels[i].setName(WidgetName.HP_STA_SUM_TYPE_NAME_.name() + i);
            mainPanel.add((Component)this.typeNameLabels[i], gc);
        }
        gc.fill = 1;
        mainPanel.add(Box.createGlue(), gc);
        this.add((Component)mainPanel, "Center");
    }

    private JLabel createNumberLabel() {
        JLabel label = ComponentFactory.getH4Label(STLConstants.K0039_NOT_AVAILABLE.getValue(), 0);
        label.setHorizontalAlignment(4);
        label.setVerticalAlignment(3);
        return label;
    }

    private JLabel createNameLabel(String name) {
        JLabel label = ComponentFactory.getH5Label(name, 0);
        label.setVerticalAlignment(3);
        return label;
    }

    public NodeTypeViz[] getTypes() {
        return this.types;
    }

    public void setNameLabel(String name) {
        this.nameLabel.setText(name);
    }

    public void setFailedDataset(DefaultCategoryDataset dataset) {
        JFreeChart chart = ComponentFactory.createBulletChart((CategoryDataset)dataset, STATE_THRESHOLDS, STATE_COLORS);
        this.failedChartPanel.setChart(chart);
    }

    public void setSkipedDataset(DefaultCategoryDataset dataset) {
        JFreeChart chart = ComponentFactory.createBulletChart((CategoryDataset)dataset, STATE_THRESHOLDS, STATE_COLORS);
        this.skippedChartPanel.setChart(chart);
    }

    public void setTypeDataset(DefaultPieDataset dataset, Color[] colors) {
        JFreeChart chart = ComponentFactory.createPlainPieChart((PieDataset)dataset, colors);
        this.typeChartPanel.setChart(chart);
    }

    public void setTotalNumber(String value) {
        this.numberLabel.setText(value);
    }

    public void setFailed(String value) {
        this.failedNumberLabel.setText(value);
    }

    public void setSkipped(String value) {
        this.skippedNumberLabel.setText(value);
    }

    public void setTypeInfo(NodeTypeViz type, String number, String label) {
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != type) continue;
            this.typeNumberLabels[i].setText(number);
            this.typeNameLabels[i].setText(label);
            return;
        }
        throw new IllegalArgumentException("Unsupported Node Type " + (Object)((Object)type));
    }

    public void clear() {
        String na = STLConstants.K0039_NOT_AVAILABLE.getValue();
        this.setTotalNumber(na);
        this.setFailed(na);
        this.setSkipped(na);
        for (int i = 0; i < this.types.length; ++i) {
            this.typeNumberLabels[i].setText(na);
        }
    }
}

