/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.ui.common.FVTableModel;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.model.ConnectivityTableColumns;
import com.intel.stl.ui.monitor.ConnectivityTableData;

public class ConnectivityTableModel
extends FVTableModel<ConnectivityTableData> {
    private static final long serialVersionUID = 8267890546744729698L;

    public ConnectivityTableModel() {
        String[] columnNames = new String[ConnectivityTableColumns.values().length];
        for (int i = 0; i < ConnectivityTableColumns.values().length; ++i) {
            columnNames[i] = ConnectivityTableColumns.values()[i].getTitle();
        }
        this.setColumnNames(columnNames);
    }

    @Override
    public String getColumnName(int column) {
        return this.mColumnNames[column];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int pRow, int pCol) {
        Object value = STLConstants.K0383_NA.getValue();
        ConnectivityTableData nodeData = null;
        Object object = this.critical;
        synchronized (object) {
            nodeData = (ConnectivityTableData)this.mEntryList.get(pRow);
        }
        if (nodeData == null) {
            return value;
        }
        ConnectivityTableData.PerformanceData perfData = nodeData.getPerformanceData();
        try {
            ConnectivityTableColumns col = ConnectivityTableColumns.values()[pCol];
            switch (col) {
                case NODE_NAME: {
                    value = nodeData.getNodeName();
                    break;
                }
                case NODE_LID: {
                    value = nodeData.getNodeLidValue();
                    break;
                }
                case NODE_TYPE: {
                    value = nodeData.getNodeType();
                    break;
                }
                case NODE_GUID: {
                    value = nodeData.getNodeGUID();
                    break;
                }
                case PORT_NUMBER: {
                    value = nodeData.getPortNumber();
                    break;
                }
                case CABLE_INFO: {
                    value = nodeData.getCableInfo();
                    break;
                }
                case LINK_STATE: {
                    value = nodeData.getLinkState() != null ? nodeData.getLinkState().toString() : "";
                    break;
                }
                case PHYSICAL_LINK_STATE: {
                    value = nodeData.getPhysicalLinkState() != null ? nodeData.getPhysicalLinkState().toString() : "";
                    break;
                }
                case LINK_QUALITY: {
                    value = nodeData.getLinkQualityData();
                    break;
                }
                case ACTIVE_LINK_WIDTH: {
                    value = nodeData.getActiveLinkWidth();
                    break;
                }
                case ENABLED_LINK_WIDTH: {
                    value = nodeData.getEnabledLinkWidth();
                    break;
                }
                case SUPPORTED_LINK_WIDTH: {
                    value = nodeData.getSupportedLinkWidth();
                    break;
                }
                case ACTIVE_LINK_WIDTH_DG_TX: {
                    value = nodeData.getActiveLinkWidthDnGrdTx();
                    break;
                }
                case ACTIVE_LINK_WIDTH_DG_RX: {
                    value = nodeData.getActiveLinkWidthDnGrdRx();
                    break;
                }
                case ENABLED_LINK_WIDTH_DG: {
                    value = nodeData.getEnabledLinkWidthDnGrd();
                    break;
                }
                case SUPPORTED_LINK_WIDTH_DG: {
                    value = nodeData.getSupportedLinkWidthDnGrd();
                    break;
                }
                case ACTIVE_LINK_SPEED: {
                    value = nodeData.getActiveLinkSpeed();
                    break;
                }
                case ENABLED_LINK_SPEED: {
                    value = nodeData.getEnabledLinkSpeed();
                    break;
                }
                case SUPPORTED_LINK_SPEED: {
                    value = nodeData.getSupportedLinkSpeed();
                    break;
                }
                default: {
                    if (perfData != null) {
                        value = this.getPerformanceValueAt(perfData, col);
                    }
                    break;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return value;
    }

    protected Object getPerformanceValueAt(ConnectivityTableData.PerformanceData perfData, ConnectivityTableColumns col) {
        Object value = null;
        switch (col) {
            case TX_PACKETS: {
                value = perfData.getTxPackets();
                break;
            }
            case RX_PACKETS: {
                value = perfData.getRxPackets();
                break;
            }
            case LINK_ERROR_RECOVERIES: {
                value = perfData.getNumLinkRecoveries();
                break;
            }
            case LINK_DOWNED: {
                value = perfData.getNumLinkDown();
                break;
            }
            case NUM_LANES_DOWN: {
                value = perfData.getNumLanesDown();
                break;
            }
            case RX_ERRORS: {
                value = perfData.getRxErrors();
                break;
            }
            case RX_REMOTE_PHYSICAL_ERRRORS: {
                value = perfData.getRxRemotePhysicalErrors();
                break;
            }
            case TX_DISCARDS: {
                value = perfData.getTxDiscards();
                break;
            }
            case LOCAL_LINK_INTEGRITY: {
                value = perfData.getLocalLinkIntegrityErrors();
                break;
            }
            case EXCESSIVE_BUFFER_OVERRUNS: {
                value = perfData.getExcessiveBufferOverruns();
                break;
            }
            case RX_SWITCH_RELAY_ERRRORS: {
                value = perfData.getSwitchRelayErrors();
                break;
            }
            case TX_CONSTRAINT: {
                value = perfData.getTxConstraints();
                break;
            }
            case RX_CONSTRAINT: {
                value = perfData.getRxConstraints();
                break;
            }
            case RX_DATA: {
                value = perfData.getPortRcvData();
                break;
            }
            case TX_DATA: {
                value = perfData.getPortXmitData();
                break;
            }
            case FM_CONFIG_ERRORS: {
                value = perfData.getFmConfigErrors();
                break;
            }
            case RX_MC_PACKETS: {
                value = perfData.getPortMulticastRcvPkts();
                break;
            }
            case RX_FECN: {
                value = perfData.getPortRcvFECN();
                break;
            }
            case RX_BECN: {
                value = perfData.getPortRcvBECN();
                break;
            }
            case RX_BUBBLE: {
                value = perfData.getPortRcvBubble();
                break;
            }
            case TX_MC_PACKETS: {
                value = perfData.getPortMulticastXmitPkts();
                break;
            }
            case TX_WAIT: {
                value = perfData.getPortXmitWait();
                break;
            }
            case TX_TIME_CONG: {
                value = perfData.getPortXmitTimeCong();
                break;
            }
            case TX_WASTED_BW: {
                value = perfData.getPortXmitWastedBW();
                break;
            }
            case TX_WAIT_DATA: {
                value = perfData.getPortXmitWaitData();
                break;
            }
            case MARK_FECN: {
                value = perfData.getPortMarkFECN();
                break;
            }
            case UNCORRECTABLE_ERRORS: {
                value = perfData.getUncorrectableErrors();
                break;
            }
            case SW_PORT_CONGESTION: {
                value = perfData.getSwPortCongestion();
                break;
            }
        }
        if (value == null) {
            value = STLConstants.K0383_NA.getValue();
        }
        return value;
    }

    public void clear() {
        this.mEntryList.clear();
    }

    public boolean isEmpty() {
        return this.mEntryList.isEmpty();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
}

