/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.ui.model.GraphCell;
import com.intel.stl.ui.model.GraphEdge;
import com.intel.stl.ui.model.GraphNode;
import com.mxgraph.model.mxCell;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class GraphCells {
    private final List<GraphCell> all = new ArrayList<GraphCell>();
    private final List<GraphNode> nodes = new ArrayList<GraphNode>();
    private final List<GraphEdge> edges = new ArrayList<GraphEdge>();

    public void addNode(GraphNode node) {
        this.all.add(node);
        this.nodes.add(node);
    }

    public void addEdge(GraphEdge edge) {
        this.all.add(edge);
        this.edges.add(edge);
    }

    public boolean hasNodes() {
        return !this.nodes.isEmpty();
    }

    public boolean hasEdges() {
        return !this.edges.isEmpty();
    }

    public List<GraphNode> getNodes() {
        return this.nodes;
    }

    public List<GraphEdge> getEdges() {
        return this.edges;
    }

    public Iterator<GraphCell> iterator() {
        return this.all.iterator();
    }

    public void clear() {
        this.all.clear();
        this.nodes.clear();
        this.edges.clear();
    }

    public boolean isEmpty() {
        return this.all.isEmpty();
    }

    public String toString() {
        return "GraphCells [nodes=" + this.nodes + ", edges=" + this.edges + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.edges == null ? 0 : this.edges.hashCode());
        result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphCells other = (GraphCells)obj;
        if (this.edges == null ? other.edges != null : !this.edges.equals(other.edges)) {
            return false;
        }
        return !(this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes));
    }

    public static GraphCells create(Collection<mxCell> cells, boolean normalized) {
        GraphCells res = new GraphCells();
        if (cells != null) {
            for (mxCell cell : cells) {
                if (cell.isVertex()) {
                    GraphNode node = (GraphNode)cell.getValue();
                    res.addNode(node);
                    continue;
                }
                if (!cell.isEdge()) continue;
                GraphNode source = (GraphNode)cell.getSource().getValue();
                GraphNode target = (GraphNode)cell.getTarget().getValue();
                GraphEdge edge = new GraphEdge(source.getLid(), source.getType(), target.getLid(), target.getType(), source.getLinkPorts(target));
                res.addEdge(normalized ? edge.normalize() : edge);
            }
        }
        return res;
    }
}

