/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.model.GraphCell;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;

public class GraphNode
extends GraphCell
implements Comparable<GraphNode> {
    private static final long serialVersionUID = 1980137982718321748L;
    private int lid;
    private byte type;
    private int numPorts;
    private TreeMap<GraphNode, TreeMap<Integer, Integer>> middleNodes;
    private TreeMap<GraphNode, TreeMap<Integer, Integer>> endNodes;
    private boolean isCollapsed = true;
    private transient int depth = -1;

    public GraphNode() {
    }

    public GraphNode(int lid) {
        this.lid = lid;
    }

    @Override
    public boolean isVertex() {
        return true;
    }

    public int getLid() {
        return this.lid;
    }

    public void setLid(int lid) {
        this.lid = lid;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public int getNumPorts() {
        return this.numPorts;
    }

    public void setNumPorts(int numPorts) {
        this.numPorts = numPorts;
    }

    public int getActivePorts() {
        int sum = 0;
        if (this.middleNodes != null) {
            for (GraphNode node : this.middleNodes.keySet()) {
                sum += this.middleNodes.get(node).size();
            }
        }
        if (this.endNodes != null) {
            for (GraphNode node : this.endNodes.keySet()) {
                sum += this.endNodes.get(node).size();
            }
        }
        return sum;
    }

    public boolean isEndNode() {
        return this.type == NodeType.HFI.getId();
    }

    public TreeMap<GraphNode, TreeMap<Integer, Integer>> getMiddleNodes() {
        return this.middleNodes;
    }

    public void setMiddleNodes(TreeMap<GraphNode, TreeMap<Integer, Integer>> middleNodes) {
        this.middleNodes = middleNodes;
    }

    public TreeMap<GraphNode, TreeMap<Integer, Integer>> getEndNodes() {
        return this.endNodes;
    }

    public void setEndNodes(TreeMap<GraphNode, TreeMap<Integer, Integer>> endNodes) {
        this.endNodes = endNodes;
    }

    public void addLink(GraphNode toNode, int fromPortNum, int toPortNum) {
        TreeMap<GraphNode, TreeMap<Integer, Integer>> neighbors;
        if (toNode.getType() == NodeType.HFI.getId()) {
            if (this.endNodes == null) {
                this.endNodes = new TreeMap();
            }
            neighbors = this.endNodes;
        } else {
            if (this.middleNodes == null) {
                this.middleNodes = new TreeMap();
            }
            neighbors = this.middleNodes;
        }
        TreeMap<Integer, Integer> ports = neighbors.get(toNode);
        if (ports == null) {
            ports = new TreeMap();
            neighbors.put(toNode, ports);
        }
        ports.put(fromPortNum, toPortNum);
    }

    public TreeMap<Integer, Integer> getLinkPorts(GraphNode toNode) {
        TreeMap<Integer, Integer> res = null;
        if (toNode.getType() == NodeType.HFI.getId() && this.endNodes != null) {
            res = this.endNodes.get(toNode);
        } else if (this.middleNodes != null) {
            res = this.middleNodes.get(toNode);
        }
        if (res == null) {
            res = new TreeMap();
        }
        return res;
    }

    public GraphNode getNeighbor(int portNum) {
        TreeMap<Integer, Integer> portsMap;
        if (this.middleNodes != null) {
            for (GraphNode node : this.middleNodes.keySet()) {
                portsMap = this.middleNodes.get(node);
                if (!portsMap.containsKey(portNum)) continue;
                return node;
            }
        }
        if (this.endNodes != null) {
            for (GraphNode node : this.endNodes.keySet()) {
                portsMap = this.endNodes.get(node);
                if (!portsMap.containsKey(portNum)) continue;
                return node;
            }
        }
        return null;
    }

    public Set<GraphNode> getMiddleNeighbor() {
        return this.middleNodes == null ? Collections.emptySet() : this.middleNodes.keySet();
    }

    public Set<GraphNode> getEndNeighbor() {
        return this.endNodes == null ? Collections.emptySet() : this.endNodes.keySet();
    }

    public boolean hasEndNodes() {
        return this.endNodes != null && !this.endNodes.isEmpty();
    }

    public boolean isCollapsed() {
        return this.isCollapsed;
    }

    public void setCollapsed(boolean isCollapsed) {
        if (this.hasEndNodes()) {
            this.isCollapsed = isCollapsed;
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth > this.depth) {
            this.depth = depth;
        }
    }

    @Override
    public int compareTo(GraphNode o) {
        if (o == null) {
            return 1;
        }
        return this.lid > o.lid ? 1 : (this.lid < o.lid ? -1 : 0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.lid;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphNode other = (GraphNode)obj;
        return this.lid == other.lid;
    }

    public String toString() {
        return this.name;
    }

    public GraphNode copy() {
        GraphNode copy = new GraphNode(this.lid);
        copy.name = this.name;
        copy.type = this.type;
        copy.numPorts = this.numPorts;
        copy.isCollapsed = this.isCollapsed;
        copy.depth = this.depth;
        copy.endNodes = this.endNodes;
        copy.middleNodes = this.middleNodes;
        return copy;
    }

    public void dump(PrintStream out) {
        out.println("GraphNode " + this.lid + " " + this.name + " " + (Object)((Object)NodeType.getNodeType(this.type)) + " depth:" + this.depth);
        if (this.middleNodes != null) {
            out.println("  MiddleNode Neighbor");
            for (GraphNode node : this.middleNodes.keySet()) {
                out.println("    " + node.lid + " " + node.name + " " + node.getType() + " " + this.middleNodes.get(node));
            }
        }
        if (this.endNodes != null) {
            out.println("  EndNode Neighbor");
            for (GraphNode node : this.endNodes.keySet()) {
                out.println("    " + node.lid + " " + node.name + " " + node.getType() + " " + this.endNodes.get(node));
            }
        }
    }
}

