/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.configuration.LinkQuality;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIImages;
import java.util.EnumMap;
import javax.swing.Icon;

public enum LinkQualityViz {
    UNKNOWN(LinkQuality.UNKNOWN, STLConstants.K1609_QUALITY_UNKNOWN.getValue(), STLConstants.K1622_QUALITY_UNKNOWN_DESC.getValue(), UIImages.LINK_QUALITY_UNKNOWN.getImageIcon()),
    RESERVED(LinkQuality.RESERVED, STLConstants.K1610_QUALITY_EXCELLENT.getValue(), STLConstants.K1616_QUALITY_EXCELLENT_DESC.getValue(), UIImages.LINK_QUALITY_EXCELLENT.getImageIcon()),
    EXCELLENT(LinkQuality.EXCELLENT, STLConstants.K1610_QUALITY_EXCELLENT.getValue(), STLConstants.K1616_QUALITY_EXCELLENT_DESC.getValue(), UIImages.LINK_QUALITY_EXCELLENT.getImageIcon()),
    VERY_GOOD(LinkQuality.VERY_GOOD, STLConstants.K1611_QUALITY_VERY_GOOD.getValue(), STLConstants.K1617_QUALITY_VERY_GOOD_DESC.getValue(), UIImages.LINK_QUALITY_VERY_GOOD.getImageIcon()),
    GOOD(LinkQuality.GOOD, STLConstants.K1612_QUALITY_GOOD.getValue(), STLConstants.K1618_QUALITY_GOOD_DESC.getValue(), UIImages.LINK_QUALITY_GOOD.getImageIcon()),
    POOR(LinkQuality.POOR, STLConstants.K1613_QUALITY_POOR.getValue(), STLConstants.K1619_QUALITY_POOR_DESC.getValue(), UIImages.LINK_QUALITY_POOR.getImageIcon()),
    BAD(LinkQuality.BAD, STLConstants.K1614_QUALITY_BAD.getValue(), STLConstants.K1620_QUALITY_BAD_DESC.getValue(), UIImages.LINK_QUALITY_BAD.getImageIcon()),
    NONE(LinkQuality.NONE, STLConstants.K1615_QUALITY_NONE.getValue(), STLConstants.K1621_QUALITY_NONE_DESC.getValue(), UIImages.LINK_QUALITY_NONE.getImageIcon());

    private static final EnumMap<LinkQuality, LinkQualityViz> linkQualityMap;
    private final LinkQuality linkQuality;
    private final String value;
    private final String description;
    private final Icon icon;

    private LinkQualityViz(LinkQuality portLinkMode, String value, String description, Icon icon) {
        this.linkQuality = portLinkMode;
        this.value = value;
        this.description = description;
        this.icon = icon;
    }

    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public static String getLinkQualityStr(LinkQuality quality) {
        return LinkQualityViz.getLinkQualityViz(quality).getValue();
    }

    public static String getLinkQualityStr(byte value) {
        LinkQuality quality = LinkQuality.getLinkQuality(value);
        return LinkQualityViz.getLinkQualityViz(quality).getValue();
    }

    public static String getLinkQualityDescription(LinkQuality quality) {
        return LinkQualityViz.getLinkQualityViz(quality).getDescription();
    }

    public static String getLinkQualityDescription(byte value) {
        LinkQuality quality = LinkQuality.getLinkQuality(value);
        return LinkQualityViz.getLinkQualityViz(quality).getDescription();
    }

    public static Icon getLinkQualityIcon(byte value) {
        LinkQuality quality = LinkQuality.getLinkQuality(value);
        return LinkQualityViz.getLinkQualityViz(quality).getIcon();
    }

    public static LinkQualityViz getLinkQualityViz(LinkQuality quality) {
        LinkQualityViz res = linkQualityMap.get((Object)quality);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException("Couldn't find LinkQualityViz for " + (Object)((Object)quality));
    }

    static {
        linkQualityMap = new EnumMap(LinkQuality.class);
        for (LinkQualityViz lqz : LinkQualityViz.values()) {
            linkQualityMap.put(lqz.linkQuality, lqz);
        }
    }
}

