/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.configuration.LinkWidthMask;
import com.intel.stl.ui.common.STLConstants;
import java.util.EnumMap;

public enum LinkWidthMaskViz {
    STL_LINK_WIDTH_NOP(LinkWidthMask.STL_LINK_WIDTH_NOP, STLConstants.K0117_NONE.getValue()),
    STL_LINK_WIDTH_1X(LinkWidthMask.STL_LINK_WIDTH_1X, "1x"),
    STL_LINK_WIDTH_2X(LinkWidthMask.STL_LINK_WIDTH_2X, "2x"),
    STL_LINK_WIDTH_3X(LinkWidthMask.STL_LINK_WIDTH_3X, "3x"),
    STL_LINK_WIDTH_4X(LinkWidthMask.STL_LINK_WIDTH_4X, "4x");

    private static final EnumMap<LinkWidthMask, String> linkWidthMap;
    private final LinkWidthMask linkWidthMask;
    private final String value;

    private LinkWidthMaskViz(LinkWidthMask linkWidthMask, String value) {
        this.linkWidthMask = linkWidthMask;
        this.value = value;
    }

    public LinkWidthMask getLinkWidthMask() {
        return this.linkWidthMask;
    }

    public String getValue() {
        return this.value;
    }

    public static LinkWidthMaskViz getLinkWidthMaskViz(LinkWidthMask mask) {
        for (LinkWidthMaskViz lwmv : LinkWidthMaskViz.values()) {
            if (lwmv.linkWidthMask != mask) continue;
            return lwmv;
        }
        return null;
    }

    public static String getLinkWidthMaskStr(LinkWidthMask mask) {
        return linkWidthMap.get((Object)mask);
    }

    static {
        linkWidthMap = new EnumMap(LinkWidthMask.class);
        for (LinkWidthMaskViz lwmv : LinkWidthMaskViz.values()) {
            linkWidthMap.put(lwmv.linkWidthMask, lwmv.value);
        }
    }
}

