/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.ui.common.FVTableModel;
import com.intel.stl.ui.model.PerformanceTableColumns;
import com.intel.stl.ui.monitor.PerformanceTableData;
import java.io.Serializable;

public class PerformanceTableModel
extends FVTableModel<PerformanceTableData> {
    private static final long serialVersionUID = 6716106545100111380L;

    public PerformanceTableModel() {
        String[] columnNames = new String[PerformanceTableColumns.values().length];
        for (int i = 0; i < PerformanceTableColumns.values().length; ++i) {
            columnNames[i] = PerformanceTableColumns.values()[i].getTitle();
        }
        this.setColumnNames(columnNames);
    }

    @Override
    public String getColumnName(int column) {
        return this.mColumnNames[column];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int pRow, int pCol) {
        Serializable value = null;
        long num = -1L;
        int uncorrectableErr = -1;
        PerformanceTableData portData = null;
        Object object = this.critical;
        synchronized (object) {
            portData = (PerformanceTableData)this.mEntryList.get(pRow);
        }
        try {
            if (portData != null) {
                switch (PerformanceTableColumns.values()[pCol]) {
                    case PORT_NUM: {
                        value = Short.valueOf(portData.getPortNumber());
                        break;
                    }
                    case LINK_QUALITY: {
                        value = Integer.valueOf(portData.getLinkQualityValue());
                        break;
                    }
                    case RX_REMOTE_PHY_ERRORS: {
                        num = portData.getPortRxRemotePhysicalErrors();
                        value = num == -1L ? null : Long.valueOf(num);
                        break;
                    }
                    case RX_PKTS_RATE: {
                        value = Long.valueOf(portData.getPortRxPktsRate());
                        break;
                    }
                    case RX_DATA_RATE: {
                        value = portData.getPortRxDataRate();
                        break;
                    }
                    case RX_PACKETS: {
                        value = Long.valueOf(portData.getPortRxCumulativePkts());
                        break;
                    }
                    case RX_DATA: {
                        value = portData.getPortRxCumulativeData();
                        break;
                    }
                    case RX_SWITCH_ERRORS: {
                        num = portData.getPortRxSwitchRelayErrors();
                        value = num == -1L ? null : Long.valueOf(num);
                        break;
                    }
                    case TX_DISCARDS: {
                        value = Long.valueOf(portData.getPortTxDiscards());
                        break;
                    }
                    case TX_PKTS_RATE: {
                        value = Long.valueOf(portData.getPortTxPktsRate());
                        break;
                    }
                    case TX_DATA_RATE: {
                        value = portData.getPortTxDataRate();
                        break;
                    }
                    case TX_PACKETS: {
                        value = Long.valueOf(portData.getPortTxCumulativePkts());
                        break;
                    }
                    case TX_DATA: {
                        value = portData.getPortTxCumulativeData();
                        break;
                    }
                    case EXCESSIVE_BUFFER_OVERRUNS: {
                        num = portData.getExcessiveBufferOverruns();
                        value = num == -1L ? null : Long.valueOf(num);
                        break;
                    }
                    case FM_CONFIG_ERRORS: {
                        num = portData.getFmConfigErrors();
                        value = num == -1L ? null : Long.valueOf(num);
                        break;
                    }
                    case RX_MC_PACKETS: {
                        num = portData.getPortMulticastRcvPkts();
                        value = num == -1L ? null : Long.valueOf(num);
                        break;
                    }
                    case RX_ERRORS: {
                        num = portData.getPortRcvErrors();
                        value = num == -1L ? null : Long.valueOf(num);
                        break;
                    }
                    case RX_CONSTRAINT: {
                        num = portData.getPortRcvConstraintErrors();
                        value = num == -1L ? null : Long.valueOf(num);
                        break;
                    }
                    case RX_FECN: {
                        value = Long.valueOf(portData.getPortRcvFECN());
                        break;
                    }
                    case RX_BECN: {
                        value = Long.valueOf(portData.getPortRcvBECN());
                        break;
                    }
                    case RX_BUBBLE: {
                        value = Long.valueOf(portData.getPortRcvBubble());
                        break;
                    }
                    case TX_MC_PACKETS: {
                        num = portData.getPortMulticastXmitPkts();
                        value = num == -1L ? null : Long.valueOf(num);
                        break;
                    }
                    case TX_CONSTRAINT: {
                        num = portData.getPortXmitConstraintErrors();
                        value = num == -1L ? null : Long.valueOf(num);
                        break;
                    }
                    case TX_WAIT: {
                        value = Long.valueOf(portData.getPortXmitWait());
                        break;
                    }
                    case TX_TIME_CONG: {
                        value = Long.valueOf(portData.getPortXmitTimeCong());
                        break;
                    }
                    case TX_WASTED_BW: {
                        value = Long.valueOf(portData.getPortXmitWastedBW());
                        break;
                    }
                    case TX_WAIT_DATA: {
                        value = Long.valueOf(portData.getPortXmitWaitData());
                        break;
                    }
                    case LOCAL_LINK_INTEGRITY: {
                        num = portData.getLocalLinkIntegrityErrors();
                        value = num == -1L ? null : Long.valueOf(num);
                        break;
                    }
                    case MARK_FECN: {
                        value = Long.valueOf(portData.getPortMarkFECN());
                        break;
                    }
                    case LINK_ERROR_RECOVERIES: {
                        num = portData.getLinkErrorRecovery();
                        value = num == -1L ? null : Long.valueOf(num);
                        break;
                    }
                    case LINK_DOWNED: {
                        num = portData.getLinkDowned();
                        value = num == -1L ? null : Long.valueOf(num);
                        break;
                    }
                    case NUM_LANES_DOWN: {
                        num = portData.getNumLanesDown();
                        value = num == -1L ? null : Long.valueOf(num);
                        break;
                    }
                    case UNCORRECTABLE_ERRORS: {
                        num = portData.getUncorrectableErrors();
                        value = num == -1L ? null : Long.valueOf(num);
                        break;
                    }
                    case SW_PORT_CONGESTION: {
                        value = Long.valueOf(portData.getSwPortCongestion());
                        break;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return value;
    }

    public void clear() {
        this.mEntryList.clear();
    }

    public int getEntrySize() {
        return this.mEntryList.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
}

