/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.configuration.PhysicalState;
import com.intel.stl.ui.common.STLConstants;
import java.util.EnumMap;

public enum PhysicalStateViz {
    NO_ST_CHANGE(PhysicalState.NO_ST_CHANGE, STLConstants.K0368_NO_STATE_CHANGE.getValue()),
    SLEEP(PhysicalState.SLEEP, STLConstants.K0374_SLEEP.getValue()),
    POLLING(PhysicalState.POLLING, STLConstants.K0375_POLLING.getValue()),
    DISABLED(PhysicalState.DISABLED, STLConstants.K0376_DISABLED.getValue()),
    PORT_CONFIG_TRAINING(PhysicalState.PORT_CONFIG_TRAINING, STLConstants.K0377_CONFIG_TRAIN.getValue()),
    LINKUP(PhysicalState.LINKUP, STLConstants.K0378_LINKUP.getValue()),
    LINK_ERROR_RECOVERY(PhysicalState.LINK_ERROR_RECOVERY, STLConstants.K0379_LINK_ERR_RECOV.getValue()),
    OFFLINE(PhysicalState.OFFLINE, STLConstants.K0381_OFFLINE.getValue()),
    TEST(PhysicalState.TEST, STLConstants.K0382_TEST.getValue());

    private static final EnumMap<PhysicalState, String> physStateMap;
    private final PhysicalState state;
    private final String value;

    private PhysicalStateViz(PhysicalState state, String value) {
        this.state = state;
        this.value = value;
    }

    public PhysicalState getPhysicalState() {
        return this.state;
    }

    public String getValue() {
        return this.value;
    }

    public static PhysicalStateViz getPhysicalStateViz(byte state) {
        for (PhysicalStateViz psv : PhysicalStateViz.values()) {
            if (psv.state.getId() != state) continue;
            return psv;
        }
        return null;
    }

    public static String getPhysicalStateStr(PhysicalState state) {
        return physStateMap.get((Object)state);
    }

    static {
        physStateMap = new EnumMap(PhysicalState.class);
        for (PhysicalStateViz psv : PhysicalStateViz.values()) {
            physStateMap.put(psv.state, psv.value);
        }
    }
}

