/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.configuration.PortState;
import com.intel.stl.ui.common.STLConstants;
import java.util.EnumMap;

public enum PortStateViz {
    NO_ST_CHANGE(PortState.NO_ST_CHANGE, STLConstants.K0368_NO_STATE_CHANGE.getValue()),
    DOWN(PortState.DOWN, STLConstants.K0369_DOWN.getValue()),
    INITIALIZE(PortState.INITIALIZE, STLConstants.K0370_INIT.getValue()),
    ARMED(PortState.ARMED, STLConstants.K0371_ARMED.getValue()),
    ACTIVE(PortState.ACTIVE, STLConstants.K0372_ACTIVE.getValue());

    private static final EnumMap<PortState, String> portStateMap;
    private final PortState state;
    private final String value;

    private PortStateViz(PortState state, String value) {
        this.state = state;
        this.value = value;
    }

    public PortState getPortState() {
        return this.state;
    }

    public String getValue() {
        return this.value;
    }

    public static PortStateViz getPortStateViz(byte state) {
        for (PortStateViz psv : PortStateViz.values()) {
            if (psv.state.getId() != state) continue;
            return psv;
        }
        return null;
    }

    public static String getPortStateStr(PortState state) {
        return portStateMap.get((Object)state);
    }

    static {
        portStateMap = new EnumMap(PortState.class);
        for (PortStateViz psv : PortStateViz.values()) {
            portStateMap.put(psv.state, psv.value);
        }
    }
}

