/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.subnet.Selection;
import com.intel.stl.ui.common.STLConstants;
import java.util.EnumMap;

public enum SelectionViz {
    UTILIZATION_HIGH(Selection.UTILIZATION_HIGH, STLConstants.K1630_SEL_UTILIZATION_HIGH.getValue()),
    PACKET_RATE_HIGH(Selection.PACKET_RATE_HIGH, STLConstants.K1631_SEL_PACKET_RATE_HIGH.getValue()),
    UTILIZATION_LOW(Selection.UTILIZATION_LOW, STLConstants.K1632_SEL_UTILIZATION_LOW.getValue()),
    INTEGRITY_ERRORS_HIGH(Selection.INTEGRITY_ERRORS_HIGH, STLConstants.K1633_SEL_INTEGRITY_ERRORS_HIGH.getValue()),
    CONGESTION_ERRORS_HIGH(Selection.CONGESTION_ERRORS_HIGH, STLConstants.K1634_SEL_CONGESTION_ERRORS_HIGH.getValue()),
    SMA_CONGESTION_ERRORS_HIGH(Selection.SMA_CONGESTION_ERRORS_HIGH, STLConstants.K1635_SEL_SMA_CONGESTION_ERRORS_HIGH.getValue()),
    BUBBLE_ERRORS_HIGH(Selection.BUBBLE_ERRORS_HIGH, STLConstants.K1636_SEL_BUBBLE_ERRORS_HIGH.getValue()),
    SECURITY_ERRORS_HIGH(Selection.SECURITY_ERRORS_HIGH, STLConstants.K1637_SEL_SECURITY_ERRORS_HIGH.getValue()),
    ROUTING_ERRORS_HIGH(Selection.ROUTING_ERRORS_HIGH, STLConstants.K1638_SEL_ROUTING_ERRORS_HIGH.getValue());

    private static final EnumMap<Selection, SelectionViz> SelectionMap;
    private final Selection selection;
    private final String description;

    private SelectionViz(Selection selection, String description) {
        this.selection = selection;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public static String getSelectionStr(Selection selection) {
        SelectionViz viz = SelectionMap.get((Object)selection);
        if (viz != null) {
            return viz.getDescription();
        }
        throw new IllegalArgumentException("Couldn't find SelectionViz for " + (Object)((Object)selection));
    }

    public static String getSelectionStr(int value) {
        for (SelectionViz lqz : SelectionViz.values()) {
            if (lqz.getSelection().getSelect() != value) continue;
            return lqz.getDescription();
        }
        return null;
    }

    static {
        SelectionMap = new EnumMap(Selection.class);
        for (SelectionViz lqz : SelectionViz.values()) {
            SelectionMap.put(lqz.selection, lqz);
        }
    }
}

