/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.api.ITimestamped;
import com.intel.stl.api.Utils;
import com.intel.stl.api.configuration.LinkQuality;
import com.intel.stl.api.performance.PortCountersBean;
import com.intel.stl.api.performance.VFPortCountersBean;
import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.LinkRecordBean;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.PortRecordBean;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.api.subnet.SubnetException;
import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.model.ConnectivityTableModel;
import com.intel.stl.ui.model.GraphEdge;
import com.intel.stl.ui.model.PortProperties;
import com.intel.stl.ui.monitor.ConnectivityTableData;
import com.intel.stl.ui.publisher.CallbackAdapter;
import com.intel.stl.ui.publisher.CancellableCall;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.SingleTaskManager;
import com.intel.stl.ui.publisher.Task;
import com.intel.stl.ui.publisher.TaskScheduler;
import com.intel.stl.ui.publisher.subscriber.PortCounterSubscriber;
import com.intel.stl.ui.publisher.subscriber.SubscriberType;
import com.intel.stl.ui.publisher.subscriber.VFPortCounterSubscriber;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ListSelectionModel;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectivityTableController {
    private static final Logger log = LoggerFactory.getLogger(ConnectivityTableController.class);
    private static final boolean TEST_SLOW_LINKS = false;
    private ISubnetApi subnetApi;
    private final ConnectivityTableModel model;
    private final JXTable view;
    private TaskScheduler taskScheduler;
    private final Map<Point, PortSchedule<?>> schedules;
    private final SingleTaskManager taskMgr;
    private int currentLid;
    private String currentVFName;
    private short[] currentPorts;
    private LinkedHashMap<GraphEdge, Short> currentPaths;
    private PortCounterSubscriber portCounterSubscriber;
    private VFPortCounterSubscriber vfPortCounterSubscriber;

    public ConnectivityTableController(ConnectivityTableModel model, JXTable view) {
        this.model = model;
        this.view = view;
        this.schedules = new HashMap();
        this.taskMgr = new SingleTaskManager();
    }

    public void setContext(Context context, IProgressObserver observer) {
        this.subnetApi = context.getSubnetApi();
        this.taskScheduler = context.getTaskScheduler();
        this.portCounterSubscriber = (PortCounterSubscriber)this.taskScheduler.getSubscriber(SubscriberType.PORT_COUNTER);
        this.vfPortCounterSubscriber = (VFPortCounterSubscriber)this.taskScheduler.getSubscriber(SubscriberType.VF_PORT_COUNTER);
        this.clear();
        if (observer != null) {
            observer.onFinish();
        }
    }

    public synchronized void showConnectivity(int nodeLid, String vfName, IProgressObserver observer, short ... portList) {
        if (this.currentPorts != null && Arrays.equals(this.currentPorts, portList) && this.currentLid == nodeLid && (this.currentVFName == null && vfName == null || this.currentVFName != null && this.currentVFName.equals(vfName))) {
            return;
        }
        this.clearScheduledTasks();
        this.currentLid = nodeLid;
        this.currentVFName = vfName;
        this.currentPorts = portList;
        this.refreshConnectivity(observer);
    }

    public synchronized void refreshConnectivity(final IProgressObserver observer) {
        CancellableCall<List<ConnectivityTableData>> caller = new CancellableCall<List<ConnectivityTableData>>(){

            @Override
            public List<ConnectivityTableData> call(ICancelIndicator cancelIndicator) throws Exception {
                List<ConnectivityTableData> data = ConnectivityTableController.this.createTable(ConnectivityTableController.this.currentLid, ConnectivityTableController.this.currentVFName, cancelIndicator, ConnectivityTableController.this.currentPorts);
                return data;
            }
        };
        CallbackAdapter<List<ConnectivityTableData>> callback = new CallbackAdapter<List<ConnectivityTableData>>(){

            @Override
            public void onDone(List<ConnectivityTableData> result) {
                if (result != null) {
                    ConnectivityTableController.this.updateTable(result);
                }
            }

            @Override
            public void onError(Throwable ... errors) {
                Util.showErrors((Component)ConnectivityTableController.this.view, Arrays.asList(errors));
            }

            @Override
            public void onFinally() {
                if (observer != null) {
                    observer.onFinish();
                }
            }
        };
        this.taskMgr.submit(caller, callback);
    }

    public synchronized void showPathConnectivity(LinkedHashMap<GraphEdge, Short> portMap, String vfName, IProgressObserver observer) {
        if (this.currentPaths != null && this.currentPaths.equals(portMap) && (this.currentVFName == null && vfName == null || this.currentVFName != null && this.currentVFName.equals(vfName))) {
            return;
        }
        this.clearScheduledTasks();
        this.currentPaths = portMap;
        this.currentVFName = vfName;
        this.refreshPathConnectivity(observer);
    }

    public synchronized void refreshPathConnectivity(final IProgressObserver observer) {
        CancellableCall<List<ConnectivityTableData>> caller = new CancellableCall<List<ConnectivityTableData>>(){

            @Override
            public List<ConnectivityTableData> call(ICancelIndicator cancelIndicator) throws Exception {
                List<ConnectivityTableData> data = ConnectivityTableController.this.createPathTable(ConnectivityTableController.this.currentPaths, ConnectivityTableController.this.currentVFName, cancelIndicator);
                return data;
            }
        };
        CallbackAdapter<List<ConnectivityTableData>> callback = new CallbackAdapter<List<ConnectivityTableData>>(){

            @Override
            public void onDone(List<ConnectivityTableData> result) {
                if (result != null) {
                    ConnectivityTableController.this.updateTable(result);
                }
            }

            @Override
            public void onFinally() {
                if (observer != null) {
                    observer.onFinish();
                }
            }
        };
        this.taskMgr.submit(caller, callback);
    }

    protected List<ConnectivityTableData> createTable(int lid, String vfName, ICancelIndicator indicator, short ... portList) throws SubnetException, SubnetDataNotFoundException {
        NodeRecordBean nodeBean = null;
        try {
            nodeBean = this.subnetApi.getNode(lid);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (nodeBean == null) {
            return null;
        }
        ArrayList<ConnectivityTableData> dataList = new ArrayList<ConnectivityTableData>();
        LinkRecordBean linkBean = null;
        for (short port : portList) {
            boolean isActive;
            if (indicator != null && indicator.isCancelled()) {
                return null;
            }
            boolean isHFI = nodeBean.getNodeType() == NodeType.HFI;
            short portNum = port;
            if (isHFI) {
                port = nodeBean.getNodeInfo().getLocalPortNum();
                portNum = 1;
                isActive = this.subnetApi.hasLocalPort(lid, port);
            } else {
                isActive = this.subnetApi.hasPort(lid, port);
            }
            if (!isActive) {
                ConnectivityTableData nodeData = new ConnectivityTableData(nodeBean.getLid(), nodeBean.getNodeInfo().getNodeGUID(), nodeBean.getNodeType(), port, false);
                nodeData.clear();
                nodeData.setNodeName(nodeBean.getNodeDesc());
                nodeData.setLinkState(STLConstants.K0524_INACTIVE.getValue());
                dataList.add(nodeData);
                continue;
            }
            try {
                linkBean = this.subnetApi.getLinkBySource(lid, portNum);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            PortRecordBean portBean = this.subnetApi.getPortByPortNum(lid, portNum);
            ConnectivityTableData nodeData = this.createTableEntry(dataList.size(), linkBean.getFromLID(), vfName, portNum, portBean, linkBean, nodeBean, false);
            if (nodeData != null) {
                nodeData.setSlowLinkState(Utils.isSlowPort(portBean.getPortInfo()));
                dataList.add(nodeData);
            }
            NodeRecordBean nbrNodeBean = null;
            linkBean = this.subnetApi.getLinkByDestination(lid, portNum);
            nbrNodeBean = this.subnetApi.getNode(linkBean.getFromLID());
            portNum = linkBean.getFromPortIndex();
            portBean = this.subnetApi.getPortByPortNum(linkBean.getFromLID(), portNum);
            nodeData = this.createTableEntry(dataList.size(), linkBean.getFromLID(), vfName, portNum, portBean, linkBean, nbrNodeBean, true);
            if (nodeData == null) continue;
            nodeData.setSlowLinkState(Utils.isSlowPort(portBean.getPortInfo()));
            dataList.add(nodeData);
        }
        return dataList;
    }

    protected List<ConnectivityTableData> createPathTable(LinkedHashMap<GraphEdge, Short> portMap, String vfName, ICancelIndicator indicator) throws SubnetException, SubnetDataNotFoundException {
        ArrayList<ConnectivityTableData> res = new ArrayList<ConnectivityTableData>();
        for (GraphEdge edge : portMap.keySet()) {
            short port;
            if (indicator != null && indicator.isCancelled()) {
                return null;
            }
            int lid = edge.getFromLid();
            List<ConnectivityTableData> tableData = this.createTable(lid, vfName, indicator, port = portMap.get(edge).shortValue());
            if (tableData == null) continue;
            res.addAll(tableData);
        }
        return res;
    }

    private ConnectivityTableData createTableEntry(int index, int lid, String vfName, short portNum, PortRecordBean portBean, LinkRecordBean linkBean, NodeRecordBean nodeBean, boolean isNeighbor) {
        ConnectivityTableData nodeData = null;
        if (nodeBean.getNodeType() == NodeType.HFI) {
            portNum = 1;
        }
        PortProperties portProperties = new PortProperties(portBean, nodeBean, linkBean);
        nodeData = new ConnectivityTableData(nodeBean.getLid(), nodeBean.getNodeInfo().getNodeGUID(), nodeBean.getNodeType(), portNum, isNeighbor);
        nodeData.clear();
        nodeData.setNodeName(nodeBean.getNodeDesc());
        nodeData.setLinkState(portProperties.getState());
        nodeData.setPhysicalLinkState(portProperties.getPhysicalState());
        nodeData.setActiveLinkWidth(portProperties.getLinkWidthActive());
        nodeData.setEnabledLinkWidth(portProperties.getLinkWidthEnabled());
        nodeData.setSupportedLinkWidth(portProperties.getLinkWidthSupported());
        nodeData.setActiveLinkWidthDnGrdTx(portProperties.getLinkWidthDnGrdTx());
        nodeData.setActiveLinkWidthDnGrdRx(portProperties.getLinkWidthDnGrdRx());
        nodeData.setEnabledLinkWidthDnGrd(portProperties.getLinkWidthDnGrdEnabled());
        nodeData.setSupportedLinkWidthDnGrd(portProperties.getLinkWidthDnGrdSupported());
        nodeData.setActiveLinkSpeed(portProperties.getLinkSpeedActive());
        nodeData.setEnabledLinkSpeed(portProperties.getLinkSpeedEnabled());
        nodeData.setSupportedLinkSpeed(portProperties.getLinkSpeedSupported());
        nodeData.setCableInfo("");
        PortSchedule<ITimestamped> schedule = null;
        schedule = vfName == null ? this.schedulePortPerformanceTask(index, nodeData, lid, portNum) : this.scheduleVFPortPerformanceTask(index, nodeData, lid, vfName, portNum);
        schedule.refresh();
        return nodeData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PortSchedule<PortCountersBean> schedulePortPerformanceTask(final int index, final ConnectivityTableData dataEntrty, final int lid, final short portNum) {
        CallbackAdapter<PortCountersBean> callback = new CallbackAdapter<PortCountersBean>(){

            @Override
            public synchronized void onDone(PortCountersBean pcBean) {
                if (pcBean == null) {
                    log.error(STLConstants.K3047_PORT_BEAN_COUNTERS_NULL.getValue());
                    return;
                }
                final ConnectivityTableData.PerformanceData perfData = new ConnectivityTableData.PerformanceData();
                perfData.setTxPackets(pcBean.getPortXmitPkts());
                perfData.setRxPackets(pcBean.getPortRcvPkts());
                perfData.setNumLinkRecoveries(pcBean.getLinkErrorRecovery());
                perfData.setNumLinkDown(pcBean.getLinkDowned());
                perfData.setNumLanesDown(pcBean.getNumLanesDown());
                perfData.setRxErrors(pcBean.getPortRcvErrors());
                perfData.setRxRemotePhysicalErrors(pcBean.getPortRcvRemotePhysicalErrors());
                perfData.setTxDiscards(pcBean.getPortXmitDiscards());
                perfData.setLocalLinkIntegrityErrors(pcBean.getLocalLinkIntegrityErrors());
                perfData.setExcessiveBufferOverruns(pcBean.getExcessiveBufferOverruns());
                perfData.setSwitchRelayErrors(pcBean.getPortRcvSwitchRelayErrors());
                perfData.setTxConstraints(pcBean.getPortXmitConstraintErrors());
                perfData.setRxConstraints(pcBean.getPortRcvConstraintErrors());
                perfData.setPortRcvData(pcBean.getPortRcvData());
                perfData.setPortXmitData(pcBean.getPortXmitData());
                perfData.setFmConfigErrors(pcBean.getFmConfigErrors());
                perfData.setPortMulticastRcvPkts(pcBean.getPortMulticastRcvPkts());
                perfData.setPortRcvFECN(pcBean.getPortRcvFECN());
                perfData.setPortRcvBECN(pcBean.getPortRcvBECN());
                perfData.setPortRcvBubble(pcBean.getPortRcvBubble());
                perfData.setPortMulticastXmitPkts(pcBean.getPortMulticastXmitPkts());
                perfData.setPortXmitWait(pcBean.getPortXmitWait());
                perfData.setPortXmitTimeCong(pcBean.getPortXmitTimeCong());
                perfData.setPortXmitWastedBW(pcBean.getPortXmitWastedBW());
                perfData.setPortXmitWaitData(pcBean.getPortXmitWaitData());
                perfData.setPortMarkFECN(pcBean.getPortMarkFECN());
                perfData.setUncorrectableErrors(pcBean.getUncorrectableErrors());
                perfData.setSwPortCongestion(pcBean.getSwPortCongestion());
                final byte linkQuality = pcBean.getLinkQualityIndicator();
                Util.runInEDT(new Runnable(){

                    @Override
                    public void run() {
                        dataEntrty.setPerformanceData(perfData);
                        dataEntrty.setLinkQualityData(linkQuality);
                        if (ConnectivityTableController.this.model.getRowCount() > 0 && index < ConnectivityTableController.this.model.getRowCount()) {
                            ConnectivityTableController.this.model.fireTableRowsUpdated(index, index);
                        }
                    }
                });
            }
        };
        Task<PortCountersBean> task = this.portCounterSubscriber.registerPortCounters(lid, portNum, (ICallback<PortCountersBean>)callback);
        PortSchedule<PortCountersBean> ps = new PortSchedule<PortCountersBean>((ICallback)callback, task){

            @Override
            public void refresh() {
                PortCountersBean counters = ConnectivityTableController.this.taskScheduler.getPerformanceApi().getPortCounters(lid, portNum);
                this.callback.onDone(counters);
            }

            @Override
            public void clear() {
                ConnectivityTableController.this.portCounterSubscriber.deregisterPortCounters(this.task, this.callback);
            }
        };
        Map<Point, PortSchedule<?>> map = this.schedules;
        synchronized (map) {
            this.schedules.put(new Point(lid, portNum), ps);
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PortSchedule<VFPortCountersBean> scheduleVFPortPerformanceTask(final int index, final ConnectivityTableData dataEntrty, final int lid, final String vfName, final short portNum) {
        CallbackAdapter<VFPortCountersBean> callback = new CallbackAdapter<VFPortCountersBean>(){

            @Override
            public synchronized void onDone(VFPortCountersBean pcBean) {
                if (pcBean == null) {
                    log.error(STLConstants.K3047_PORT_BEAN_COUNTERS_NULL.getValue());
                    return;
                }
                final ConnectivityTableData.PerformanceData perfData = new ConnectivityTableData.PerformanceData();
                perfData.setTxPackets(pcBean.getPortVFXmitPkts());
                perfData.setRxPackets(pcBean.getPortVFRcvPkts());
                perfData.setTxDiscards(pcBean.getPortVFXmitDiscards());
                perfData.setPortRcvData(pcBean.getPortVFRcvData());
                perfData.setPortXmitData(pcBean.getPortVFXmitData());
                perfData.setPortRcvFECN(pcBean.getPortVFRcvFECN());
                perfData.setPortRcvBECN(pcBean.getPortVFRcvBECN());
                perfData.setPortRcvBubble(pcBean.getPortVFRcvBubble());
                perfData.setPortXmitWait(pcBean.getPortVFXmitWait());
                perfData.setPortXmitTimeCong(pcBean.getPortVFXmitTimeCong());
                perfData.setPortXmitWastedBW(pcBean.getPortVFXmitWastedBW());
                perfData.setPortXmitWaitData(pcBean.getPortVFXmitWaitData());
                Util.runInEDT(new Runnable(){

                    @Override
                    public void run() {
                        dataEntrty.setPerformanceData(perfData);
                        dataEntrty.setLinkQualityData(LinkQuality.UNKNOWN.getValue());
                        if (ConnectivityTableController.this.model.getRowCount() > 0 && index < ConnectivityTableController.this.model.getRowCount()) {
                            ConnectivityTableController.this.model.fireTableRowsUpdated(index, index);
                        }
                    }
                });
            }
        };
        Task<VFPortCountersBean> task = this.vfPortCounterSubscriber.registerVFPortCounters(vfName, lid, portNum, (ICallback<VFPortCountersBean>)callback);
        PortSchedule<VFPortCountersBean> ps = new PortSchedule<VFPortCountersBean>((ICallback)callback, task){

            @Override
            public void refresh() {
                VFPortCountersBean counters = ConnectivityTableController.this.taskScheduler.getPerformanceApi().getVFPortCounters(vfName, lid, portNum);
                this.callback.onDone(counters);
            }

            @Override
            public void clear() {
                ConnectivityTableController.this.vfPortCounterSubscriber.deregisterVFPortCounters(this.task, this.callback);
            }
        };
        Map<Point, PortSchedule<?>> map = this.schedules;
        synchronized (map) {
            this.schedules.put(new Point(lid, portNum), ps);
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void clearScheduledTasks() {
        Map<Point, PortSchedule<?>> map = this.schedules;
        synchronized (map) {
            for (PortSchedule<?> schedule : this.schedules.values()) {
                schedule.clear();
            }
            this.schedules.clear();
        }
    }

    protected void updateTable(List<ConnectivityTableData> dataList) {
        HashMap<ConnectivityTableData, Integer> newDataMap = new HashMap<ConnectivityTableData, Integer>();
        for (int i = 0; i < dataList.size(); ++i) {
            newDataMap.put(dataList.get(i), i);
        }
        int[] selRows = this.view.getSelectedRows();
        ArrayList<Integer> newSelRows = new ArrayList<Integer>();
        for (int i = 0; i < selRows.length; ++i) {
            ConnectivityTableData data = (ConnectivityTableData)this.model.getEntry(selRows[i]);
            Integer index = (Integer)newDataMap.get(data);
            if (index == null) continue;
            newSelRows.add(index);
        }
        this.model.setEntries(dataList);
        this.model.fireTableDataChanged();
        this.view.packAll();
        ListSelectionModel selModel = this.view.getSelectionModel();
        selModel.setValueIsAdjusting(true);
        Iterator iterator = newSelRows.iterator();
        while (iterator.hasNext()) {
            int row = (Integer)iterator.next();
            selModel.addSelectionInterval(row, row);
        }
        selModel.setValueIsAdjusting(false);
    }

    public void clear() {
        this.clearScheduledTasks();
        this.model.clear();
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                ConnectivityTableController.this.model.fireTableDataChanged();
            }
        });
    }

    abstract class PortSchedule<E> {
        ICallback<E> callback;
        Task<E> task;

        public PortSchedule(ICallback<E> callback, Task<E> task) {
            this.callback = callback;
            this.task = task;
        }

        public abstract void refresh();

        public abstract void clear();
    }
}

