/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.STLConstants;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;

public class ConnectivityTableData
implements Serializable {
    private static final long serialVersionUID = -3222455776096537707L;
    private final long nodeGuidValue;
    private final int nodeLidValue;
    private final NodeType nodeType;
    private final short portNumValue;
    private boolean slowLinkState;
    private final boolean isNeighbor;
    private String nodeName;
    private final String nodeGUID;
    private String portNumber;
    private String cableInfo;
    private String linkState;
    private String physicalLinkState;
    private String activeLinkWidth;
    private String enabledLinkWidth;
    private String supportedLinkWidth;
    private String activeLinkWidthDnGrdTx;
    private String activeLinkWidthDnGrdRx;
    private String enabledLinkWidthDnGrd;
    private String supportedLinkWidthDnGrd;
    private String activeLinkSpeed;
    private String enabledLinkSpeed;
    private String supportedLinkSpeed;
    private final AtomicReference<PerformanceData> performance;
    private int linkQuality;

    public ConnectivityTableData(int nodeLid, long nodeGuidValue, NodeType nodeType, short portNumValue, boolean isNeighbor) {
        this.nodeLidValue = nodeLid;
        this.nodeType = nodeType;
        this.nodeGuidValue = nodeGuidValue;
        this.portNumValue = portNumValue;
        this.isNeighbor = isNeighbor;
        this.performance = new AtomicReference();
        this.nodeGUID = StringUtils.longHexString(nodeGuidValue);
        this.portNumber = isNeighbor ? Integer.toString(portNumValue) + " (" + STLConstants.K0525_NEIGHBOR.getValue() + ")" : Integer.toString(portNumValue);
    }

    public boolean isNeighbor() {
        return this.isNeighbor;
    }

    public boolean isSlowLinkState() {
        return this.slowLinkState;
    }

    public void setSlowLinkState(boolean state) {
        this.slowLinkState = state;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public int getNodeLidValue() {
        return this.nodeLidValue;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public String getNodeGUID() {
        return this.nodeGUID;
    }

    public String getPortNumber() {
        return this.portNumber;
    }

    public short getPortNumValue() {
        return this.portNumValue;
    }

    public String getCableInfo() {
        return this.cableInfo;
    }

    public void setCableInfo(String cableInfo) {
        this.cableInfo = cableInfo;
    }

    public String getLinkState() {
        return this.linkState;
    }

    public void setLinkState(String linkState) {
        this.linkState = linkState;
    }

    public String getPhysicalLinkState() {
        return this.physicalLinkState;
    }

    public void setPhysicalLinkState(String physicalLinkState) {
        this.physicalLinkState = physicalLinkState;
    }

    public String getActiveLinkWidth() {
        return this.activeLinkWidth;
    }

    public void setActiveLinkWidth(String activeLinkWidth) {
        this.activeLinkWidth = activeLinkWidth;
    }

    public String getEnabledLinkWidth() {
        return this.enabledLinkWidth;
    }

    public void setEnabledLinkWidth(String enabledLinkWidth) {
        this.enabledLinkWidth = enabledLinkWidth;
    }

    public String getSupportedLinkWidth() {
        return this.supportedLinkWidth;
    }

    public void setSupportedLinkWidth(String supportedLinkWidth) {
        this.supportedLinkWidth = supportedLinkWidth;
    }

    public String getActiveLinkWidthDnGrdTx() {
        return this.activeLinkWidthDnGrdTx;
    }

    public void setActiveLinkWidthDnGrdTx(String activeLinkWidthDnGrdTx) {
        this.activeLinkWidthDnGrdTx = activeLinkWidthDnGrdTx;
    }

    public String getActiveLinkWidthDnGrdRx() {
        return this.activeLinkWidthDnGrdRx;
    }

    public void setActiveLinkWidthDnGrdRx(String activeLinkWidthDnGrdRx) {
        this.activeLinkWidthDnGrdRx = activeLinkWidthDnGrdRx;
    }

    public String getEnabledLinkWidthDnGrd() {
        return this.enabledLinkWidthDnGrd;
    }

    public void setEnabledLinkWidthDnGrd(String enabledLinkWidthDnGrd) {
        this.enabledLinkWidthDnGrd = enabledLinkWidthDnGrd;
    }

    public String getSupportedLinkWidthDnGrd() {
        return this.supportedLinkWidthDnGrd;
    }

    public void setSupportedLinkWidthDnGrd(String supportedLinkWidthDnGrd) {
        this.supportedLinkWidthDnGrd = supportedLinkWidthDnGrd;
    }

    public String getActiveLinkSpeed() {
        return this.activeLinkSpeed;
    }

    public void setActiveLinkSpeed(String activeLinkSpeed) {
        this.activeLinkSpeed = activeLinkSpeed;
    }

    public String getEnabledLinkSpeed() {
        return this.enabledLinkSpeed;
    }

    public void setEnabledLinkSpeed(String enabledLinkSpeed) {
        this.enabledLinkSpeed = enabledLinkSpeed;
    }

    public String getSupportedLinkSpeed() {
        return this.supportedLinkSpeed;
    }

    public void setSupportedLinkSpeed(String supportedLinkSpeed) {
        this.supportedLinkSpeed = supportedLinkSpeed;
    }

    public PerformanceData getPerformanceData() {
        return this.performance.get();
    }

    public void setPerformanceData(PerformanceData perfData) {
        this.performance.set(perfData);
    }

    public void setLinkQualityData(int linkQuality) {
        this.linkQuality = linkQuality;
    }

    public int getLinkQualityData() {
        return this.linkQuality;
    }

    public void clear() {
        String na = STLConstants.K0383_NA.getValue();
        this.slowLinkState = false;
        this.nodeName = na;
        this.linkState = na;
        this.physicalLinkState = na;
        this.activeLinkWidth = na;
        this.enabledLinkWidth = na;
        this.supportedLinkWidth = na;
        this.activeLinkWidthDnGrdTx = na;
        this.activeLinkWidthDnGrdRx = na;
        this.enabledLinkWidthDnGrd = na;
        this.supportedLinkWidthDnGrd = na;
        this.activeLinkSpeed = na;
        this.enabledLinkSpeed = na;
        this.supportedLinkSpeed = na;
        this.linkQuality = 0;
        PerformanceData perfData = this.getPerformanceData();
        if (perfData != null) {
            perfData.clear();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.nodeGuidValue ^ this.nodeGuidValue >>> 32);
        result = 31 * result + this.portNumValue;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectivityTableData other = (ConnectivityTableData)obj;
        if (this.nodeGuidValue != other.nodeGuidValue) {
            return false;
        }
        return this.portNumValue == other.portNumValue;
    }

    public static class PerformanceData {
        private Long tx32BitWords;
        private Long rx32BitWords;
        private Long txPackets;
        private Long rxPackets;
        private Long portXmitData;
        private Long portRcvData;
        private Long numSymbolErrors;
        private Long numLinkRecoveries;
        private Long numLinkDown;
        private Byte numLanesDown;
        private Long rxErrors;
        private Long rxRemotePhysicalErrors;
        private Long txDiscards;
        private Long localLinkIntegrityErrors;
        private Long excessiveBufferOverruns;
        private Long switchRelayErrors;
        private Long txConstraints;
        private Long rxConstraints;
        private Long vl15Dropped;
        private Long fmConfigErrors;
        private Long portMulticastRcvPkts;
        private Long portRcvFECN;
        private Long portRcvBECN;
        private Long portRcvBubble;
        private Long portMulticastXmitPkts;
        private Long portXmitWait;
        private Long portXmitTimeCong;
        private Long portXmitWastedBW;
        private Long portXmitWaitData;
        private Long portMarkFECN;
        private Short uncorrectableErrors;
        private Long swPortCongestion;

        public Long getTx32BitWords() {
            return this.tx32BitWords;
        }

        public void setTx32BitWords(Long tx32BitWords) {
            this.tx32BitWords = tx32BitWords;
        }

        public Long getRx32BitWords() {
            return this.rx32BitWords;
        }

        public void setRx32BitWords(Long rx32BitWords) {
            this.rx32BitWords = rx32BitWords;
        }

        public Long getTxPackets() {
            return this.txPackets;
        }

        public void setTxPackets(Long txPackets) {
            this.txPackets = txPackets;
        }

        public Long getRxPackets() {
            return this.rxPackets;
        }

        public void setRxPackets(Long rxPackets) {
            this.rxPackets = rxPackets;
        }

        public Long getNumSymbolErrors() {
            return this.numSymbolErrors;
        }

        public void setNumSymbolErrors(Long numSymbolErrors) {
            this.numSymbolErrors = numSymbolErrors;
        }

        public Long getNumLinkRecoveries() {
            return this.numLinkRecoveries;
        }

        public void setNumLinkRecoveries(Long numLinkRecoveries) {
            this.numLinkRecoveries = numLinkRecoveries;
        }

        public Long getNumLinkDown() {
            return this.numLinkDown;
        }

        public void setNumLinkDown(Long numLinkDown) {
            this.numLinkDown = numLinkDown;
        }

        public Byte getNumLanesDown() {
            return this.numLanesDown;
        }

        public void setNumLanesDown(Byte numLanesDown) {
            this.numLanesDown = numLanesDown;
        }

        public Long getRxErrors() {
            return this.rxErrors;
        }

        public void setRxErrors(Long rxErrors) {
            this.rxErrors = rxErrors;
        }

        public Long getRxRemotePhysicalErrors() {
            return this.rxRemotePhysicalErrors;
        }

        public void setRxRemotePhysicalErrors(Long rxRemotePhysicalErrors) {
            this.rxRemotePhysicalErrors = rxRemotePhysicalErrors;
        }

        public Long getTxDiscards() {
            return this.txDiscards;
        }

        public void setTxDiscards(Long txDiscards) {
            this.txDiscards = txDiscards;
        }

        public Long getLocalLinkIntegrityErrors() {
            return this.localLinkIntegrityErrors;
        }

        public void setLocalLinkIntegrityErrors(Long localLinkIntegrityErrors) {
            this.localLinkIntegrityErrors = localLinkIntegrityErrors;
        }

        public Long getExcessiveBufferOverruns() {
            return this.excessiveBufferOverruns;
        }

        public void setExcessiveBufferOverruns(Long excessiveBufferOverruns) {
            this.excessiveBufferOverruns = excessiveBufferOverruns;
        }

        public Long getSwitchRelayErrors() {
            return this.switchRelayErrors;
        }

        public void setSwitchRelayErrors(Long switchRelayErrors) {
            this.switchRelayErrors = switchRelayErrors;
        }

        public Long getTxConstraints() {
            return this.txConstraints;
        }

        public void setTxConstraints(Long txConstraints) {
            this.txConstraints = txConstraints;
        }

        public Long getRxConstraints() {
            return this.rxConstraints;
        }

        public void setRxConstraints(Long rxConstraints) {
            this.rxConstraints = rxConstraints;
        }

        public Long getVl15Dropped() {
            return this.vl15Dropped;
        }

        public void setVl15Dropped(Long vl15Dropped) {
            this.vl15Dropped = vl15Dropped;
        }

        public Long getPortXmitData() {
            return this.portXmitData;
        }

        public Long getPortRcvData() {
            return this.portRcvData;
        }

        public Long getFmConfigErrors() {
            return this.fmConfigErrors;
        }

        public Long getPortMulticastRcvPkts() {
            return this.portMulticastRcvPkts;
        }

        public Long getPortRcvFECN() {
            return this.portRcvFECN;
        }

        public Long getPortRcvBECN() {
            return this.portRcvBECN;
        }

        public Long getPortRcvBubble() {
            return this.portRcvBubble;
        }

        public Long getPortMulticastXmitPkts() {
            return this.portMulticastXmitPkts;
        }

        public Long getPortXmitWait() {
            return this.portXmitWait;
        }

        public Long getPortXmitTimeCong() {
            return this.portXmitTimeCong;
        }

        public Long getPortXmitWastedBW() {
            return this.portXmitWastedBW;
        }

        public Long getPortXmitWaitData() {
            return this.portXmitWaitData;
        }

        public Long getPortMarkFECN() {
            return this.portMarkFECN;
        }

        public Short getUncorrectableErrors() {
            return this.uncorrectableErrors;
        }

        public Long getSwPortCongestion() {
            return this.swPortCongestion;
        }

        public void setPortXmitData(Long portXmitData) {
            this.portXmitData = portXmitData;
        }

        public void setPortRcvData(Long portRcvData) {
            this.portRcvData = portRcvData;
        }

        public void setFmConfigErrors(Long fmConfigErrors) {
            this.fmConfigErrors = fmConfigErrors;
        }

        public void setPortMulticastRcvPkts(Long portMulticastRcvPkts) {
            this.portMulticastRcvPkts = portMulticastRcvPkts;
        }

        public void setPortRcvFECN(Long portRcvFECN) {
            this.portRcvFECN = portRcvFECN;
        }

        public void setPortRcvBECN(Long portRcvBECN) {
            this.portRcvBECN = portRcvBECN;
        }

        public void setPortRcvBubble(Long portRcvBubble) {
            this.portRcvBubble = portRcvBubble;
        }

        public void setPortMulticastXmitPkts(Long portMulticastXmitPkts) {
            this.portMulticastXmitPkts = portMulticastXmitPkts;
        }

        public void setPortXmitWait(Long portXmitWait) {
            this.portXmitWait = portXmitWait;
        }

        public void setPortXmitTimeCong(Long portXmitTimeCong) {
            this.portXmitTimeCong = portXmitTimeCong;
        }

        public void setPortXmitWastedBW(Long portXmitWastedBW) {
            this.portXmitWastedBW = portXmitWastedBW;
        }

        public void setPortXmitWaitData(Long portXmitWaitData) {
            this.portXmitWaitData = portXmitWaitData;
        }

        public void setPortMarkFECN(Long portMarkFECN) {
            this.portMarkFECN = portMarkFECN;
        }

        public void setUncorrectableErrors(Short uncorrectableErrors) {
            this.uncorrectableErrors = uncorrectableErrors;
        }

        public void setSwPortCongestion(Long swPortCongestion) {
            this.swPortCongestion = swPortCongestion;
        }

        public void clear() {
            this.tx32BitWords = null;
            this.rx32BitWords = null;
            this.txPackets = null;
            this.rxPackets = null;
            this.numSymbolErrors = null;
            this.numLinkRecoveries = null;
            this.numLinkDown = null;
            this.rxErrors = null;
            this.rxRemotePhysicalErrors = null;
            this.txDiscards = null;
            this.localLinkIntegrityErrors = null;
            this.excessiveBufferOverruns = null;
            this.switchRelayErrors = null;
            this.txConstraints = null;
            this.rxConstraints = null;
            this.vl15Dropped = null;
            this.fmConfigErrors = null;
            this.portMulticastRcvPkts = null;
            this.portRcvFECN = null;
            this.portRcvBECN = null;
            this.portRcvBubble = null;
            this.portMulticastXmitPkts = null;
            this.portXmitWait = null;
            this.portXmitTimeCong = null;
            this.portXmitWastedBW = null;
            this.portXmitWaitData = null;
            this.portMarkFECN = null;
            this.uncorrectableErrors = null;
            this.swPortCongestion = null;
        }
    }
}

