/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.api.configuration.LinkQuality;
import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.performance.PerformanceRequestCancelledException;
import com.intel.stl.api.performance.PortCountersBean;
import com.intel.stl.api.performance.VFPortCountersBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.IPerfSubpageController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.ISectionController;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.PinDescription;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.UndoableJumpEvent;
import com.intel.stl.ui.common.view.ISectionListener;
import com.intel.stl.ui.common.view.JSectionView;
import com.intel.stl.ui.event.NodesSelectedEvent;
import com.intel.stl.ui.event.PortsSelectedEvent;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.UndoHandler;
import com.intel.stl.ui.model.PerformanceTableModel;
import com.intel.stl.ui.monitor.IPortSelectionListener;
import com.intel.stl.ui.monitor.PerformanceChartsSection;
import com.intel.stl.ui.monitor.PerformancePage;
import com.intel.stl.ui.monitor.PerformanceTableSection;
import com.intel.stl.ui.monitor.PerformanceTreeController;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.UndoablePortPreviewSelection;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.view.PerformanceChartsSectionView;
import com.intel.stl.ui.monitor.view.PerformanceView;
import com.intel.stl.ui.monitor.view.PerformanceXTableView;
import com.intel.stl.ui.performance.PortSourceName;
import com.intel.stl.ui.publisher.CallbackAdapter;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.Task;
import com.intel.stl.ui.publisher.TaskScheduler;
import com.intel.stl.ui.publisher.subscriber.PortCounterSubscriber;
import com.intel.stl.ui.publisher.subscriber.SubscriberType;
import com.intel.stl.ui.publisher.subscriber.VFPortCounterSubscriber;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import net.engio.mbassy.bus.MBassador;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceNodeController
implements IPerfSubpageController,
IPortSelectionListener {
    private static final Logger log = LoggerFactory.getLogger(PerformanceNodeController.class);
    private final List<ISectionController<?>> sections;
    private PerformanceTableSection tableSection;
    private PerformanceChartsSection chartsSection;
    private final PerformanceView performanceView;
    private Context context;
    private TaskScheduler taskScheduler;
    private final AtomicReference<Future<?>> refreshTask = new AtomicReference<Object>(null);
    private List<Task<PortCountersBean>> portCounterTask;
    private ICallback<PortCountersBean[]> portCounterCallback;
    private List<Task<VFPortCountersBean>> vfPortCounterTask;
    private ICallback<VFPortCountersBean[]> vfPortCounterCallback;
    private String vfName;
    private int lid = -1;
    private String nodeDesc;
    private List<Short> portNumList;
    private int previewPortIndex = 0;
    private final MBassador<IAppEvent> eventBus;
    private PortCounterSubscriber portCounterSubscriber;
    private VFPortCounterSubscriber vfPortCounterSubscriber;
    private FVResourceNode currentNode;
    protected UndoHandler undoHandler;
    private final String origin = PerformancePage.NAME;

    public PerformanceNodeController(PerformanceView performanceView, MBassador<IAppEvent> eventBus) {
        this.performanceView = performanceView;
        this.eventBus = eventBus;
        this.sections = this.getSections();
        ArrayList sectionViews = new ArrayList();
        for (ISectionController<?> section : this.sections) {
            sectionViews.add((JSectionView<?>)section.getView());
        }
        performanceView.installSectionViews(sectionViews);
    }

    protected List<ISectionController<?>> getSections() {
        ArrayList sections = new ArrayList();
        PerformanceTableModel tableModel = new PerformanceTableModel();
        final PerformanceXTableView tableView = new PerformanceXTableView(tableModel);
        tableView.setPortSelectionListener(this);
        JSectionView<ISectionListener> tableSectionView = new JSectionView<ISectionListener>(STLConstants.K0208_PORTS_TABLE.getValue()){
            private static final long serialVersionUID = 6166893610476283350L;

            @Override
            protected JComponent getMainComponent() {
                return tableView;
            }
        };
        this.tableSection = new PerformanceTableSection(tableModel, tableView, tableSectionView, this.eventBus);
        sections.add(this.tableSection);
        this.chartsSection = new PerformanceChartsSection(new PerformanceChartsSectionView(UILabels.STL60100_PORT_PREVIEW.getDescription("")), true, this.eventBus);
        this.chartsSection.setPinID(PinDescription.PinID.PERF_NODE);
        sections.add(this.chartsSection);
        return sections;
    }

    public PerformanceView getPerformanceView() {
        return this.performanceView;
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        this.context = context;
        if (context == null) {
            return;
        }
        this.taskScheduler = this.context.getTaskScheduler();
        this.portCounterSubscriber = (PortCounterSubscriber)this.taskScheduler.getSubscriber(SubscriberType.PORT_COUNTER);
        this.portCounterCallback = new CallbackAdapter<PortCountersBean[]>(){

            @Override
            public synchronized void onDone(PortCountersBean[] portCounterBeans) {
                if (portCounterBeans != null) {
                    PerformanceNodeController.this.processPortCounters(portCounterBeans);
                }
            }
        };
        this.vfPortCounterSubscriber = (VFPortCounterSubscriber)this.taskScheduler.getSubscriber(SubscriberType.VF_PORT_COUNTER);
        this.vfPortCounterCallback = new CallbackAdapter<VFPortCountersBean[]>(){

            @Override
            public synchronized void onDone(VFPortCountersBean[] portCounterBeans) {
                if (portCounterBeans != null) {
                    PerformanceNodeController.this.processVFPortCounters(portCounterBeans);
                }
            }
        };
        this.chartsSection.setContext(context, observer);
        if (context.getController() != null) {
            this.undoHandler = context.getController().getUndoHandler();
        }
        observer.onFinish();
    }

    @Override
    public void onRefresh(IProgressObserver observer) {
        Future<?> oldRefreshTask = this.refreshTask.get();
        Runnable refreshRunnable = this.createRefreshRunnable(this.vfName, this.lid, this.portNumList.toArray(new Short[0]), observer);
        Future<?> newRefreshTask = this.taskScheduler.submitToBackground(refreshRunnable);
        while (!this.refreshTask.compareAndSet(oldRefreshTask, newRefreshTask)) {
            oldRefreshTask = this.refreshTask.get();
        }
        if (oldRefreshTask != null && !oldRefreshTask.isDone()) {
            oldRefreshTask.cancel(true);
        }
    }

    @Override
    public void setParentController(PerformanceTreeController parentController) {
    }

    protected Runnable createRefreshRunnable(final String vfName, final int lid, final Short[] ports, final IProgressObserver observer) {
        Runnable refreshTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean refreshCancelled = false;
                try {
                    PerformanceNodeController.this.chartsSection.onRefresh(null);
                    PerformanceNodeController.this.tableSection.clear();
                    IPerformanceApi perfApi = PerformanceNodeController.this.taskScheduler.getPerformanceApi();
                    if (vfName == null) {
                        PortCountersBean[] res = new PortCountersBean[ports.length];
                        for (int i = 0; i < res.length; ++i) {
                            res[i] = perfApi.getPortCounters(lid, ports[i]);
                        }
                        PerformanceNodeController.this.portCounterCallback.onDone(res);
                    } else {
                        VFPortCountersBean[] res = new VFPortCountersBean[ports.length];
                        for (int i = 0; i < res.length; ++i) {
                            res[i] = perfApi.getVFPortCounters(vfName, lid, ports[i]);
                        }
                        PerformanceNodeController.this.vfPortCounterCallback.onDone(res);
                    }
                }
                catch (PerformanceRequestCancelledException e) {
                    refreshCancelled = true;
                }
                finally {
                    if (!refreshCancelled) {
                        observer.onFinish();
                    }
                }
            }
        };
        return refreshTask;
    }

    protected void processPortCounters(PortCountersBean[] beanList) {
        this.tableSection.updateTable(beanList, this.previewPortIndex);
        if (this.previewPortIndex >= 0) {
            PortCountersBean bean = beanList[this.previewPortIndex];
            if (bean != null) {
                this.chartsSection.updateLinkQualityIcon(bean.getLinkQualityIndicator());
            } else {
                log.error(UILabels.STL80002_INVALID_PORT_NUMBER.getDescription(this.previewPortIndex));
            }
        }
    }

    protected void processVFPortCounters(VFPortCountersBean[] beanList) {
        this.tableSection.updateTable(beanList, this.previewPortIndex);
        if (this.previewPortIndex >= 0) {
            VFPortCountersBean bean = beanList[this.previewPortIndex];
            if (bean != null) {
                this.chartsSection.updateLinkQualityIcon(LinkQuality.UNKNOWN.getValue());
            } else {
                log.error(UILabels.STL80002_INVALID_PORT_NUMBER.getDescription(this.previewPortIndex));
            }
        }
    }

    @Override
    public void showNode(FVResourceNode treeNode, IProgressObserver observer) {
        this.currentNode = treeNode;
        this.previewPortIndex = 0;
        if (this.portCounterTask != null) {
            this.portCounterSubscriber.deregisterPortCountersArray(this.portCounterTask, this.portCounterCallback);
            this.chartsSection.clear();
        }
        if (this.vfPortCounterTask != null) {
            this.vfPortCounterSubscriber.deregisterVFPortCounters(this.vfPortCounterTask, this.vfPortCounterCallback);
            this.chartsSection.clear();
        }
        int lid = treeNode.getId();
        ArrayList<Short> portNumList = new ArrayList<Short>();
        for (FVResourceNode portNode : treeNode.getChildren()) {
            if (portNode.getType() != TreeNodeType.ACTIVE_PORT) continue;
            portNumList.add((short)portNode.getId());
        }
        this.tableSection.clear();
        FVResourceNode parent = treeNode.getParent();
        String vfName = null;
        if (parent.getType() == TreeNodeType.VIRTUAL_FABRIC) {
            vfName = parent.getTitle();
            this.vfPortCounterTask = this.vfPortCounterSubscriber.registerVFPortCounters(vfName, lid, portNumList, this.vfPortCounterCallback);
        } else {
            this.portCounterTask = this.portCounterSubscriber.registerPortCounters(lid, portNumList, this.portCounterCallback);
        }
        this.previewPortIndex = 0;
        PortSourceName portSource = new PortSourceName(vfName, treeNode.getTitle(), lid, (Short)portNumList.get(this.previewPortIndex));
        this.chartsSection.setSource(portSource);
        this.vfName = vfName;
        this.lid = lid;
        this.nodeDesc = treeNode.getTitle();
        this.portNumList = portNumList;
        this.onRefresh(observer);
    }

    @Override
    public void onPortSelection(int rowIndex) {
        if (rowIndex != this.previewPortIndex) {
            PortSourceName portSource = new PortSourceName(this.vfName, this.nodeDesc, this.lid, this.portNumList.get(rowIndex));
            this.chartsSection.setSource(portSource);
            if (rowIndex >= 0 && this.undoHandler != null && !this.undoHandler.isInProgress()) {
                UndoablePortPreviewSelection undoSel = new UndoablePortPreviewSelection(this.tableSection.getTableView(), this.previewPortIndex, rowIndex);
                this.undoHandler.addUndoAction(undoSel);
            }
            this.previewPortIndex = rowIndex;
        }
    }

    @Override
    public void onJumpToPort(int lid, short portNum, String destination) {
        if (this.eventBus != null) {
            PortsSelectedEvent pse = new PortsSelectedEvent(lid, portNum, this, destination);
            this.eventBus.publish((Object)pse);
            if (this.currentNode != null && this.undoHandler != null && !this.undoHandler.isInProgress()) {
                NodeType type = TreeNodeType.getNodeType(this.currentNode.getType());
                UndoableJumpEvent undoSel = new UndoableJumpEvent(this.eventBus, new NodesSelectedEvent(this.currentNode.getId(), type, this, this.origin), pse);
                this.undoHandler.addUndoAction(undoSel);
            }
        }
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Component getView() {
        return this.performanceView;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void onEnter() {
    }

    @Override
    public void onExit() {
    }

    @Override
    public boolean canExit() {
        return true;
    }

    @Override
    public void clear() {
        for (ISectionController<?> section : this.sections) {
            section.clear();
        }
        if (this.taskScheduler != null) {
            if (this.portCounterTask != null) {
                this.portCounterSubscriber.deregisterPortCountersArray(this.portCounterTask, this.portCounterCallback);
            }
            if (this.vfPortCounterTask != null) {
                this.vfPortCounterSubscriber.deregisterVFPortCounters(this.vfPortCounterTask, this.vfPortCounterCallback);
            }
        }
        this.lid = -1;
    }

    @Override
    public PageWeight getContextSwitchWeight() {
        return PageWeight.MEDIUM;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return PageWeight.MEDIUM;
    }
}

