/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.ui.common.IPageController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.event.NodeUpdateEvent;
import com.intel.stl.ui.event.TaskStatusEvent;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.monitor.PerformanceTreeController;
import com.intel.stl.ui.monitor.tree.FVTreeManager;
import com.intel.stl.ui.monitor.view.PerformanceTreeView;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.engio.mbassy.bus.MBassador;
import net.engio.mbassy.listener.Handler;

public class PerformancePage
implements IPageController {
    public static final String NAME = STLConstants.K0200_PERFORMANCE.getValue();
    PerformanceTreeController mPerfTreeController;
    private final PerformanceTreeView mPerfTreeView;
    private final MBassador<IAppEvent> eventBus;

    public PerformancePage(PerformanceTreeView view, MBassador<IAppEvent> eventBus, FVTreeManager treeBuilder) {
        this.mPerfTreeView = view;
        this.mPerfTreeController = new PerformanceTreeController(view, eventBus, treeBuilder);
        this.eventBus = eventBus;
        eventBus.subscribe((Object)this);
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        this.mPerfTreeController.setContext(context, observer);
    }

    @Override
    public void onRefresh(IProgressObserver observer) {
        this.mPerfTreeController.onRefresh(observer);
    }

    @Handler(priority=1)
    public synchronized void onNodeUpdate(NodeUpdateEvent evt) {
        TaskStatusEvent<NodeUpdateEvent> taskEvent = new TaskStatusEvent<NodeUpdateEvent>(this, evt, TaskStatusEvent.Status.STARTED);
        this.eventBus.publish(taskEvent);
        try {
            this.mPerfTreeController.onNodeUpdate(evt);
        }
        finally {
            taskEvent = new TaskStatusEvent<NodeUpdateEvent>(this, evt, TaskStatusEvent.Status.FINISHED);
            this.eventBus.publish(taskEvent);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return STLConstants.K0201_PERFORMANCE_DESCRIPTION.getValue();
    }

    @Override
    public JPanel getView() {
        return this.mPerfTreeView;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void onEnter() {
    }

    @Override
    public void onExit() {
    }

    @Override
    public boolean canExit() {
        return true;
    }

    @Override
    public void clear() {
    }

    @Override
    public PageWeight getContextSwitchWeight() {
        return PageWeight.MEDIUM;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return PageWeight.MEDIUM;
    }

    public String toString() {
        return this.getName();
    }
}

