/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.api.configuration.LinkQuality;
import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.performance.PortCountersBean;
import com.intel.stl.api.performance.VFPortCountersBean;
import com.intel.stl.ui.common.IPerfSubpageController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.ISectionController;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.PinDescription;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.view.JSectionView;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.monitor.PerformanceChartsSection;
import com.intel.stl.ui.monitor.PerformanceErrorsSection;
import com.intel.stl.ui.monitor.PerformanceTreeController;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.view.PerformanceChartsSectionView;
import com.intel.stl.ui.monitor.view.PerformanceErrorsSectionView;
import com.intel.stl.ui.monitor.view.PerformanceView;
import com.intel.stl.ui.performance.PortCounterSourceName;
import com.intel.stl.ui.performance.PortSourceName;
import com.intel.stl.ui.publisher.CallbackAdapter;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.Task;
import com.intel.stl.ui.publisher.TaskScheduler;
import com.intel.stl.ui.publisher.subscriber.PortCounterSubscriber;
import com.intel.stl.ui.publisher.subscriber.SubscriberType;
import com.intel.stl.ui.publisher.subscriber.VFPortCounterSubscriber;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import net.engio.mbassy.bus.MBassador;

public class PerformancePortController
implements IPerfSubpageController {
    private static final boolean DEBUG = true;
    private TaskScheduler taskScheduler;
    private Context context;
    private int lastLid = -1;
    private short lastPortNum = (short)-1;
    private String lastVfName = null;
    private Task<PortCountersBean> portCounterTask;
    private ICallback<PortCountersBean> portCounterCallback;
    private Task<VFPortCountersBean> vfPortCounterTask;
    private ICallback<VFPortCountersBean> vfPortCounterCallback;
    private final List<ISectionController<?>> sections;
    private PerformanceChartsSection graphSection;
    private PerformanceErrorsSection errorsSection;
    private final PerformanceView performancePortView;
    private final MBassador<IAppEvent> eventBus;
    private PortCounterSubscriber portCounterSubscriber;
    private VFPortCounterSubscriber vfPortCounterSubscriber;

    public PerformancePortController(PerformanceView performancePortView, MBassador<IAppEvent> eventBus) {
        this.performancePortView = performancePortView;
        this.eventBus = eventBus;
        this.sections = this.getSections();
        ArrayList sectionViews = new ArrayList();
        for (ISectionController<?> section : this.sections) {
            sectionViews.add((JSectionView<?>)section.getView());
        }
        performancePortView.installSectionViews(sectionViews);
    }

    protected List<ISectionController<?>> getSections() {
        ArrayList sections = new ArrayList();
        this.graphSection = new PerformanceChartsSection(new PerformanceChartsSectionView(STLConstants.K0200_PERFORMANCE.getValue()), false, this.eventBus);
        this.graphSection.setPinID(PinDescription.PinID.PERF_PORT);
        sections.add(this.graphSection);
        this.errorsSection = new PerformanceErrorsSection(new PerformanceErrorsSectionView(), this.eventBus);
        this.errorsSection.setPinID(PinDescription.PinID.PERF_PORT_ERR);
        sections.add(this.errorsSection);
        return sections;
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        this.clear();
        this.context = context;
        this.taskScheduler = context.getTaskScheduler();
        this.portCounterSubscriber = (PortCounterSubscriber)this.taskScheduler.getSubscriber(SubscriberType.PORT_COUNTER);
        this.vfPortCounterSubscriber = (VFPortCounterSubscriber)this.taskScheduler.getSubscriber(SubscriberType.VF_PORT_COUNTER);
        this.graphSection.setContext(context, observer);
        this.errorsSection.setContext(context, observer);
        observer.onFinish();
    }

    @Override
    public void onRefresh(final IProgressObserver observer) {
        this.taskScheduler.submitToBackground(new Runnable(){

            @Override
            public void run() {
                PerformancePortController.this.refresh(observer);
            }
        });
    }

    @Override
    public void setParentController(PerformanceTreeController parentController) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(IProgressObserver observer) {
        int lid = -1;
        short portNum = -1;
        String vfName = null;
        PerformancePortController performancePortController = this;
        synchronized (performancePortController) {
            lid = this.lastLid;
            portNum = this.lastPortNum;
            vfName = this.lastVfName;
        }
        try {
            if (lid == -1 || portNum == -1) {
                return;
            }
            this.graphSection.onRefresh(observer);
            this.errorsSection.onRefresh(observer);
            IPerformanceApi perfApi = this.taskScheduler.getPerformanceApi();
            if (vfName != null) {
                VFPortCountersBean res = perfApi.getVFPortCounters(vfName, lid, portNum);
                this.vfPortCounterCallback.onDone(res);
            } else {
                PortCountersBean res = perfApi.getPortCounters(lid, portNum);
                this.portCounterCallback.onDone(res);
            }
        }
        finally {
            if (observer != null) {
                observer.onFinish();
            }
        }
    }

    @Override
    public void showNode(final FVResourceNode node, final IProgressObserver observer) {
        if (node.getType() == TreeNodeType.ACTIVE_PORT) {
            this.taskScheduler.submitToBackground(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        FVResourceNode parent = node.getParent();
                        int lid = parent.getId();
                        short portNum = (short)node.getId();
                        String vfName = null;
                        FVResourceNode group = parent.getParent();
                        if (group.getType() == TreeNodeType.VIRTUAL_FABRIC) {
                            vfName = group.getTitle();
                        }
                        if (lid != PerformancePortController.this.lastLid || portNum != PerformancePortController.this.lastPortNum || vfName == null && PerformancePortController.this.lastVfName != null || vfName != null && !vfName.equals(PerformancePortController.this.lastVfName)) {
                            PerformancePortController.this.setPort(parent.getTitle(), lid, portNum, vfName);
                        }
                        PerformancePortController.this.refresh(null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        observer.onFinish();
                    }
                }
            });
        }
    }

    protected synchronized void setPort(String nodeDesc, int lid, short portNum, String vfName) {
        if (this.portCounterTask != null || this.vfPortCounterTask != null) {
            this.clear();
        }
        PortSourceName graphPortSource = new PortSourceName(vfName, nodeDesc, lid, portNum);
        this.graphSection.setSource(graphPortSource);
        PortCounterSourceName errPortSource = new PortCounterSourceName(vfName, nodeDesc, lid, portNum);
        this.errorsSection.setSource(errPortSource);
        if (vfName != null) {
            this.vfPortCounterCallback = this.createCallback(vfName);
            this.vfPortCounterTask = this.vfPortCounterSubscriber.registerVFPortCounters(vfName, lid, portNum, this.vfPortCounterCallback);
        } else {
            this.portCounterCallback = this.createCallback();
            this.portCounterTask = this.portCounterSubscriber.registerPortCounters(lid, portNum, this.portCounterCallback);
        }
        this.lastLid = lid;
        this.lastPortNum = portNum;
        this.lastVfName = vfName;
    }

    protected ICallback<PortCountersBean> createCallback() {
        this.portCounterCallback = new CallbackAdapter<PortCountersBean>(){

            @Override
            public synchronized void onDone(PortCountersBean result) {
                if (result != null) {
                    PerformancePortController.this.graphSection.updateLinkQualityIcon(result.getLinkQualityIndicator());
                    PerformancePortController.this.errorsSection.updateErrors(result);
                }
            }
        };
        return this.portCounterCallback;
    }

    protected ICallback<VFPortCountersBean> createCallback(String vfName) {
        this.vfPortCounterCallback = new CallbackAdapter<VFPortCountersBean>(){

            @Override
            public synchronized void onDone(VFPortCountersBean result) {
                if (result != null) {
                    PerformancePortController.this.graphSection.updateLinkQualityIcon(LinkQuality.UNKNOWN.getValue());
                    PerformancePortController.this.errorsSection.updateErrors(result);
                }
            }
        };
        return this.vfPortCounterCallback;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public PerformanceView getView() {
        return this.performancePortView;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void onEnter() {
    }

    @Override
    public void onExit() {
    }

    @Override
    public boolean canExit() {
        return true;
    }

    @Override
    public void clear() {
        for (ISectionController<?> section : this.sections) {
            section.clear();
        }
        if (this.taskScheduler != null) {
            if (this.portCounterTask != null) {
                this.portCounterSubscriber.deregisterPortCounters(this.portCounterTask, this.portCounterCallback);
            }
            if (this.vfPortCounterTask != null) {
                this.vfPortCounterSubscriber.deregisterVFPortCounters(this.vfPortCounterTask, this.vfPortCounterCallback);
            }
        }
        this.graphSection.clear();
        this.errorsSection.clear();
        this.lastPortNum = (short)-1;
        this.lastLid = -1;
    }

    @Override
    public PageWeight getContextSwitchWeight() {
        return PageWeight.MEDIUM;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return PageWeight.MEDIUM;
    }
}

