/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.tree;

import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.tree.ITreeMonitor;
import com.intel.stl.ui.monitor.tree.TreeNodeFactory;
import com.intel.stl.ui.monitor.tree.TreeSynchronizer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreationBasedNodesSynchronizer
extends TreeSynchronizer<Long> {
    private static final Logger log = LoggerFactory.getLogger(CreationBasedNodesSynchronizer.class);
    private final ISubnetApi subnetApi;
    private final Map<Long, NodeRecordBean> nodeMap;

    public CreationBasedNodesSynchronizer(ISubnetApi subnetApi, Map<Long, NodeRecordBean> nodeMap) {
        super(false);
        this.subnetApi = subnetApi;
        this.nodeMap = nodeMap;
    }

    @Override
    protected int compare(FVResourceNode node, Long element) {
        int res = Long.compare(node.getGuid(), element);
        if (res != 0) {
            String name1 = node.getName();
            NodeRecordBean node2 = this.nodeMap.get(element);
            String name2 = node2 == null ? null : node2.getNodeDesc();
            res = TreeNodeFactory.comapreNodeName(name1, name2);
        }
        return res;
    }

    @Override
    protected FVResourceNode createNode(Long guid) {
        NodeRecordBean bean = this.nodeMap.get(guid);
        return bean == null ? new FVResourceNode("null", null, -1) : TreeNodeFactory.createNode(bean);
    }

    @Override
    protected FVResourceNode addNode(int index, Long id, FVResourceNode parent, List<ITreeMonitor> monitors, IProgressObserver observer) {
        FVResourceNode node = super.addNode(index, id, parent, monitors, observer);
        this.updateNode(node, parent, monitors, observer);
        return node;
    }

    @Override
    protected void updateNode(FVResourceNode node, FVResourceNode parent, List<ITreeMonitor> monitors, IProgressObserver observer) {
        FVResourceNode port;
        int i;
        NodeRecordBean bean = this.nodeMap.get(node.getGuid());
        if (bean == null) {
            log.warn("Couldn't update tree because no node " + node.getId() + ":" + node.getGuid() + " found");
            return;
        }
        node.setId(bean.getLid());
        node.setTitle(bean.getNodeDesc());
        HashMap<Integer, FVResourceNode> updated = new HashMap<Integer, FVResourceNode>();
        boolean hasStructureChange = false;
        int numPorts = bean.getNodeInfo().getNumPorts();
        if (node.getType() == TreeNodeType.SWITCH) {
            ++numPorts;
        }
        int toUpdate = Math.min(numPorts, node.getChildCount());
        for (i = 0; i < toUpdate; ++i) {
            port = node.getChildAt(i);
            boolean statusChanged = this.setPortStatus(node, port);
            if (!statusChanged) continue;
            updated.put(i, port);
        }
        if (toUpdate < node.getChildCount()) {
            while (node.getChildCount() > toUpdate) {
                node.removeChild(toUpdate);
                if (hasStructureChange) continue;
                hasStructureChange = true;
            }
        } else if (toUpdate < numPorts) {
            if (node.getType() == TreeNodeType.SWITCH) {
                --numPorts;
                --toUpdate;
            }
            for (i = toUpdate + 1; i <= numPorts; ++i) {
                port = new FVResourceNode(Integer.toString(i), TreeNodeType.ACTIVE_PORT, i);
                this.setPortStatus(node, port);
                node.addChild(port);
                if (hasStructureChange) continue;
                hasStructureChange = true;
            }
        }
        if (node.getChildCount() == 0) {
            log.error("Empty Node: numPorts=" + numPorts + " toUpdate=" + toUpdate + " NodeRecordBean=" + bean, (Throwable)new Exception("Empty Node"));
        }
        if (monitors == null) {
            return;
        }
        if (hasStructureChange) {
            this.fireStructureChanged(monitors, node);
        } else if (!updated.isEmpty()) {
            for (Integer childIndex : updated.keySet()) {
                this.fireNodesUpdated(monitors, node, childIndex, (FVResourceNode)updated.get(childIndex));
            }
        }
    }

    private boolean setPortStatus(FVResourceNode parentNode, FVResourceNode portNode) {
        int lid = parentNode.getId();
        int portNum = portNode.getId();
        boolean isActive = false;
        if (parentNode.getType() == TreeNodeType.SWITCH) {
            isActive = this.subnetApi.hasPort(lid, (short)portNum);
        } else {
            assert (portNum > 0) : "HFI(" + parentNode + ") has invalid local port number " + portNum;
            isActive = this.subnetApi.hasLocalPort(lid, (short)portNum);
        }
        if (isActive) {
            if (portNode.getType() != TreeNodeType.ACTIVE_PORT) {
                portNode.setType(TreeNodeType.ACTIVE_PORT);
                return true;
            }
        } else if (portNode.getType() != TreeNodeType.INACTIVE_PORT) {
            portNode.setType(TreeNodeType.INACTIVE_PORT);
            return true;
        }
        return false;
    }
}

