/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.tree;

import com.intel.stl.api.performance.GroupListBean;
import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.monitor.tree.CreationBasedNodesSynchronizer;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.tree.ITreeMonitor;
import com.intel.stl.ui.monitor.tree.ITreeUpdater;
import com.intel.stl.ui.monitor.tree.TreeNodeFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceGroupsTreeUpdater
implements ITreeUpdater {
    private static final Logger log = LoggerFactory.getLogger(DeviceGroupsTreeUpdater.class);
    private final ISubnetApi subnetApi;
    private final IPerformanceApi perfApi;
    private Map<String, Integer> groups;
    protected final Comparator<FVResourceNode> groupNodeComparator;
    protected final Comparator<FVResourceNode> nodeComparator;

    public DeviceGroupsTreeUpdater(ISubnetApi subnetApi, IPerformanceApi perfApi) {
        this.subnetApi = subnetApi;
        this.perfApi = perfApi;
        this.initData();
        this.groupNodeComparator = TreeNodeFactory.getGroupNodeComparator(this.groups);
        this.nodeComparator = TreeNodeFactory.getNodeComparator();
    }

    protected void initData() {
        List<GroupListBean> groupList = this.perfApi.getGroupList();
        this.groups = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < groupList.size(); ++i) {
            this.groups.put(groupList.get(i).getGroupName(), i);
        }
    }

    @Override
    public void addNode(int lid, FVResourceNode tree, List<ITreeMonitor> monitors) {
        this.updateNode(lid, tree, true, monitors);
    }

    @Override
    public void updateNode(int lid, FVResourceNode tree, List<ITreeMonitor> monitors) {
        this.updateNode(lid, tree, true, monitors);
    }

    @Override
    public void removeNode(int lid, FVResourceNode tree, boolean removeEmptyParents, List<ITreeMonitor> monitors) {
        this.updateNode(lid, tree, removeEmptyParents, monitors);
    }

    public void updateNode(int lid, FVResourceNode tree, boolean removeEmptyParents, List<ITreeMonitor> monitors) {
        NodeRecordBean bean = null;
        try {
            bean = this.subnetApi.getNode(lid);
        }
        catch (SubnetDataNotFoundException subnetDataNotFoundException) {
            // empty catch block
        }
        if (bean == null || !bean.isActive()) {
            this.removeDeviceGroupsNode(lid, tree, removeEmptyParents, monitors);
            return;
        }
        long guid = bean.getNodeInfo().getNodeGUID();
        HashMap<Long, NodeRecordBean> nodeMap = new HashMap<Long, NodeRecordBean>();
        nodeMap.put(guid, bean);
        CreationBasedNodesSynchronizer nodeUpdater = new CreationBasedNodesSynchronizer(this.subnetApi, nodeMap);
        List<String> groups = this.perfApi.getDeviceGroup(lid);
        for (String group : groups) {
            FVResourceNode groupNode = this.getGroupNode(group, tree, monitors);
            FVResourceNode node = TreeNodeFactory.createNode(bean);
            Vector<FVResourceNode> children = groupNode.getChildren();
            int index = Collections.binarySearch(children, node, this.nodeComparator);
            if (index < 0) {
                index = -index - 1;
                nodeUpdater.addNode(index, guid, groupNode, monitors, (IProgressObserver)null);
                continue;
            }
            FVResourceNode updateNode = groupNode.getChildAt(index);
            nodeUpdater.updateNode(updateNode, groupNode, monitors, null);
        }
    }

    protected FVResourceNode getGroupNode(String group, FVResourceNode parent, List<ITreeMonitor> monitors) {
        FVResourceNode oldNode;
        if (!this.groups.containsKey(group)) {
            this.initData();
        }
        int id = this.groups.get(group);
        FVResourceNode node = TreeNodeFactory.createGroupNode(group, id);
        FVResourceNode fVResourceNode = oldNode = id < parent.getChildCount() ? parent.getChildAt(id) : null;
        if (!node.equals(oldNode)) {
            parent.addChild(id, node);
            if (monitors != null) {
                for (ITreeMonitor monitor : monitors) {
                    monitor.fireTreeNodesInserted(this, parent.getPath().getPath(), new int[]{id}, new FVResourceNode[]{node});
                }
            }
        } else {
            node = oldNode;
        }
        return node;
    }

    public void removeDeviceGroupsNode(int lid, FVResourceNode tree, boolean removeEmptyParents, List<ITreeMonitor> monitors) {
        block0: for (int i = 0; i < tree.getChildCount(); ++i) {
            FVResourceNode groupNode = tree.getChildAt(i);
            for (int j = 0; j < groupNode.getChildCount(); ++j) {
                FVResourceNode node = groupNode.getChildAt(j);
                if (node.getId() != lid) continue;
                int index = j;
                FVResourceNode parent = groupNode;
                if (removeEmptyParents && groupNode.getChildCount() == 1) {
                    index = tree.getIndex(groupNode);
                    parent = tree;
                }
                parent.removeChild(index);
                if (monitors == null) continue block0;
                for (ITreeMonitor monitor : monitors) {
                    monitor.fireTreeNodesRemoved(this, parent.getPath().getPath(), new int[]{index}, new FVResourceNode[]{node});
                }
                continue block0;
            }
        }
    }
}

