/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.tree;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.NameSorter;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.CreationBasedNodesSynchronizer;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.tree.ITreeMonitor;
import com.intel.stl.ui.monitor.tree.TreeNodeFactory;
import com.intel.stl.ui.monitor.tree.TreeSynchronizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DeviceTypesTreeSynchronizer
extends TreeSynchronizer<TreeNodeType> {
    private final ISubnetApi subnetApi;
    private Map<Long, NodeRecordBean> nodeMap;
    private Map<TreeNodeType, List<Long>> typeMap;
    private final CreationBasedNodesSynchronizer nodesUpadter;

    public DeviceTypesTreeSynchronizer(ISubnetApi subnetApi) {
        this(subnetApi, true);
    }

    public DeviceTypesTreeSynchronizer(ISubnetApi subnetApi, boolean removeEmptyGroup) {
        super(removeEmptyGroup);
        this.subnetApi = subnetApi;
        this.initData();
        this.nodesUpadter = new CreationBasedNodesSynchronizer(subnetApi, this.nodeMap);
    }

    protected void initData() {
        List<NodeRecordBean> allNodeBeans;
        try {
            allNodeBeans = this.subnetApi.getNodes(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(UILabels.STL90005_UPDATE_TREE_FAILED.getDescription(STLConstants.K0407_DEVICE_TYPES.getValue(), StringUtils.getErrorMessage(e)));
        }
        this.nodeMap = new HashMap<Long, NodeRecordBean>();
        HashMap<NodeType, LinkedList<Long>> nodeTypeMap = new HashMap<NodeType, LinkedList<Long>>();
        for (NodeRecordBean node : allNodeBeans) {
            long guid = node.getNodeInfo().getNodeGUID();
            this.nodeMap.put(guid, node);
            NodeType type = node.getNodeType();
            LinkedList<Long> members = (LinkedList<Long>)nodeTypeMap.get((Object)type);
            if (members == null) {
                members = new LinkedList<Long>();
                nodeTypeMap.put(type, members);
            }
            members.add(guid);
        }
        this.typeMap = new LinkedHashMap<TreeNodeType, List<Long>>();
        Comparator<Long> comparator = new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                NodeRecordBean node1 = (NodeRecordBean)DeviceTypesTreeSynchronizer.this.nodeMap.get(o1);
                NodeRecordBean node2 = (NodeRecordBean)DeviceTypesTreeSynchronizer.this.nodeMap.get(o2);
                String name1 = node1 == null ? null : node1.getNodeDesc();
                String name2 = node2 == null ? null : node2.getNodeDesc();
                return NameSorter.instance().compare(name1, name2);
            }
        };
        List members = (List)nodeTypeMap.get((Object)NodeType.HFI);
        if (members != null) {
            Collections.sort(members, comparator);
            this.typeMap.put(TreeNodeType.HCA_GROUP, members);
        }
        if ((members = (List)nodeTypeMap.get((Object)NodeType.SWITCH)) != null) {
            Collections.sort(members, comparator);
            this.typeMap.put(TreeNodeType.SWITCH_GROUP, members);
        }
        if ((members = (List)nodeTypeMap.get((Object)NodeType.ROUTER)) != null) {
            Collections.sort(members, comparator);
            this.typeMap.put(TreeNodeType.ROUTER_GROUP, members);
        }
    }

    public void updateTree(FVResourceNode parent, List<ITreeMonitor> monitors, IProgressObserver observer) {
        ArrayList<TreeNodeType> types = new ArrayList<TreeNodeType>();
        for (TreeNodeType type : this.typeMap.keySet()) {
            if (this.typeMap.get((Object)type).isEmpty()) continue;
            types.add(type);
        }
        this.updateTree(parent, types.toArray(new TreeNodeType[0]), monitors, observer);
    }

    @Override
    protected int compare(FVResourceNode node, TreeNodeType element) {
        return TreeNodeFactory.comapreTreeNodeType(node.getType(), element);
    }

    @Override
    protected FVResourceNode createNode(TreeNodeType type) {
        return TreeNodeFactory.createTypeNode(type);
    }

    @Override
    protected FVResourceNode addNode(int index, TreeNodeType key, FVResourceNode parent, List<ITreeMonitor> monitors, IProgressObserver observer) {
        FVResourceNode node = super.addNode(index, key, parent, monitors, observer);
        this.updateNode(node, parent, monitors, observer);
        return node;
    }

    @Override
    protected void updateNode(FVResourceNode node, FVResourceNode parent, List<ITreeMonitor> monitors, IProgressObserver observer) {
        TreeNodeType type = node.getType();
        List<Long> elements = this.typeMap.get((Object)type);
        if (elements != null) {
            this.nodesUpadter.updateTree(node, elements.toArray(new Long[0]), monitors, observer);
        }
    }
}

