/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.tree;

import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.common.IContextAware;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.ObserverAdapter;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.TimeDrivenProgressObserver;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.TreeSearchType;
import com.intel.stl.ui.monitor.TreeTypeEnum;
import com.intel.stl.ui.monitor.tree.DeviceGroupsTreeSynchronizer;
import com.intel.stl.ui.monitor.tree.DeviceGroupsTreeUpdater;
import com.intel.stl.ui.monitor.tree.DeviceTypesTreeSynchronizer;
import com.intel.stl.ui.monitor.tree.DeviceTypesTreeUpdater;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.tree.ITreeMonitor;
import com.intel.stl.ui.monitor.tree.SearchResult;
import com.intel.stl.ui.monitor.tree.SearchTreeBuilder;
import com.intel.stl.ui.monitor.tree.VirtualFabricsTreeSynchronizer;
import com.intel.stl.ui.monitor.tree.VirtualFabricsTreeUpdater;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FVTreeManager
implements IContextAware {
    private static final String NAME = "TreeManager";
    Logger mLog = LoggerFactory.getLogger(FVTreeManager.class);
    SubnetDescription subnet;
    ISubnetApi mSubnetApi;
    IPerformanceApi mPerformanceApi;
    SearchTreeBuilder searchBuilder;
    private final EnumMap<TreeTypeEnum, TreeManagementModel> mgrModels = new EnumMap(TreeTypeEnum.class);

    public FVTreeManager() {
        for (TreeTypeEnum type : TreeTypeEnum.values()) {
            this.mgrModels.put(type, new TreeManagementModel());
        }
        this.searchBuilder = new SearchTreeBuilder();
    }

    @Override
    public synchronized void setContext(Context pContext, IProgressObserver observer) {
        this.mLog.info("Clear trees because context being set for " + pContext.getSubnetDescription());
        this.subnet = pContext.getSubnetDescription();
        this.mSubnetApi = pContext.getSubnetApi();
        this.mPerformanceApi = pContext.getPerformanceApi();
        this.reset();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public synchronized FVResourceNode buildTree(TreeTypeEnum pTreeType, IProgressObserver observer) {
        long t = System.currentTimeMillis();
        if (observer == null) {
            observer = new ObserverAdapter();
        }
        FVResourceNode node = null;
        switch (pTreeType) {
            case DEVICE_TYPES_TREE: {
                node = this.createDeviceTypesTree(observer);
                break;
            }
            case DEVICE_GROUPS_TREE: {
                node = this.createDeviceGroupsTree(observer);
                break;
            }
            case VIRTUAL_FABRICS_TREE: {
                node = this.createVFsTree(observer);
                break;
            }
            case TOP_10_CONGESTED_TREE: {
                observer.onFinish();
                break;
            }
        }
        this.mLog.info("Build tree " + (Object)((Object)pTreeType) + " in " + (System.currentTimeMillis() - t) + " ms");
        return node;
    }

    public synchronized void updateTree(TreeTypeEnum pTreeType, IProgressObserver observer) {
        long t = System.currentTimeMillis();
        if (observer == null) {
            observer = new ObserverAdapter();
        }
        switch (pTreeType) {
            case DEVICE_TYPES_TREE: {
                this.updateDeviceTypesTree(observer);
                break;
            }
            case DEVICE_GROUPS_TREE: {
                this.updateDeviceGroupsTree(observer);
                break;
            }
            case VIRTUAL_FABRICS_TREE: {
                this.updateVFsTree(observer);
                break;
            }
            case TOP_10_CONGESTED_TREE: {
                observer.onFinish();
                break;
            }
        }
        this.mLog.info("Update tree " + (Object)((Object)pTreeType) + " in " + (System.currentTimeMillis() - t) + " ms");
    }

    public synchronized void updateTreeNode(int lid, TreeTypeEnum pTreeType) {
        long t = System.currentTimeMillis();
        switch (pTreeType) {
            case DEVICE_TYPES_TREE: {
                this.updateDeviceTypesTreeNode(lid);
                break;
            }
            case DEVICE_GROUPS_TREE: {
                this.updateDeviceGroupsTreeNode(lid);
                break;
            }
            case VIRTUAL_FABRICS_TREE: {
                this.updateVFsTreeNode(lid);
                break;
            }
            case TOP_10_CONGESTED_TREE: {
                break;
            }
        }
        this.mLog.info("Update tree node" + (Object)((Object)pTreeType) + " in " + (System.currentTimeMillis() - t) + " ms");
    }

    public synchronized SearchResult searchTreeNode(TreeTypeEnum treeType, TreeSearchType searchType, String searchKey, TimeDrivenProgressObserver observer, ICancelIndicator cancelIndicator) {
        TreeManagementModel model = this.mgrModels.get((Object)treeType);
        SearchResult result = null;
        if (model != null && model.isValid()) {
            FVResourceNode treeRoot = model.getTree();
            result = this.searchBuilder.searchAndBuildTree(treeType, searchType, searchKey, treeRoot, observer, cancelIndicator);
        } else if (treeType != TreeTypeEnum.TOP_10_CONGESTED_TREE) {
            throw new RuntimeException("Tree is under change " + model);
        }
        return result;
    }

    public void addMonitor(TreeTypeEnum treeType, ITreeMonitor monitor) {
        TreeManagementModel model = this.mgrModels.get((Object)treeType);
        if (model == null) {
            throw new IllegalArgumentException("Couldn't find TreeManagementModel for " + (Object)((Object)treeType));
        }
        model.addTreeMonitor(monitor);
    }

    public void removeMonitor(TreeTypeEnum treeType, ITreeMonitor monitor) {
        TreeManagementModel model = this.mgrModels.get((Object)treeType);
        if (model == null) {
            throw new IllegalArgumentException("Couldn't find TreeManagementModel for " + (Object)((Object)treeType));
        }
        model.removeTreeMonitor(monitor);
    }

    public synchronized void reset() {
        for (TreeManagementModel model : this.mgrModels.values()) {
            model.reset();
        }
    }

    public synchronized void setDirty() {
        for (TreeManagementModel model : this.mgrModels.values()) {
            model.setDirty(true);
        }
    }

    protected FVResourceNode createDeviceTypesTree(IProgressObserver observer) {
        TreeManagementModel model;
        if (observer == null) {
            observer = new ObserverAdapter();
        }
        if ((model = this.mgrModels.get((Object)TreeTypeEnum.DEVICE_TYPES_TREE)).isValid()) {
            observer.onFinish();
            return model.getTree();
        }
        FVResourceNode deviceTypesTree = new FVResourceNode(this.subnet.getName(), TreeNodeType.ALL, TreeNodeType.ALL.ordinal());
        DeviceTypesTreeSynchronizer treeUpdater = new DeviceTypesTreeSynchronizer(this.mSubnetApi);
        treeUpdater.updateTree(deviceTypesTree, null, observer);
        model.setTree(deviceTypesTree);
        return deviceTypesTree;
    }

    protected void updateDeviceTypesTree(IProgressObserver observer) {
        TreeManagementModel model = this.mgrModels.get((Object)TreeTypeEnum.DEVICE_TYPES_TREE);
        if (model.isEmpty()) {
            this.createDeviceTypesTree(observer);
            return;
        }
        if (model.isDirty()) {
            DeviceTypesTreeSynchronizer treeUpdater = new DeviceTypesTreeSynchronizer(this.mSubnetApi);
            treeUpdater.updateTree(model.getTree(), model.getMonitors(), observer);
            model.setDirty(false);
        }
        if (observer != null) {
            observer.onFinish();
        }
    }

    protected void updateDeviceTypesTreeNode(int lid) {
        TreeManagementModel model = this.mgrModels.get((Object)TreeTypeEnum.DEVICE_TYPES_TREE);
        if (model.isEmpty()) {
            return;
        }
        DeviceTypesTreeUpdater treeUpdater = new DeviceTypesTreeUpdater(this.mSubnetApi);
        FVResourceNode tree = model.getTree();
        List<ITreeMonitor> monitors = model.getMonitors();
        treeUpdater.updateNode(lid, tree, monitors);
    }

    protected FVResourceNode createDeviceGroupsTree(IProgressObserver observer) {
        TreeManagementModel model;
        if (observer == null) {
            observer = new ObserverAdapter();
        }
        if ((model = this.mgrModels.get((Object)TreeTypeEnum.DEVICE_GROUPS_TREE)).isValid()) {
            return model.getTree();
        }
        IProgressObserver[] subObservers = observer.createSubObservers(2);
        FVResourceNode deviceGroupsTree = new FVResourceNode(this.subnet.getName(), TreeNodeType.ALL, TreeNodeType.ALL.ordinal());
        FVResourceNode subnetTree = this.createDeviceTypesTree(subObservers[0]);
        subObservers[0].onFinish();
        DeviceGroupsTreeSynchronizer treeUpdater = new DeviceGroupsTreeSynchronizer(this.mPerformanceApi, subnetTree);
        treeUpdater.updateTree(deviceGroupsTree, null, subObservers[1]);
        subObservers[1].onFinish();
        model.setTree(deviceGroupsTree);
        return deviceGroupsTree;
    }

    protected void updateDeviceGroupsTree(IProgressObserver observer) {
        TreeManagementModel model = this.mgrModels.get((Object)TreeTypeEnum.DEVICE_GROUPS_TREE);
        if (model.isEmpty()) {
            this.createDeviceGroupsTree(observer);
            return;
        }
        if (model.isDirty()) {
            if (observer == null) {
                observer = new ObserverAdapter();
            }
            IProgressObserver[] subObservers = observer.createSubObservers(2);
            FVResourceNode subnetTree = this.createDeviceTypesTree(subObservers[0]);
            subObservers[0].onFinish();
            DeviceGroupsTreeSynchronizer treeUpdater = new DeviceGroupsTreeSynchronizer(this.mPerformanceApi, subnetTree);
            treeUpdater.updateTree(model.getTree(), model.getMonitors(), subObservers[1]);
            subObservers[1].onFinish();
            model.setDirty(false);
        }
        if (observer != null) {
            observer.onFinish();
        }
    }

    protected void updateDeviceGroupsTreeNode(int lid) {
        TreeManagementModel model = this.mgrModels.get((Object)TreeTypeEnum.DEVICE_GROUPS_TREE);
        if (model.isEmpty()) {
            return;
        }
        DeviceGroupsTreeUpdater treeUpdater = new DeviceGroupsTreeUpdater(this.mSubnetApi, this.mPerformanceApi);
        FVResourceNode tree = model.getTree();
        List<ITreeMonitor> monitors = model.getMonitors();
        treeUpdater.updateNode(lid, tree, monitors);
    }

    protected FVResourceNode createVFsTree(IProgressObserver observer) {
        TreeManagementModel model;
        if (observer == null) {
            observer = new ObserverAdapter();
        }
        if ((model = this.mgrModels.get((Object)TreeTypeEnum.VIRTUAL_FABRICS_TREE)).isValid()) {
            observer.onFinish();
            return model.getTree();
        }
        IProgressObserver[] subObsevers = observer.createSubObservers(2);
        FVResourceNode vfTree = new FVResourceNode(this.subnet.getName(), TreeNodeType.ALL, TreeNodeType.ALL.ordinal());
        FVResourceNode subnetTree = this.createDeviceTypesTree(subObsevers[0]);
        subObsevers[0].onFinish();
        VirtualFabricsTreeSynchronizer treeUpdater = new VirtualFabricsTreeSynchronizer(this.mPerformanceApi, subnetTree);
        treeUpdater.updateTree(vfTree, null, subObsevers[1]);
        subObsevers[1].onFinish();
        model.setTree(vfTree);
        return vfTree;
    }

    protected void updateVFsTree(IProgressObserver observer) {
        TreeManagementModel model = this.mgrModels.get((Object)TreeTypeEnum.VIRTUAL_FABRICS_TREE);
        if (model.isEmpty()) {
            this.createVFsTree(observer);
            return;
        }
        if (model.isDirty()) {
            if (observer == null) {
                observer = new ObserverAdapter();
            }
            IProgressObserver[] subObservers = observer.createSubObservers(2);
            FVResourceNode subnetTree = this.createDeviceTypesTree(subObservers[0]);
            subObservers[0].onFinish();
            VirtualFabricsTreeSynchronizer treeUpdater = new VirtualFabricsTreeSynchronizer(this.mPerformanceApi, subnetTree);
            treeUpdater.updateTree(model.getTree(), model.getMonitors(), subObservers[1]);
            subObservers[1].onFinish();
            model.setDirty(false);
        }
        if (observer != null) {
            observer.onFinish();
        }
    }

    protected void updateVFsTreeNode(int lid) {
        TreeManagementModel model = this.mgrModels.get((Object)TreeTypeEnum.VIRTUAL_FABRICS_TREE);
        if (model.isEmpty()) {
            return;
        }
        VirtualFabricsTreeUpdater treeUpdater = new VirtualFabricsTreeUpdater(this.mSubnetApi, this.mPerformanceApi);
        treeUpdater.updateNode(lid, model.getTree(), model.getMonitors());
    }

    @Override
    public PageWeight getContextSwitchWeight() {
        return PageWeight.MEDIUM;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return PageWeight.MEDIUM;
    }

    public EnumMap<TreeTypeEnum, TreeManagementModel> getMgrModels() {
        return this.mgrModels;
    }

    public class TreeManagementModel {
        private FVResourceNode tree;
        private boolean isDirty = true;
        private final List<ITreeMonitor> monitors = new ArrayList<ITreeMonitor>();

        public FVResourceNode getTree() {
            return this.tree;
        }

        public void setTree(FVResourceNode tree) {
            this.tree = tree;
            this.isDirty = false;
        }

        public boolean isDirty() {
            return this.isDirty;
        }

        public void setDirty(boolean isDirty) {
            this.isDirty = isDirty;
        }

        public void addTreeMonitor(ITreeMonitor monitor) {
            this.monitors.add(monitor);
        }

        public void removeTreeMonitor(ITreeMonitor monitor) {
            this.monitors.remove(monitor);
        }

        public List<ITreeMonitor> getMonitors() {
            return this.monitors;
        }

        public boolean isValid() {
            return this.tree != null && !this.isDirty;
        }

        public boolean isEmpty() {
            return this.tree == null;
        }

        public void reset() {
            this.tree = null;
            this.isDirty = true;
        }
    }
}

