/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.tree;

import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.tree.INodeVisbilityIndicator;
import com.intel.stl.ui.monitor.tree.ITreeMonitor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FVTreeModel
implements TreeModel,
ITreeMonitor {
    private static final Logger log = LoggerFactory.getLogger(FVTreeModel.class);
    private final FVResourceNode mRootNode;
    private FVResourceNode vizRootNode;
    private final Vector<TreeModelListener> mListeners = new Vector();

    public FVTreeModel(FVResourceNode pRootNode) {
        this.mRootNode = this.vizRootNode = pRootNode;
    }

    @Override
    public Object getRoot() {
        return this.vizRootNode;
    }

    public Object getOrgRoot() {
        return this.mRootNode;
    }

    public void filter(INodeVisbilityIndicator indicator) {
        if (this.mRootNode != null) {
            this.vizRootNode = indicator.isEnabled() ? this.mRootNode.filter(indicator) : this.mRootNode;
        }
    }

    @Override
    public Object getChild(Object pParent, int pIndex) {
        TreeNode parent = (TreeNode)pParent;
        return parent.getChildAt(pIndex);
    }

    @Override
    public int getChildCount(Object pParent) {
        TreeNode parent = (TreeNode)pParent;
        return parent.getChildCount();
    }

    @Override
    public boolean isLeaf(Object pNode) {
        TreeNode node = (TreeNode)pNode;
        return node.isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object pParent, Object pChild) {
        TreeNode parent = (TreeNode)pParent;
        TreeNode child = (TreeNode)pChild;
        return parent.getIndex(child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener pListener) {
        this.mListeners.add(pListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener pListener) {
        this.mListeners.remove(pListener);
    }

    public TreePath getTreePath(TreePath old) throws IllegalArgumentException {
        FVResourceNode currentRoot;
        Object[] elements = old.getPath();
        if (elements[0] == (currentRoot = (FVResourceNode)this.getRoot())) {
            return old;
        }
        Object[] newElements = new FVResourceNode[elements.length];
        newElements[0] = currentRoot;
        for (int i = 1; i < elements.length; ++i) {
            int index = ((FVResourceNode)newElements[i - 1]).getIndex((FVResourceNode)elements[i]);
            if (index == -1) {
                throw new IllegalArgumentException("Source TreePath doesn't match this model");
            }
            newElements[i] = ((FVResourceNode)newElements[i - 1]).getChildAt(index);
        }
        return new TreePath(newElements);
    }

    public TreePath[] getTreePaths(TreePath[] old) {
        ArrayList<TreePath> res = new ArrayList<TreePath>();
        for (TreePath path : old) {
            try {
                TreePath newPath = this.getTreePath(path);
                res.add(newPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return res.toArray(new TreePath[0]);
    }

    public TreePath getTreePath(int lid, TreeNodeType type, FVResourceNode hint) {
        FVResourceNode tmp = this.navigateTree(hint == null ? this.vizRootNode : hint, lid, type);
        if (tmp == null && hint != null) {
            tmp = this.siblingSearch(hint, lid, type);
        }
        if (tmp == null) {
            return null;
        }
        return tmp.getPath();
    }

    protected FVResourceNode siblingSearch(FVResourceNode node, int lid, TreeNodeType type) {
        FVResourceNode tmp = null;
        FVResourceNode parent = node.getParent();
        if (node.isPort()) {
            parent = parent.getParent();
        }
        if (parent == null) {
            return null;
        }
        int ref = parent.getIndex(node);
        int step = 1;
        while (ref - step >= 0 || ref + step < parent.getChildCount()) {
            if (ref + step < parent.getChildCount() && (tmp = this.navigateTree(node = parent.getChildAt(ref + step), lid, type)) != null) {
                return tmp;
            }
            if (ref - step >= 0 && (tmp = this.navigateTree(node = parent.getChildAt(ref - step), lid, type)) != null) {
                return tmp;
            }
            ++step;
        }
        return this.siblingSearch(parent, lid, type);
    }

    protected FVResourceNode navigateTree(FVResourceNode node, int lid, TreeNodeType type) {
        if (node.isTypeMatched(type) && node.getId() == lid) {
            return node;
        }
        if (node.getChildren() != null) {
            for (FVResourceNode child : node.getChildren()) {
                FVResourceNode tmp = this.navigateTree(child, lid, type);
                if (tmp == null) continue;
                return tmp;
            }
        }
        return null;
    }

    public TreePath getTreePathForPort(int lid, short portNum, FVResourceNode hint) {
        FVResourceNode tmp = this.navigateTree(hint == null ? this.vizRootNode : hint, lid, TreeNodeType.NODE);
        if (tmp == null && hint != null) {
            tmp = this.siblingSearch(hint, lid, TreeNodeType.NODE);
        }
        if (tmp == null) {
            return null;
        }
        TreeNodeType type = tmp.getType();
        if ((type == TreeNodeType.HFI || type == TreeNodeType.SWITCH || type == TreeNodeType.ROUTER) && tmp.getChildren() != null) {
            for (FVResourceNode port : tmp.getChildren()) {
                if (port.getId() != portNum) continue;
                return port.getPath();
            }
        }
        return tmp.getPath();
    }

    public TreePath getTreePath(String name, TreeNodeType type) {
        FVResourceNode res = this.navigateTree(name, type);
        if (res != null) {
            return res.getPath();
        }
        return null;
    }

    protected FVResourceNode navigateTree(String name, TreeNodeType type) {
        if (this.vizRootNode.getTitle().equals(name) && this.vizRootNode.getType() == type) {
            return this.vizRootNode;
        }
        LinkedList<FVResourceNode> toDo = new LinkedList<FVResourceNode>();
        toDo.add(this.vizRootNode);
        while (!toDo.isEmpty()) {
            FVResourceNode node = (FVResourceNode)toDo.poll();
            if (node.getChildCount() <= 0) continue;
            for (FVResourceNode child : node.getChildren()) {
                if (child.getTitle().equals(name) && child.getType() == type) {
                    return child;
                }
                toDo.add(child);
            }
        }
        return null;
    }

    @Override
    public void fireTreeNodesRemoved(Object source, final Object[] path, int[] childIndices, Object[] children) {
        if (this.vizRootNode != path[0]) {
            return;
        }
        final TreeModelEvent e = new TreeModelEvent(source, path, childIndices, children);
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                for (TreeModelListener listener : FVTreeModel.this.mListeners) {
                    try {
                        listener.treeNodesRemoved(e);
                    }
                    catch (Exception e1) {
                        log.warn("Error on remove nodes event " + e, (Throwable)e1);
                        ((FVResourceNode)path[path.length - 1]).dump(System.out, "E ");
                    }
                }
            }
        });
    }

    @Override
    public void fireTreeNodesInserted(Object source, final Object[] path, int[] childIndices, Object[] children) {
        if (this.vizRootNode != path[0]) {
            return;
        }
        final TreeModelEvent e = new TreeModelEvent(source, path, childIndices, children);
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                for (TreeModelListener listener : FVTreeModel.this.mListeners) {
                    try {
                        listener.treeNodesInserted(e);
                    }
                    catch (Exception e1) {
                        log.warn("Error on insert nodes event " + e, (Throwable)e1);
                        ((FVResourceNode)path[path.length - 1]).dump(System.out, "E ");
                    }
                }
            }
        });
    }

    @Override
    public void fireTreeNodesChanged(Object source, final Object[] path, int[] childIndices, Object[] children) {
        if (this.vizRootNode != path[0]) {
            return;
        }
        final TreeModelEvent e = new TreeModelEvent(source, path, childIndices, children);
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                for (TreeModelListener listener : FVTreeModel.this.mListeners) {
                    try {
                        listener.treeNodesChanged(e);
                    }
                    catch (Exception e1) {
                        log.warn("Error on nodes change event " + e, (Throwable)e1);
                        ((FVResourceNode)path[path.length - 1]).dump(System.out, "E ");
                    }
                }
            }
        });
    }

    @Override
    public void fireTreeStructureChanged(Object source, final TreePath path) {
        if (this.vizRootNode != path.getPath()[0]) {
            return;
        }
        final TreeModelEvent e = new TreeModelEvent(source, path);
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                for (TreeModelListener listener : FVTreeModel.this.mListeners) {
                    try {
                        listener.treeStructureChanged(e);
                    }
                    catch (Exception e1) {
                        log.warn("Error on structure change event " + e, (Throwable)e1);
                        ((FVResourceNode)path.getLastPathComponent()).dump(System.out, "E ");
                    }
                }
            }
        });
    }
}

