/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.tree;

import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.common.TimeDrivenProgressObserver;
import com.intel.stl.ui.monitor.TreeSearchType;
import com.intel.stl.ui.monitor.TreeTypeEnum;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.tree.INodeMatcher;
import com.intel.stl.ui.monitor.tree.NodeMatcherFactory;
import com.intel.stl.ui.monitor.tree.SearchResult;
import com.intel.stl.ui.monitor.tree.SearchResultNode;
import java.util.IdentityHashMap;

public class SearchTreeBuilder {
    private SearchResultNode resultTree;
    private IdentityHashMap<SearchResultNode, FVResourceNode> nodeMap;
    private INodeMatcher nodeMatcher;
    private TimeDrivenProgressObserver observer;
    private ICancelIndicator cancelIndicator;

    public SearchResult searchAndBuildTree(TreeTypeEnum treeType, TreeSearchType searchType, String searchKey, FVResourceNode root, TimeDrivenProgressObserver observer, ICancelIndicator cancelIndicator) {
        this.observer = observer;
        this.cancelIndicator = cancelIndicator;
        this.resultTree = null;
        this.nodeMap = new IdentityHashMap();
        this.nodeMatcher = NodeMatcherFactory.createNodeMatcher(searchType);
        String trimmed = searchKey.trim();
        if (!trimmed.isEmpty()) {
            this.resultTree = this.createResultNode(root);
            this.navigateTree(root, trimmed, this.resultTree);
        }
        return this.resultTree == null || this.resultTree.getChildCount() == 0 ? null : new SearchResult(treeType, this.resultTree, this.nodeMap);
    }

    protected void navigateTree(FVResourceNode node, String searchKey, FVResourceNode result) {
        if (this.cancelIndicator.isCancelled()) {
            this.resultTree = null;
            return;
        }
        if (node.isNode()) {
            if (this.nodeMatcher != null && this.nodeMatcher.isMatched(node, searchKey)) {
                SearchResultNode leaf = this.createResultNode(node);
                result.addChild(leaf);
                this.nodeMap.put(leaf, node);
            }
            this.observer.publishProgress(1);
            return;
        }
        if (node.getChildren() != null) {
            for (FVResourceNode child : node.getChildren()) {
                if (this.cancelIndicator.isCancelled()) {
                    this.resultTree = null;
                    return;
                }
                if (child.isNode()) {
                    this.navigateTree(child, searchKey, result);
                    continue;
                }
                SearchResultNode copy = this.createResultNode(child);
                this.navigateTree(child, searchKey, copy);
                if (copy.getChildCount() <= 0) continue;
                result.addChild(copy);
            }
        }
    }

    private SearchResultNode createResultNode(FVResourceNode node) {
        return node.isNode() ? new SearchResultNode(node.getTitle(), node.getType(), node.getId(), node.getGuid()) : new SearchResultNode(node.getTitle(), node.getType(), node.getId());
    }

    public SearchResultNode getResultTree() {
        return this.resultTree;
    }
}

