/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.tree;

import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.ObserverAdapter;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.tree.ITreeMonitor;
import java.util.List;

public abstract class TreeSynchronizer<E> {
    protected final boolean removeEmptyGroup;

    public TreeSynchronizer(boolean removeEmptyGroup) {
        this.removeEmptyGroup = removeEmptyGroup;
    }

    public void updateTree(FVResourceNode parent, E[] elements, List<ITreeMonitor> monitors, IProgressObserver observer) {
        if (elements == null || elements.length == 0) {
            return;
        }
        if (observer == null) {
            observer = new ObserverAdapter();
        }
        int oldIndex = 0;
        int newIndex = 0;
        FVResourceNode oldNode = oldIndex >= parent.getChildCount() ? null : parent.getChildAt(oldIndex);
        E element = elements[newIndex];
        while (oldNode != null || element != null) {
            int comp;
            int n = oldNode == null ? 1 : (comp = element == null ? -1 : this.compare(oldNode, element));
            if (comp == 0) {
                this.updateNode(oldNode, parent, monitors, observer);
                oldNode = ++oldIndex >= parent.getChildCount() ? null : parent.getChildAt(oldIndex);
                element = ++newIndex >= elements.length ? null : elements[newIndex];
                continue;
            }
            if (comp > 0) {
                this.addNode(oldIndex, element, parent, monitors, observer);
                ++oldIndex;
                element = ++newIndex >= elements.length ? null : elements[newIndex];
                continue;
            }
            this.removeNode(oldIndex, oldNode, parent, monitors, observer);
            oldNode = oldIndex >= parent.getChildCount() ? null : parent.getChildAt(oldIndex);
        }
        if (this.removeEmptyGroup) {
            for (int i = 0; i < parent.getChildCount(); ++i) {
                FVResourceNode node = parent.getChildAt(i);
                if (node.getChildCount() != 0) continue;
                parent.removeChild(i);
                if (monitors != null) {
                    this.fireNodesRemoved(monitors, parent, i, node);
                }
                --i;
            }
        }
    }

    protected void fireNodesRemoved(List<ITreeMonitor> monitors, FVResourceNode parent, int childIndex, FVResourceNode child) {
        for (ITreeMonitor monitor : monitors) {
            monitor.fireTreeNodesRemoved(this, parent.getPath().getPath(), new int[]{childIndex}, new FVResourceNode[]{child});
        }
    }

    protected abstract int compare(FVResourceNode var1, E var2);

    protected FVResourceNode addNode(int index, E key, FVResourceNode parent, List<ITreeMonitor> monitors, IProgressObserver observer) {
        FVResourceNode node = this.createNode(key);
        assert (node != null) : "Node shoudn't be null";
        parent.addChild(index, node);
        if (monitors != null) {
            this.fireNodesInserted(monitors, parent, index, node);
        }
        return node;
    }

    protected void fireNodesInserted(List<ITreeMonitor> monitors, FVResourceNode parent, int childIndex, FVResourceNode child) {
        for (ITreeMonitor monitor : monitors) {
            monitor.fireTreeNodesInserted(this, parent.getPath().getPath(), new int[]{childIndex}, new FVResourceNode[]{child});
        }
    }

    protected abstract FVResourceNode createNode(E var1);

    protected void removeNode(int index, FVResourceNode node, FVResourceNode parent, List<ITreeMonitor> monitors, IProgressObserver observer) {
        parent.removeChild(index);
        if (monitors != null) {
            this.fireNodesRemoved(monitors, parent, index, node);
        }
    }

    protected abstract void updateNode(FVResourceNode var1, FVResourceNode var2, List<ITreeMonitor> var3, IProgressObserver var4);

    protected void fireNodesUpdated(List<ITreeMonitor> monitors, FVResourceNode parent, int childIndex, FVResourceNode child) {
        for (ITreeMonitor monitor : monitors) {
            monitor.fireTreeNodesChanged(this, parent.getPath().getPath(), new int[]{childIndex}, new FVResourceNode[]{child});
        }
    }

    protected void fireStructureChanged(List<ITreeMonitor> monitors, FVResourceNode node) {
        for (ITreeMonitor monitor : monitors) {
            monitor.fireTreeStructureChanged(this, node.getPath());
        }
    }
}

