/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.tree;

import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.performance.VFListBean;
import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.monitor.tree.CreationBasedNodesSynchronizer;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.tree.ITreeMonitor;
import com.intel.stl.ui.monitor.tree.ITreeUpdater;
import com.intel.stl.ui.monitor.tree.TreeNodeFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualFabricsTreeUpdater
implements ITreeUpdater {
    private static final Logger log = LoggerFactory.getLogger(VirtualFabricsTreeUpdater.class);
    private final ISubnetApi subnetApi;
    private final IPerformanceApi perfApi;
    private Map<String, Integer> vfNames;
    protected final Comparator<FVResourceNode> vfNodeComparator;
    protected final Comparator<FVResourceNode> nodeComparator;

    public VirtualFabricsTreeUpdater(ISubnetApi subnetApi, IPerformanceApi perfApi) {
        this.subnetApi = subnetApi;
        this.perfApi = perfApi;
        this.initData();
        this.vfNodeComparator = TreeNodeFactory.getVfNodeComparator(this.vfNames);
        this.nodeComparator = TreeNodeFactory.getNodeComparator();
    }

    protected void initData() {
        List<VFListBean> vfList = this.perfApi.getVFList();
        this.vfNames = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < vfList.size(); ++i) {
            this.vfNames.put(vfList.get(i).getVfName(), i);
        }
    }

    @Override
    public void addNode(int lid, FVResourceNode tree, List<ITreeMonitor> monitors) {
        this.updateNode(lid, tree, true, monitors);
    }

    @Override
    public void updateNode(int lid, FVResourceNode tree, List<ITreeMonitor> monitors) {
        this.updateNode(lid, tree, true, monitors);
    }

    @Override
    public void removeNode(int lid, FVResourceNode tree, boolean removeEmptyParents, List<ITreeMonitor> monitors) {
        this.updateNode(lid, tree, removeEmptyParents, monitors);
    }

    public void updateNode(int lid, FVResourceNode tree, boolean removeEmptyParents, List<ITreeMonitor> monitors) {
        NodeRecordBean bean = null;
        try {
            bean = this.subnetApi.getNode(lid);
        }
        catch (SubnetDataNotFoundException subnetDataNotFoundException) {
            // empty catch block
        }
        if (bean == null || !bean.isActive()) {
            this.removeVFNode(lid, tree, removeEmptyParents, monitors);
            return;
        }
        long guid = bean.getNodeInfo().getNodeGUID();
        HashMap<Long, NodeRecordBean> nodeMap = new HashMap<Long, NodeRecordBean>();
        nodeMap.put(guid, bean);
        List<String> vfNames = this.perfApi.getVFNames(lid);
        for (String name : vfNames) {
            FVResourceNode vfNode = this.getVfNode(name, tree, monitors);
            FVResourceNode node = TreeNodeFactory.createNode(bean);
            CreationBasedNodesSynchronizer nodeUpdater = new CreationBasedNodesSynchronizer(this.subnetApi, nodeMap);
            Vector<FVResourceNode> children = vfNode.getChildren();
            int index = Collections.binarySearch(children, node, this.nodeComparator);
            if (index < 0) {
                index = -index - 1;
                nodeUpdater.addNode(index, guid, vfNode, monitors, (IProgressObserver)null);
                continue;
            }
            FVResourceNode updateNode = vfNode.getChildAt(index);
            nodeUpdater.updateNode(updateNode, vfNode, monitors, null);
        }
    }

    protected FVResourceNode getVfNode(String vfName, FVResourceNode parent, List<ITreeMonitor> monitors) {
        FVResourceNode oldNode;
        if (!this.vfNames.containsKey(vfName)) {
            this.initData();
        }
        int id = this.vfNames.get(vfName);
        FVResourceNode node = TreeNodeFactory.createVfNode(vfName, id);
        FVResourceNode fVResourceNode = oldNode = id < parent.getChildCount() ? parent.getChildAt(id) : null;
        if (!node.equals(oldNode)) {
            parent.addChild(id, node);
            if (monitors != null) {
                for (ITreeMonitor monitor : monitors) {
                    monitor.fireTreeNodesInserted(this, parent.getPath().getPath(), new int[]{id}, new FVResourceNode[]{node});
                }
            }
        } else {
            node = oldNode;
        }
        return node;
    }

    public void removeVFNode(int lid, FVResourceNode tree, boolean removeEmptyParents, List<ITreeMonitor> monitors) {
        block0: for (int i = 0; i < tree.getChildCount(); ++i) {
            FVResourceNode vfNode = tree.getChildAt(i);
            for (int j = 0; j < vfNode.getChildCount(); ++j) {
                FVResourceNode node = vfNode.getChildAt(j);
                if (node.getId() != lid) continue;
                int index = j;
                FVResourceNode parent = vfNode;
                if (removeEmptyParents && vfNode.getChildCount() == 1) {
                    index = tree.getIndex(vfNode);
                    parent = tree;
                }
                parent.removeChild(index);
                if (monitors == null) continue block0;
                for (ITreeMonitor monitor : monitors) {
                    monitor.fireTreeNodesRemoved(this, parent.getPath().getPath(), new int[]{index}, new FVResourceNode[]{node});
                }
                continue block0;
            }
        }
    }
}

