/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.configuration.MultiColumnCategoryController;
import com.intel.stl.ui.configuration.view.MultiColumnCategoryPanel;
import com.intel.stl.ui.configuration.view.PropertyGroupPanel;
import com.intel.stl.ui.configuration.view.PropertyVizStyle;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.DevicePropertyGroup;
import com.intel.stl.ui.model.PropertySet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Popup;

public class CableInfoPopup
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 3258624627237634655L;
    private GroupPanel groupPanel;
    private final PropertyVizStyle style = new PropertyVizStyle(true, false);
    private JLabel lblHeader;
    private Popup popup;

    public CableInfoPopup() {
        this.initComponents();
        this.addMouseListener(this);
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(UIConstants.INTEL_BLUE));
        this.lblHeader = this.createHeader();
        this.add((Component)this.lblHeader, "North");
        this.groupPanel = new GroupPanel(this.style);
        this.add((Component)this.groupPanel.getContentComponent(), "Center");
    }

    protected JLabel createHeader() {
        this.lblHeader = ComponentFactory.getH4Label("", 1);
        this.lblHeader.setIcon(UIImages.CABLE.getImageIcon());
        this.lblHeader.setText(STLConstants.K3049_CABLE_INFO.getValue());
        this.lblHeader.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, UIConstants.INTEL_ORANGE));
        return this.lblHeader;
    }

    public void setModel(PropertySet<?> model) {
        PropertySet<?> cableInfoModel = model;
        DevicePropertyGroup group = (DevicePropertyGroup)cableInfoModel.getGroups().get(0);
        this.groupPanel.setModel(group);
    }

    public void setPopupIcon(ImageIcon icon, String name) {
        this.lblHeader.setIcon(icon);
        this.lblHeader.setText(name);
    }

    public synchronized Popup getPopup() {
        return this.popup;
    }

    public synchronized void setPopup(Popup popup) {
        this.hidePopup();
        this.popup = popup;
    }

    protected synchronized void hidePopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.popup != null && !this.getVisibleRect().contains(e.getPoint())) {
            this.hidePopup();
        }
    }

    class GroupPanel
    extends PropertyGroupPanel<DevicePropertyCategory, DevicePropertyGroup> {
        private static final long serialVersionUID = -9170550212900442484L;

        public GroupPanel(PropertyVizStyle style) {
            super(style);
        }

        @Override
        protected Component createCategoryPanel(DevicePropertyCategory category, PropertyVizStyle style) {
            MultiColumnCategoryPanel categoryPanel = new MultiColumnCategoryPanel(2, style);
            new MultiColumnCategoryController(category, categoryPanel, null);
            return categoryPanel;
        }
    }
}

