/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.ICardListener;
import com.intel.stl.ui.common.view.JCardView;
import com.intel.stl.ui.main.view.NodeStatesPie;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;

public class PSEventsCardView
extends JCardView<ICardListener> {
    private static final long serialVersionUID = -6152333230896989483L;
    private JPanel mainPanel;
    private NodeStatesPie piePanel;
    private ChartPanel barPanel;

    public PSEventsCardView(String title) {
        super(title);
        this.getMainComponent();
    }

    @Override
    protected JComponent getMainComponent() {
        if (this.mainPanel != null) {
            return this.mainPanel;
        }
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 5));
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 0;
        gc.weightx = 0.0;
        this.piePanel = new NodeStatesPie(false);
        this.piePanel.setOpaque(false);
        this.mainPanel.add((Component)this.piePanel, gc);
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.gridwidth = 0;
        this.barPanel = new ChartPanel(null);
        this.barPanel.setPreferredSize(new Dimension(60, 20));
        this.barPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PSEventsCardView.this.barPanel.setMaximumDrawHeight(e.getComponent().getHeight());
                PSEventsCardView.this.barPanel.setMaximumDrawWidth(e.getComponent().getWidth());
                PSEventsCardView.this.barPanel.setMinimumDrawWidth(e.getComponent().getWidth());
                PSEventsCardView.this.barPanel.setMinimumDrawHeight(e.getComponent().getHeight());
            }
        });
        this.barPanel.setOpaque(false);
        this.mainPanel.add((Component)this.barPanel, gc);
        return this.mainPanel;
    }

    public void setStateDataset(PieDataset dataset, Color[] colors) {
        this.piePanel.setDataset(dataset, colors);
    }

    public void setTrendDataset(TableXYDataset dataset, Color[] colors) {
        JFreeChart chart = ComponentFactory.createStackedXYBarChart((XYDataset)dataset, "", STLConstants.K0035_TIME.getValue(), STLConstants.K0055_NUM_NODES.getValue(), false);
        XYItemRenderer xyitemrenderer = chart.getXYPlot().getRenderer();
        for (int i = 0; i < colors.length; ++i) {
            xyitemrenderer.setSeriesPaint(i, (Paint)colors[i]);
        }
        this.barPanel.setChart(chart);
    }

    public void setStates(double[] values, String[] labels, String[] tooltips) {
        this.piePanel.setStates(values, labels, tooltips);
    }

    public NodeStatesPie getPiePanel() {
        return this.piePanel;
    }

    public void clear() {
        this.piePanel.clear();
    }
}

