/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.view.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class PSNodesDetailsPanel
extends JPanel {
    private static final long serialVersionUID = -8248761594760146918L;
    private JLabel numberLabel;
    private JLabel nameLabel;
    private ChartPanel typeChartPanel;
    private JLabel swNumberLabel;
    private JLabel swNameLabel;
    private JLabel fiNumberLabel;
    private JLabel fiNameLabel;
    private JLabel otherPortsLabel;

    public PSNodesDetailsPanel() {
        this.initComponent();
    }

    protected void initComponent() {
        this.setLayout(new BorderLayout(0, 0));
        this.setOpaque(false);
        this.setBorder(BorderFactory.createTitledBorder((Border)null));
        JPanel titlePanel = new JPanel(new BorderLayout(5, 1));
        titlePanel.setOpaque(false);
        this.numberLabel = ComponentFactory.getH1Label(STLConstants.K0039_NOT_AVAILABLE.getValue(), 0);
        this.numberLabel.setHorizontalAlignment(4);
        titlePanel.add((Component)this.numberLabel, "Center");
        this.nameLabel = ComponentFactory.getH3Label("", 0);
        this.nameLabel.setHorizontalAlignment(2);
        this.nameLabel.setVerticalAlignment(3);
        titlePanel.add((Component)this.nameLabel, "East");
        this.add((Component)titlePanel, "North");
        JPanel mainPanel = new JPanel();
        mainPanel.setOpaque(false);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        GridBagLayout gridBag = new GridBagLayout();
        mainPanel.setLayout(gridBag);
        GridBagConstraints gc = new GridBagConstraints();
        gc.weighty = 0.0;
        gc.insets = new Insets(8, 2, 2, 2);
        gc.weightx = 1.0;
        gc.gridwidth = 1;
        gc.gridheight = 2;
        this.typeChartPanel = new ChartPanel(null);
        this.typeChartPanel.setPreferredSize(new Dimension(80, 60));
        mainPanel.add((Component)this.typeChartPanel, gc);
        gc.fill = 1;
        gc.insets = new Insets(12, 2, 2, 2);
        gc.weightx = 0.0;
        gc.gridheight = 1;
        this.swNumberLabel = this.createNumberLabel();
        mainPanel.add((Component)this.swNumberLabel, gc);
        gc.gridwidth = 0;
        this.swNameLabel = this.createNameLabel(STLConstants.K0048_SWITCHES.getValue());
        mainPanel.add((Component)this.swNameLabel, gc);
        gc.insets = new Insets(2, 2, 6, 2);
        gc.gridwidth = 1;
        this.fiNumberLabel = this.createNumberLabel();
        mainPanel.add((Component)this.fiNumberLabel, gc);
        gc.gridwidth = 0;
        this.fiNameLabel = this.createNameLabel(STLConstants.K0052_HOSTS.getValue());
        mainPanel.add((Component)this.fiNameLabel, gc);
        this.add((Component)mainPanel, "Center");
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        bottomPanel.setOpaque(false);
        bottomPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIConstants.INTEL_BORDER_GRAY));
        gc = new GridBagConstraints();
        gc.insets = new Insets(0, 5, 1, 5);
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.gridheight = 2;
        this.otherPortsLabel = ComponentFactory.getH1Label(STLConstants.K0039_NOT_AVAILABLE.getValue(), 0);
        this.otherPortsLabel.setForeground(UIConstants.INTEL_GRAY);
        this.otherPortsLabel.setHorizontalAlignment(4);
        bottomPanel.add((Component)this.otherPortsLabel, gc);
        gc.gridwidth = 0;
        gc.gridheight = 1;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        JLabel label = ComponentFactory.getH4Label(STLConstants.K1026_PORT_RESOURCE.getValue(), 0);
        label.setHorizontalAlignment(2);
        label.setVerticalAlignment(3);
        bottomPanel.add((Component)label, gc);
        gc.weighty = 0.0;
        label = ComponentFactory.getH4Label(STLConstants.K2077_NOT_IN_FABRIC.getValue(), 0);
        label.setHorizontalAlignment(2);
        label.setVerticalAlignment(3);
        bottomPanel.add((Component)label, gc);
        this.add((Component)bottomPanel, "South");
    }

    private JLabel createNumberLabel() {
        JLabel label = ComponentFactory.getH4Label(STLConstants.K0039_NOT_AVAILABLE.getValue(), 0);
        label.setHorizontalAlignment(4);
        label.setVerticalAlignment(3);
        return label;
    }

    private JLabel createNameLabel(String name) {
        JLabel label = ComponentFactory.getH5Label(name, 0);
        label.setVerticalAlignment(3);
        return label;
    }

    @Override
    public void setName(String name) {
        this.nameLabel.setText(name);
    }

    public void setTotalNumber(String value) {
        this.numberLabel.setText(value);
    }

    public void setSwitches(String number, String label) {
        this.swNumberLabel.setText(number);
        this.swNameLabel.setText(label);
    }

    public void setFabricInterfaes(String number, String label) {
        this.fiNumberLabel.setText(number);
        this.fiNameLabel.setText(label);
    }

    public void setTypeDataset(DefaultPieDataset dataset, Color[] colors) {
        JFreeChart chart = ComponentFactory.createPlainPieChart((PieDataset)dataset, colors);
        this.typeChartPanel.setChart(chart);
    }

    public void setOtherPorts(String value) {
        this.otherPortsLabel.setText(value);
    }

    public void clear() {
        String na = STLConstants.K0039_NOT_AVAILABLE.getValue();
        this.setTotalNumber(na);
        this.swNumberLabel.setText(na);
        this.fiNumberLabel.setText(na);
        this.setOtherPorts(na);
    }
}

