/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.view;

import com.intel.stl.ui.common.IPerfSubpageController;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.view.IntelTabbedPaneUI;
import com.intel.stl.ui.main.view.IPageListener;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.view.IPerformanceView;
import com.intel.stl.ui.monitor.view.TreeView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PerformanceTreeView
extends TreeView
implements IPerformanceView,
ChangeListener {
    private static final long serialVersionUID = -4312903533516795863L;
    private JTabbedPane tabbedPane;
    private IntelTabbedPaneUI tabUI;
    private JPanel ctrPanel;
    private final JLabel lblNodeName = new JLabel("");
    private IPageListener listener;
    private String currentTab = null;

    public PerformanceTreeView() {
        super(null, null);
    }

    @Override
    protected JTree createTree() {
        JTree tree = new JTree();
        tree.getSelectionModel().setSelectionMode(1);
        return super.createTree();
    }

    @Override
    protected JComponent getMainComponent() {
        if (this.tabbedPane != null) {
            return this.tabbedPane;
        }
        this.tabbedPane = new JTabbedPane();
        this.tabUI = new IntelTabbedPaneUI();
        this.ctrPanel = this.tabUI.getControlPanel();
        this.ctrPanel.setLayout(new BorderLayout());
        this.ctrPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 5));
        this.tabbedPane.setUI(this.tabUI);
        this.tabUI.setFont(UIConstants.H4_FONT);
        this.tabUI.setTabAreaInsets(new Insets(2, 5, 4, 5));
        return this.tabbedPane;
    }

    @Override
    public JComponent getView() {
        return this;
    }

    @Override
    public void setNodeName(FVResourceNode node) {
        String name = new String(node.isPort() ? node.getParent().getName() + ":" + node.getName() : node.getName());
        this.lblNodeName.setText(name);
        this.lblNodeName.setForeground(UIConstants.INTEL_DARK_GRAY);
        this.lblNodeName.setFont(UIConstants.H5_FONT.deriveFont(1));
        this.ctrPanel.add((Component)this.lblNodeName, "Center");
    }

    @Override
    public void setTabs(List<IPerfSubpageController> subpages, int selection) {
        this.tabbedPane.removeChangeListener(this);
        this.tabbedPane.removeAll();
        for (IPerfSubpageController subpage : subpages) {
            this.tabbedPane.addTab(subpage.getName(), subpage.getIcon(), subpage.getView(), subpage.getDescription());
        }
        this.tabbedPane.setSelectedIndex(selection > 0 ? selection : 0);
        int index = this.tabbedPane.getSelectedIndex();
        this.currentTab = this.tabbedPane.getTitleAt(index);
        this.tabbedPane.addChangeListener(this);
    }

    public String getCurrentSubpage() {
        int currentTab = this.tabbedPane.getSelectedIndex();
        if (currentTab < 0) {
            return null;
        }
        return this.tabbedPane.getTitleAt(currentTab);
    }

    public void setCurrentSubpage(String name) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (!this.tabbedPane.getTitleAt(i).equals(name)) continue;
            this.tabbedPane.setSelectedIndex(i);
            break;
        }
    }

    public void clearPage(TreeNodeType nodeType) {
        String msg = new String("");
        this.tabbedPane.removeChangeListener(this);
        this.tabbedPane.removeAll();
        this.tabbedPane.addChangeListener(this);
        switch (nodeType) {
            case INACTIVE_PORT: {
                msg = UILabels.STL40004_ERROR_INACTIVE_PORT.getDescription();
                break;
            }
            case ALL: 
            case HCA_GROUP: 
            case SWITCH_GROUP: 
            case ROUTER_GROUP: 
            case DEVICE_GROUP: 
            case VIRTUAL_FABRIC: {
                msg = UILabels.STL40005_TREE_INFO_MSG.getDescription();
                break;
            }
        }
        this.lblNodeName.setText(msg);
        this.lblNodeName.setForeground(UIConstants.INTEL_BLUE);
        this.lblNodeName.setFont(UIConstants.H2_FONT.deriveFont(0));
        this.getMainPanel().revalidate();
    }

    public void setPageListener(IPageListener listener) {
        this.listener = listener;
        this.tabbedPane.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.listener == null) {
            return;
        }
        String oldTab = this.currentTab;
        int index = this.tabbedPane.getSelectedIndex();
        this.currentTab = this.tabbedPane.getTitleAt(index);
        if (oldTab != null && this.currentTab != null) {
            this.listener.onPageChanged(oldTab, this.currentTab);
        }
    }

    public void setRunning(boolean isRunning) {
        if (this.lblNodeName != null) {
            this.lblNodeName.setIcon(isRunning ? UIImages.RUNNING.getImageIcon() : null);
        }
    }
}

