/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.view;

import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.view.FVHeaderRenderer;
import com.intel.stl.ui.common.view.FVTableRenderer;
import com.intel.stl.ui.common.view.FVXTableView;
import com.intel.stl.ui.common.view.JumpPopupUtil;
import com.intel.stl.ui.event.JumpDestination;
import com.intel.stl.ui.model.LinkQualityViz;
import com.intel.stl.ui.model.PerformanceTableColumns;
import com.intel.stl.ui.model.PerformanceTableModel;
import com.intel.stl.ui.monitor.IPortSelectionListener;
import com.intel.stl.ui.monitor.PerformanceTableData;
import com.intel.stl.ui.monitor.TableDataDescription;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.table.TableColumnExt;

public class PerformanceXTableView
extends FVXTableView<PerformanceTableModel> {
    private static final long serialVersionUID = 3269064546124145702L;
    protected IPortSelectionListener listener;

    public PerformanceXTableView(PerformanceTableModel model) {
        super(model);
        this.installPopupMenu();
        this.installListeners();
    }

    @Override
    public void formatTable() {
        PerformanceTableColumns[] toHide;
        FVTableRenderer tableRenderer = new FVTableRenderer();
        FVHeaderRenderer headerRenderer = new FVHeaderRenderer(this.mTable);
        this.mHeader = this.createTableHeader(this.mTable.getColumnModel());
        this.mTable.setTableHeader((JTableHeader)this.mHeader);
        this.mHeader.setFont(UIConstants.H3_FONT);
        Comparator<Number> numberComparator = new Comparator<Number>(){

            @Override
            public int compare(Number o1, Number o2) {
                return Double.compare(o1.doubleValue(), o2.doubleValue());
            }
        };
        Comparator<TableDataDescription> tableDataComparator = new Comparator<TableDataDescription>(){

            @Override
            public int compare(TableDataDescription o1, TableDataDescription o2) {
                return Double.compare(o1.getData(), o2.getData());
            }
        };
        for (int i = 0; i < this.mTable.getColumnCount(); ++i) {
            this.mTable.getColumnModel().getColumn(i).setHeaderRenderer(headerRenderer);
            TableColumnExt col = this.mTable.getColumnExt(i);
            if (PerformanceTableColumns.values()[i] == PerformanceTableColumns.RX_DATA || PerformanceTableColumns.values()[i] == PerformanceTableColumns.RX_DATA_RATE || PerformanceTableColumns.values()[i] == PerformanceTableColumns.TX_DATA || PerformanceTableColumns.values()[i] == PerformanceTableColumns.TX_DATA_RATE) {
                col.setComparator((Comparator)tableDataComparator);
                col.setCellRenderer((TableCellRenderer)new FVTableRenderer(){
                    private static final long serialVersionUID = -3747347169291822762L;

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        JLabel renderer = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        TableDataDescription data = (TableDataDescription)value;
                        if (data != null) {
                            renderer.setText(data.getFormattedData());
                            renderer.setToolTipText(data.getDescription());
                        }
                        this.setHorizontalAlignment(2);
                        return this;
                    }
                });
                continue;
            }
            if (PerformanceTableColumns.values()[i] != PerformanceTableColumns.LINK_QUALITY) {
                col.setComparator((Comparator)numberComparator);
                col.setCellRenderer((TableCellRenderer)tableRenderer);
                continue;
            }
            col.setComparator((Comparator)numberComparator);
            col.setCellRenderer((TableCellRenderer)new FVTableRenderer(){
                private static final long serialVersionUID = -3747347169291822762L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    renderer.setForeground(renderer.getBackground());
                    this.setIcon(LinkQualityViz.getLinkQualityIcon(((Integer)value).byteValue()));
                    this.setHorizontalAlignment(0);
                    this.setToolTipText(LinkQualityViz.getLinkQualityDescription(((Integer)value).byteValue()));
                    return this;
                }
            });
        }
        for (PerformanceTableColumns col : toHide = new PerformanceTableColumns[]{PerformanceTableColumns.EXCESSIVE_BUFFER_OVERRUNS, PerformanceTableColumns.FM_CONFIG_ERRORS, PerformanceTableColumns.RX_PACKETS, PerformanceTableColumns.RX_DATA, PerformanceTableColumns.RX_REMOTE_PHY_ERRORS, PerformanceTableColumns.RX_SWITCH_ERRORS, PerformanceTableColumns.TX_DISCARDS, PerformanceTableColumns.TX_PACKETS, PerformanceTableColumns.TX_DATA, PerformanceTableColumns.RX_MC_PACKETS, PerformanceTableColumns.RX_ERRORS, PerformanceTableColumns.RX_CONSTRAINT, PerformanceTableColumns.RX_FECN, PerformanceTableColumns.RX_BECN, PerformanceTableColumns.RX_BUBBLE, PerformanceTableColumns.TX_MC_PACKETS, PerformanceTableColumns.TX_CONSTRAINT, PerformanceTableColumns.TX_WAIT, PerformanceTableColumns.TX_TIME_CONG, PerformanceTableColumns.TX_WASTED_BW, PerformanceTableColumns.TX_WAIT_DATA, PerformanceTableColumns.LOCAL_LINK_INTEGRITY, PerformanceTableColumns.MARK_FECN, PerformanceTableColumns.LINK_ERROR_RECOVERIES, PerformanceTableColumns.LINK_DOWNED, PerformanceTableColumns.NUM_LANES_DOWN, PerformanceTableColumns.UNCORRECTABLE_ERRORS, PerformanceTableColumns.SW_PORT_CONGESTION}) {
            this.mTable.getColumnExt((Object)col.getTitle()).setVisible(false);
        }
        this.mTable.packTable(2);
    }

    protected JXTableHeader createTableHeader(TableColumnModel columnModel) {
        JXTableHeader header = new JXTableHeader(columnModel){
            private static final long serialVersionUID = 1552295147223847158L;

            public String getToolTipText(MouseEvent e) {
                Point point = e.getPoint();
                int column = this.columnModel.getColumnIndexAtX(point.x);
                int modelIndex = this.table.convertColumnIndexToModel(column);
                return PerformanceTableColumns.values()[modelIndex].getToolTip();
            }
        };
        return header;
    }

    @Override
    protected JXTable createTable(PerformanceTableModel model) {
        JXTable table = new JXTable((TableModel)model);
        table.setColumnControlVisible(true);
        table.setHorizontalScrollEnabled(true);
        table.setAutoscrolls(true);
        table.setFillsViewportHeight(true);
        table.setPreferredScrollableViewportSize(this.getMaximumSize());
        table.setAutoCreateColumnsFromModel(true);
        table.setAlignmentX(0.0f);
        table.setBackground(UIConstants.INTEL_WHITE);
        table.setVisibleRowCount(15);
        table.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.INTEL_WHITE, (Color)UIConstants.INTEL_TABLE_ROW_GRAY)});
        table.getTableHeader().setReorderingAllowed(false);
        return table;
    }

    protected void installPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JumpPopupUtil.appendPopupMenu(popupMenu, false, new JumpPopupUtil.IActionCreator(){

            @Override
            public Action createAction(final JumpDestination destination) {
                return new AbstractAction(destination.getName()){
                    private static final long serialVersionUID = -2783822215801105313L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (PerformanceXTableView.this.listener == null) {
                            return;
                        }
                        int vRow = PerformanceXTableView.this.mTable.getSelectedRow();
                        if (vRow >= 0) {
                            int mRow = PerformanceXTableView.this.mTable.convertRowIndexToModel(vRow);
                            PerformanceTableData perfData = (PerformanceTableData)((PerformanceTableModel)PerformanceXTableView.this.model).getEntry(mRow);
                            PerformanceXTableView.this.listener.onJumpToPort(perfData.getNodeLid(), perfData.getPortNumber(), destination.getName());
                        }
                    }
                };
            }
        });
        this.mTable.setComponentPopupMenu(popupMenu);
    }

    protected void installListeners() {
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PerformanceXTableView.this.listener == null || e.getValueIsAdjusting()) {
                    return;
                }
                int vRow = PerformanceXTableView.this.mTable.getSelectedRow();
                if (vRow >= 0) {
                    int mRow = PerformanceXTableView.this.mTable.convertRowIndexToModel(vRow);
                    PerformanceXTableView.this.listener.onPortSelection(mRow);
                }
            }
        };
        this.mTable.getSelectionModel().addListSelectionListener(selectionListener);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PerformanceXTableView.this.listener == null) {
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
                    Point p = e.getPoint();
                    int vRow = PerformanceXTableView.this.mTable.rowAtPoint(p);
                    if (vRow >= 0) {
                        int mRow = PerformanceXTableView.this.mTable.convertRowIndexToModel(vRow);
                        PerformanceTableData perfData = (PerformanceTableData)((PerformanceTableModel)PerformanceXTableView.this.model).getEntry(mRow);
                        PerformanceXTableView.this.listener.onJumpToPort(perfData.getNodeLid(), perfData.getPortNumber(), JumpDestination.PERFORMANCE.getName());
                    }
                }
            }
        };
        this.mTable.addMouseListener((MouseListener)mouseListener);
    }

    public void setPortSelectionListener(IPortSelectionListener listener) {
        this.listener = listener;
    }

    public void setSelectedPort(int portIndex) {
        int vId = this.mTable.convertRowIndexToView(portIndex);
        this.mTable.setRowSelectionInterval(vId, vId);
        this.mTable.scrollRowToVisible(vId);
    }
}

