/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.model.GraphEdge;
import com.intel.stl.ui.model.GraphNode;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.network.ResourceAllSection;
import com.intel.stl.ui.network.ResourceLinkSection;
import com.intel.stl.ui.network.ResourceNodeSection;
import com.intel.stl.ui.network.ResourceScopeType;
import com.intel.stl.ui.network.ResourceSection;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopologyTreeModel;
import com.intel.stl.ui.network.view.ResourceAllView;
import com.intel.stl.ui.network.view.ResourceLinkSubpageView;
import com.intel.stl.ui.network.view.ResourceSubpageView;
import com.intel.stl.ui.network.view.ResourceView;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import net.engio.mbassy.bus.MBassador;

public class ResourceController {
    private final ResourceView view;
    private ResourceAllSection allCard;
    private ResourceNodeSection nodeSubpageCard;
    private ResourceLinkSection linkSubpageCard;
    private ResourceLinkSection pathSubpageCard;
    private Map<ResourceScopeType, ResourceSection<?>> cards = new HashMap();
    private ResourceScopeType currentResourceType;
    private final MBassador<IAppEvent> eventBus;

    public ResourceController(ResourceView view, MBassador<IAppEvent> eventBus) {
        this.eventBus = eventBus;
        this.cards = this.getCards();
        this.view = view;
        this.view.initializeViews(this.cards);
    }

    protected Map<ResourceScopeType, ResourceSection<?>> getCards() {
        this.allCard = new ResourceAllSection(new ResourceAllView(STLConstants.K1033_TOP_OVERVIEW.getValue()), this.eventBus);
        this.cards.put(ResourceScopeType.ALL, this.allCard);
        this.nodeSubpageCard = new ResourceNodeSection(new ResourceSubpageView(STLConstants.K1021_RESOURCE_DETAILS.getValue()), this.eventBus);
        this.cards.put(ResourceScopeType.NODE, this.nodeSubpageCard);
        this.linkSubpageCard = new ResourceLinkSection(new ResourceLinkSubpageView(STLConstants.K0013_LINKS.getValue(), UIImages.LINKS.getImageIcon()), this.eventBus);
        this.cards.put(ResourceScopeType.LINK, this.linkSubpageCard);
        this.pathSubpageCard = new ResourceLinkSection(new ResourceLinkSubpageView(STLConstants.K1028_ROUTE_RESOURCE.getValue(), UIImages.ROUTE.getImageIcon()), this.eventBus);
        this.cards.put(ResourceScopeType.PATH, this.pathSubpageCard);
        return this.cards;
    }

    public void setContext(Context context, IProgressObserver observer) {
        IProgressObserver[] subObservers = observer.createSubObservers(this.cards.size());
        int i = 0;
        for (ResourceSection<?> card : this.cards.values()) {
            card.setContext(context, subObservers[i]);
            subObservers[i++].onFinish();
        }
    }

    public void showAll(final FVResourceNode[] selectedResources, final String name, final Icon icon, final TopologyTreeModel topArch, final TopGraph graph) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                ResourceController.this.currentResourceType = ResourceScopeType.ALL;
                ResourceController.this.pathSubpageCard.clearSubpages();
                ResourceController.this.linkSubpageCard.clearSubpages();
                ResourceController.this.view.showLayout(ResourceController.this.currentResourceType);
                ResourceAllSection resourceAllSelection = (ResourceAllSection)ResourceController.this.cards.get((Object)ResourceController.this.currentResourceType);
                if (resourceAllSelection != null) {
                    resourceAllSelection.showAll(selectedResources, name, icon, topArch, graph, graph);
                }
            }
        });
    }

    public void showGroup(final FVResourceNode[] selectedResources, final String name, final Icon icon, final TopologyTreeModel topArch, final TopGraph graph, final TopGraph fullGraph) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                ResourceController.this.currentResourceType = ResourceScopeType.ALL;
                ResourceController.this.pathSubpageCard.clearSubpages();
                ResourceController.this.linkSubpageCard.clearSubpages();
                ResourceController.this.view.showLayout(ResourceController.this.currentResourceType);
                ResourceAllSection resourceAllSelection = (ResourceAllSection)ResourceController.this.cards.get((Object)ResourceController.this.currentResourceType);
                if (resourceAllSelection != null) {
                    resourceAllSelection.showAll(selectedResources, name, icon, topArch, graph, fullGraph);
                }
            }
        });
    }

    public void showNode(final FVResourceNode source, final GraphNode node) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                ResourceController.this.currentResourceType = ResourceScopeType.NODE;
                ResourceController.this.pathSubpageCard.clearSubpages();
                ResourceController.this.linkSubpageCard.clearSubpages();
                ResourceController.this.view.showLayout(ResourceController.this.currentResourceType);
                ResourceNodeSection resourceNodeSection = (ResourceNodeSection)ResourceController.this.cards.get((Object)ResourceController.this.currentResourceType);
                if (resourceNodeSection != null) {
                    resourceNodeSection.showNode(source, node);
                }
            }
        });
    }

    public void showLinks(final List<GraphEdge> links, final String vfName) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                ResourceController.this.currentResourceType = ResourceScopeType.LINK;
                ResourceController.this.pathSubpageCard.clearSubpages();
                ResourceController.this.view.showLayout(ResourceController.this.currentResourceType);
                ResourceLinkSection resourceLinkSection = (ResourceLinkSection)ResourceController.this.cards.get((Object)ResourceController.this.currentResourceType);
                if (resourceLinkSection != null) {
                    resourceLinkSection.showLinks(links, vfName);
                }
            }
        });
    }

    public void showPath(final Map<GraphEdge, List<GraphEdge>> traceMap, final String vfName) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                ResourceController.this.currentResourceType = ResourceScopeType.PATH;
                ResourceController.this.linkSubpageCard.clearSubpages();
                ResourceController.this.view.showLayout(ResourceController.this.currentResourceType);
                ResourceLinkSection resourceLinkSection = (ResourceLinkSection)ResourceController.this.cards.get((Object)ResourceController.this.currentResourceType);
                if (resourceLinkSection != null) {
                    resourceLinkSection.showPath(traceMap, vfName);
                }
            }
        });
    }

    public Component getView() {
        return this.view;
    }

    public void setCurrentSubpage(String subpageName) {
        for (ResourceSection<?> rs : this.cards.values()) {
            rs.setCurrentSubpage(subpageName);
        }
    }

    public String getPreviousSubpage() {
        ResourceSection<?> rs = this.cards.get((Object)this.currentResourceType);
        if (rs != null) {
            return rs.getPreviousSubpage();
        }
        return null;
    }

    public String getCurrentSubpage() {
        ResourceSection<?> rs = this.cards.get((Object)this.currentResourceType);
        if (rs != null) {
            return rs.getCurrentSubpage();
        }
        return null;
    }
}

