/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.ICardController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UndoableJumpEvent;
import com.intel.stl.ui.common.view.ISectionListener;
import com.intel.stl.ui.event.JumpToEvent;
import com.intel.stl.ui.event.NodesSelectedEvent;
import com.intel.stl.ui.event.PortsSelectedEvent;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.main.UndoHandler;
import com.intel.stl.ui.main.view.IPageListener;
import com.intel.stl.ui.model.ConnectivityTableColumns;
import com.intel.stl.ui.model.ConnectivityTableModel;
import com.intel.stl.ui.model.GraphEdge;
import com.intel.stl.ui.model.GraphNode;
import com.intel.stl.ui.monitor.CableInfoPopupController;
import com.intel.stl.ui.monitor.IPortSelectionListener;
import com.intel.stl.ui.monitor.view.CableInfoPopupView;
import com.intel.stl.ui.monitor.view.ConnectivitySubpageView;
import com.intel.stl.ui.network.ResourceLinkPage;
import com.intel.stl.ui.network.ResourceSection;
import com.intel.stl.ui.network.TopologyPage;
import com.intel.stl.ui.network.UndoableLinkSubpageSelection;
import com.intel.stl.ui.network.view.ResourceLinkSubpageView;
import com.intel.stl.ui.network.view.ResourceLinkView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.engio.mbassy.bus.MBassador;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLinkSection
extends ResourceSection<ResourceLinkSubpageView>
implements IPortSelectionListener,
IPageListener {
    private static final Logger log = LoggerFactory.getLogger(ResourceLinkSection.class);
    private final Map<GraphEdge, ResourceLinkPage> subpages = new LinkedHashMap<GraphEdge, ResourceLinkPage>();
    private Context context;
    private IProgressObserver observer;
    private List<GraphEdge> currentLinks;
    private Map<GraphEdge, List<GraphEdge>> currentTraces;
    private String previousSubpageName;
    private String currentSubpageName;
    private UndoHandler undoHandler;
    private final String origin = TopologyPage.NAME;

    public ResourceLinkSection(ResourceLinkSubpageView view, MBassador<IAppEvent> eventBus) {
        super(view, eventBus);
        this.view = view;
        view.setPageListener(this);
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        this.context = context;
        if (context != null && context.getController() != null) {
            this.undoHandler = context.getController().getUndoHandler();
        }
        observer.onFinish();
    }

    @Override
    public void setCurrentSubpage(String subpageName) {
        this.previousSubpageName = this.currentSubpageName;
        this.currentSubpageName = subpageName;
    }

    @Override
    public String getPreviousSubpage() {
        return this.previousSubpageName;
    }

    @Override
    public String getCurrentSubpage() {
        return this.currentSubpageName;
    }

    protected void showLinks(List<GraphEdge> links, String vfName) {
        if (links != null) {
            links = this.toPortLinks(links);
        }
        if (links != null && links.equals(this.currentLinks)) {
            for (GraphEdge link : links) {
                ResourceLinkPage page = this.subpages.get(link);
                if (page != null) {
                    page.showLink(link, vfName);
                    continue;
                }
                log.warn("Cannot find page for " + link);
            }
            return;
        }
        ((ResourceLinkSubpageView)this.view).setTitle(STLConstants.K0013_LINKS.getValue());
        this.clearSubpages();
        if (links == null || links.isEmpty()) {
            ((ResourceLinkSubpageView)this.view).clear();
            ((ResourceLinkSubpageView)this.view).setTitle(STLConstants.K0013_LINKS.getValue() + " (" + STLConstants.K0039_NOT_AVAILABLE.getValue() + ")");
            this.currentLinks = null;
            this.currentTraces = null;
            return;
        }
        for (GraphEdge link : links) {
            ConnectivityTableModel linkTableModel = new ConnectivityTableModel();
            ConnectivitySubpageView linkTableView = this.createLinkView(linkTableModel);
            CableInfoPopupView cableInfoPopupView = new CableInfoPopupView(linkTableView);
            linkTableView.setCableInfoPopupView(cableInfoPopupView);
            CableInfoPopupController cableInfoPopupController = new CableInfoPopupController(cableInfoPopupView);
            cableInfoPopupController.setContext(this.context, null);
            cableInfoPopupView.setCableInfoListener(cableInfoPopupController);
            linkTableView.setPortSelectionListener(this);
            ResourceLinkView linkView = new ResourceLinkView();
            ResourceLinkPage linkPage = new ResourceLinkPage(linkTableModel, linkTableView, linkView);
            linkPage.setContext(this.context, null);
            linkPage.showLink(link, vfName);
            this.subpages.put(link, linkPage);
        }
        this.previousSubpageName = this.currentSubpageName;
        ((ResourceLinkSubpageView)this.view).setTabs(this.subpages.values().toArray(new ResourceLinkPage[0]), this.currentSubpageName);
        this.currentSubpageName = ((ResourceLinkSubpageView)this.view).getCurrentSubpage();
        this.currentLinks = links;
        this.currentTraces = null;
        this.setHelpID(HelpAction.getInstance().getLinks());
    }

    protected List<GraphEdge> toPortLinks(List<GraphEdge> edges) {
        ArrayList<GraphEdge> res = new ArrayList<GraphEdge>();
        for (GraphEdge edge : edges) {
            Map<Integer, Integer> links = edge.getLinks();
            if (links.size() == 1) {
                res.add(edge);
                continue;
            }
            if (links.size() <= 1) continue;
            for (Map.Entry<Integer, Integer> link : links.entrySet()) {
                res.add(new GraphEdge(edge.getFromLid(), edge.getFromType(), edge.getToLid(), edge.getToType(), Collections.singletonMap(link.getKey(), link.getValue())));
            }
        }
        return res;
    }

    protected void showPath(Map<GraphEdge, List<GraphEdge>> traceMap, String vfName) {
        if (traceMap != null && traceMap.equals(this.currentTraces)) {
            for (GraphEdge link : traceMap.keySet()) {
                this.subpages.get(link).showPath(link, traceMap.get(link), vfName);
            }
            return;
        }
        ((ResourceLinkSubpageView)this.view).setTitle(STLConstants.K1028_ROUTE_RESOURCE.getValue());
        this.clearSubpages();
        if (traceMap == null || traceMap.isEmpty()) {
            this.currentTraces = traceMap;
            this.currentLinks = null;
            return;
        }
        for (Map.Entry<GraphEdge, List<GraphEdge>> entry : traceMap.entrySet()) {
            ConnectivityTableModel pathTableModel = new ConnectivityTableModel();
            ConnectivitySubpageView pathTableView = this.createPathView(pathTableModel);
            CableInfoPopupView cableInfoPopupView = new CableInfoPopupView(pathTableView);
            pathTableView.setCableInfoPopupView(cableInfoPopupView);
            CableInfoPopupController cableInfoPopupController = new CableInfoPopupController(cableInfoPopupView);
            cableInfoPopupController.setContext(this.context, null);
            cableInfoPopupView.setCableInfoListener(cableInfoPopupController);
            pathTableView.setPortSelectionListener(this);
            ResourceLinkView pathView = new ResourceLinkView();
            ResourceLinkPage pathPage = new ResourceLinkPage(pathTableModel, pathTableView, pathView);
            pathPage.setContext(this.context, null);
            pathPage.showPath(entry.getKey(), entry.getValue(), vfName);
            this.subpages.put(entry.getKey(), pathPage);
        }
        this.previousSubpageName = this.currentSubpageName;
        ((ResourceLinkSubpageView)this.view).setTabs(this.subpages.values().toArray(new ResourceLinkPage[0]), this.currentSubpageName);
        this.currentSubpageName = ((ResourceLinkSubpageView)this.view).getCurrentSubpage();
        this.currentTraces = traceMap;
        this.currentLinks = null;
        this.setHelpID(HelpAction.getInstance().getRoutes());
    }

    protected GraphNode findNode(int lid, GraphNode node) {
        boolean found = false;
        GraphNode targetNode = null;
        Iterator<GraphNode> it = node.getMiddleNeighbor().iterator();
        while (!found && it.hasNext()) {
            GraphNode neighbor = it.next();
            if (neighbor.getLid() != lid) continue;
            found = true;
            targetNode = neighbor;
        }
        return targetNode;
    }

    @Override
    public ISectionListener getSectionListener() {
        return this;
    }

    @Override
    public boolean canPageChange(String oldPage, String newPage) {
        return true;
    }

    @Override
    public synchronized void onPageChanged(String oldPageId, String newPageId) {
        if (this.undoHandler != null && !this.undoHandler.isInProgress()) {
            UndoableLinkSubpageSelection undoSel = new UndoableLinkSubpageSelection((ResourceLinkSubpageView)this.view, oldPageId, newPageId);
            this.undoHandler.addUndoAction(undoSel);
        }
        this.previousSubpageName = oldPageId;
        this.currentSubpageName = newPageId;
    }

    protected ConnectivitySubpageView createLinkView(ConnectivityTableModel linkTableModel) {
        ConnectivitySubpageView linkTableView = new ConnectivitySubpageView(linkTableModel){
            private static final long serialVersionUID = 5930204470646720711L;

            @Override
            protected void filterColumns() {
                ConnectivityTableColumns[] toShow = new ConnectivityTableColumns[]{ConnectivityTableColumns.NODE_NAME, ConnectivityTableColumns.PORT_NUMBER, ConnectivityTableColumns.CABLE_INFO, ConnectivityTableColumns.LINK_STATE, ConnectivityTableColumns.PHYSICAL_LINK_STATE, ConnectivityTableColumns.LINK_QUALITY, ConnectivityTableColumns.ACTIVE_LINK_WIDTH, ConnectivityTableColumns.ACTIVE_LINK_WIDTH_DG_TX, ConnectivityTableColumns.ACTIVE_LINK_WIDTH_DG_RX, ConnectivityTableColumns.ACTIVE_LINK_SPEED, ConnectivityTableColumns.RX_DATA, ConnectivityTableColumns.TX_DATA, ConnectivityTableColumns.LINK_DOWNED};
                ConnectivityTableColumns[] all = ConnectivityTableColumns.values();
                boolean[] vis = new boolean[all.length];
                for (ConnectivityTableColumns col : toShow) {
                    vis[col.getId()] = true;
                }
                for (int i = 0; i < vis.length; ++i) {
                    this.mTable.getColumnExt((Object)all[i].getTitle()).setVisible(vis[i]);
                }
            }
        };
        return linkTableView;
    }

    protected ConnectivitySubpageView createPathView(ConnectivityTableModel pathTableModel) {
        ConnectivitySubpageView pathTableView = new ConnectivitySubpageView(pathTableModel){
            private static final long serialVersionUID = 5930204470646720711L;

            @Override
            protected void filterColumns() {
                ConnectivityTableColumns[] toHide;
                for (ConnectivityTableColumns col : toHide = new ConnectivityTableColumns[]{ConnectivityTableColumns.LINK_ERROR_RECOVERIES, ConnectivityTableColumns.LINK_DOWNED, ConnectivityTableColumns.NUM_LANES_DOWN, ConnectivityTableColumns.NODE_GUID, ConnectivityTableColumns.PHYSICAL_LINK_STATE, ConnectivityTableColumns.ACTIVE_LINK_WIDTH, ConnectivityTableColumns.ENABLED_LINK_WIDTH, ConnectivityTableColumns.SUPPORTED_LINK_WIDTH, ConnectivityTableColumns.ENABLED_LINK_SPEED, ConnectivityTableColumns.TX_PACKETS, ConnectivityTableColumns.RX_PACKETS, ConnectivityTableColumns.RX_ERRORS, ConnectivityTableColumns.RX_REMOTE_PHYSICAL_ERRRORS, ConnectivityTableColumns.TX_DISCARDS, ConnectivityTableColumns.RX_SWITCH_RELAY_ERRRORS, ConnectivityTableColumns.TX_CONSTRAINT, ConnectivityTableColumns.RX_CONSTRAINT, ConnectivityTableColumns.LOCAL_LINK_INTEGRITY, ConnectivityTableColumns.EXCESSIVE_BUFFER_OVERRUNS, ConnectivityTableColumns.RX_MC_PACKETS, ConnectivityTableColumns.RX_ERRORS, ConnectivityTableColumns.RX_CONSTRAINT, ConnectivityTableColumns.RX_FECN, ConnectivityTableColumns.RX_BECN, ConnectivityTableColumns.RX_BUBBLE, ConnectivityTableColumns.TX_MC_PACKETS, ConnectivityTableColumns.TX_WAIT, ConnectivityTableColumns.TX_TIME_CONG, ConnectivityTableColumns.TX_WASTED_BW, ConnectivityTableColumns.TX_WAIT_DATA, ConnectivityTableColumns.LOCAL_LINK_INTEGRITY, ConnectivityTableColumns.MARK_FECN, ConnectivityTableColumns.LINK_ERROR_RECOVERIES, ConnectivityTableColumns.UNCORRECTABLE_ERRORS, ConnectivityTableColumns.SW_PORT_CONGESTION}) {
                    this.mTable.getColumnExt((Object)col.getTitle()).setVisible(false);
                }
            }
        };
        return pathTableView;
    }

    public void clearSubpages() {
        for (ResourceLinkPage subpage : this.subpages.values()) {
            subpage.clear();
            subpage.cleanup();
        }
        this.subpages.clear();
        this.currentLinks = null;
        this.currentTraces = null;
    }

    @Override
    public void onPortSelection(int rowIndex) {
    }

    @Override
    public void onJumpToPort(int lid, short portNum, String destination) {
        if (this.eventBus != null) {
            PortsSelectedEvent pse = new PortsSelectedEvent(lid, portNum, this, destination);
            if (this.undoHandler != null && !this.undoHandler.isInProgress()) {
                UndoableJumpEvent undoSel = new UndoableJumpEvent((MBassador<IAppEvent>)this.eventBus, this.getOldSelectionEvent(), pse);
                this.undoHandler.addUndoAction(undoSel);
            }
            this.eventBus.publish((Object)pse);
        }
    }

    protected JumpToEvent getOldSelectionEvent() {
        if (this.currentLinks != null) {
            PortsSelectedEvent event = new PortsSelectedEvent(this, this.origin);
            for (GraphEdge link : this.currentLinks) {
                event.addPort(link.getFromLid(), link.getLinks().keySet().iterator().next().shortValue());
            }
            return event;
        }
        if (this.currentTraces != null) {
            NodesSelectedEvent event = new NodesSelectedEvent(this, this.origin);
            HashMap<Integer, Byte> nodes = new HashMap<Integer, Byte>();
            for (GraphEdge graphEdge : this.currentTraces.keySet()) {
                if (!nodes.containsKey(graphEdge.getFromLid())) {
                    nodes.put(graphEdge.getFromLid(), graphEdge.getFromType());
                }
                if (nodes.containsKey(graphEdge.getToLid())) continue;
                nodes.put(graphEdge.getToLid(), graphEdge.getToType());
            }
            for (Map.Entry entry : nodes.entrySet()) {
                event.addNode((Integer)entry.getKey(), NodeType.getNodeType((Byte)entry.getValue()));
            }
            return event;
        }
        throw new RuntimeException("Couldn't create JumpToEvent because no links or traces");
    }

    @Override
    public ICardController<?>[] getCards() {
        return null;
    }
}

