/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.ui.common.IBackgroundService;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.network.MarkedEdgeHandler;
import com.intel.stl.ui.network.SelectionCellsHandler;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopMarkedEdgesHandler;
import com.intel.stl.ui.network.VertexHandler;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.handler.mxCellHandler;
import com.mxgraph.swing.handler.mxGraphHandler;
import com.mxgraph.swing.handler.mxPanningHandler;
import com.mxgraph.swing.handler.mxSelectionCellsHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxSwingConstants;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopGraphComponent
extends mxGraphComponent {
    private static final long serialVersionUID = -3168649345200765940L;
    private static final Logger log = LoggerFactory.getLogger(TopGraphComponent.class);
    private boolean graphBuffered = true;
    private mxGraphView view;
    private mxPoint viewTranslate;
    private mxEventSource.mxIEventListener selectionListener;
    private int margin = 5;
    private Timer repaintTimer;
    private boolean userTranslated;
    private final AtomicInteger imageId = new AtomicInteger();
    private final AtomicInteger cellFindingId = new AtomicInteger();
    private final AtomicInteger transId = new AtomicInteger();
    private final IBackgroundService updateService;

    public TopGraphComponent(IBackgroundService updateService, TopGraph graph) {
        super((mxGraph)graph);
        this.updateService = updateService;
        mxSwingConstants.VERTEX_SELECTION_COLOR = UIConstants.VERTEX_SEL_COLOR;
        mxSwingConstants.VERTEX_SELECTION_STROKE = UIConstants.VERTEX_SEL_STROKE;
        mxSwingConstants.EDGE_SELECTION_COLOR = UIConstants.EDGE_SEL_COLOR;
        mxSwingConstants.EDGE_SELECTION_STROKE = UIConstants.EDGE_SEL_STROKE;
        this.setBackground(UIConstants.INTEL_WHITE);
        this.setViewportBorder(BorderFactory.createEmptyBorder(this.margin, this.margin, this.margin, this.margin));
        ((SelectionCellsHandler)this.getSelectionCellsHandler()).setUpdateService(updateService);
    }

    public boolean isGraphBuffered() {
        return this.graphBuffered;
    }

    public void setGraphBuffered(boolean graphBuffered) {
        this.graphBuffered = graphBuffered;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    protected mxGraphComponent.mxGraphControl createGraphControl() {
        return new GraphControl();
    }

    public void setSelectionListener(mxEventSource.mxIEventListener listener) {
        if (this.selectionListener != null && this.graph != null) {
            this.graph.getSelectionModel().removeListener(this.selectionListener);
        }
        this.selectionListener = listener;
        if (this.graph != null && listener != null) {
            this.graph.getSelectionModel().addListener("change", listener);
        }
    }

    protected void createHandlers() {
        super.createHandlers();
        new TopMarkedEdgesHandler(this);
    }

    protected mxPanningHandler createPanningHandler() {
        return new PanningHandler(this);
    }

    protected mxGraphHandler createGraphHandler() {
        return new GraphHandler(this);
    }

    protected mxSelectionCellsHandler createSelectionCellsHandler() {
        return new SelectionCellsHandler(this);
    }

    protected void installDoubleClickHandler() {
    }

    public boolean isPanningEvent(MouseEvent event) {
        return SwingUtilities.isLeftMouseButton(event);
    }

    public mxCellHandler createHandler(mxCellState state) {
        if (((TopGraph)this.graph).isMarked((mxCell)state.getCell())) {
            return new MarkedEdgeHandler(this, state);
        }
        if (this.graph.getModel().isVertex(state.getCell())) {
            return new VertexHandler(this, state);
        }
        return super.createHandler(state);
    }

    public Object[] selectRegion(Rectangle rect, MouseEvent e) {
        Object[] cells = this.getCells(rect);
        if (cells.length > 0) {
            this.graph.setSelectionCells(cells);
        } else if (!this.graph.isSelectionEmpty() && !e.isConsumed()) {
            this.graph.clearSelection();
        }
        return cells;
    }

    public Object getCellAt(int x, int y, boolean hitSwimlaneContent, Object parent) {
        Object res = this.getCellAt(x, y, hitSwimlaneContent, parent, true);
        if (res == null) {
            res = this.getCellAt(x, y, hitSwimlaneContent, parent, false);
        }
        return res;
    }

    public Object getCellAt(final int x, final int y, final boolean hitSwimlaneContent, final Object parent, final boolean vertex) {
        final int id = this.cellFindingId.incrementAndGet();
        Future<Object> task = this.updateService.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return TopGraphComponent.this.findCellAt(id, x, y, hitSwimlaneContent, parent, vertex);
            }
        });
        Object res = null;
        try {
            res = task.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object findCellAt(int id, int x, int y, boolean hitSwimlaneContent, Object parent, boolean vertex) {
        if (id != this.cellFindingId.get()) {
            return null;
        }
        if (parent == null) {
            parent = this.graph.getDefaultParent();
        }
        if (parent != null) {
            mxPoint previousTranslate = this.canvas.getTranslate();
            double previousScale = this.canvas.getScale();
            try {
                this.canvas.setScale(this.view.getScale());
                this.canvas.setTranslate(0.0, 0.0);
                mxIGraphModel model = this.graph.getModel();
                Rectangle hit = new Rectangle(x, y, 1, 1);
                int childCount = model.getChildCount(parent);
                for (int i = childCount - 1; i >= 0; --i) {
                    mxCellState state;
                    if (id != this.cellFindingId.get()) {
                        Object var14_13 = null;
                        return var14_13;
                    }
                    Object cell = model.getChildAt(parent, i);
                    Object result = this.findCellAt(id, x, y, hitSwimlaneContent, cell, vertex);
                    if (result != null) {
                        Object object = result;
                        return object;
                    }
                    if (!this.graph.isCellVisible(cell) || vertex != model.isVertex(cell) || (state = this.view.getState(cell)) == null || !this.canvas.intersects((mxGraphComponent)this, hit, state) || this.graph.isSwimlane(cell) && !hitSwimlaneContent && (!this.transparentSwimlaneContent || this.canvas.hitSwimlaneContent((mxGraphComponent)this, state, x, y))) continue;
                    Object object = cell;
                    return object;
                }
            }
            finally {
                this.canvas.setScale(previousScale);
                this.canvas.setTranslate(previousTranslate.getX(), previousTranslate.getY());
            }
        }
        return null;
    }

    public void setGraph(mxGraph value) {
        if (value == null) {
            return;
        }
        log.info("SetGraph " + value + " " + Thread.currentThread());
        if (value instanceof TopGraph) {
            if (this.selectionListener != null && this.graph != null) {
                this.graph.getSelectionModel().removeListener(this.selectionListener);
            }
            try {
                super.setGraph(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.view = value.getView();
            Dimension viewSize = this.getViewport().getSize();
            if (viewSize.width > 0 && viewSize.height > 0) {
                Rectangle rec = this.view.getGraphBounds().getRectangle();
                this.zoomToRectangle(rec);
            }
            if (this.selectionListener != null) {
                value.getSelectionModel().addListener("change", this.selectionListener);
            }
        } else {
            throw new IllegalArgumentException("graph " + value.getClass().getName() + " is not " + TopGraph.class.getName());
        }
    }

    public void updateGraph() {
        Dimension viewSize = this.getViewport().getSize();
        ((GraphControl)this.graphControl).updateBuffer(viewSize.width, viewSize.height);
    }

    public boolean isUserTranslated() {
        return this.userTranslated;
    }

    public void setUserTranslated(boolean userTranslated) {
        this.userTranslated = userTranslated;
    }

    public void zoomIn(Point point) {
        this.zoom(this.zoomFactor, point);
    }

    public void zoomOut(Point point) {
        this.zoom(1.0 / this.zoomFactor, point);
    }

    public void zoom(final double factor, final Point point) {
        this.updateService.submit(new Runnable(){

            @Override
            public void run() {
                double newScale = TopGraphComponent.this.view.getScale() * factor;
                if (Math.abs(newScale - TopGraphComponent.this.view.getScale()) > 1.0E-4 && newScale > 0.001) {
                    mxPoint translate = point == null ? new mxPoint() : TopGraphComponent.this.getTranslate(point, TopGraphComponent.this.view.getScale(), newScale);
                    mxPoint oldTranslate = TopGraphComponent.this.view.getTranslate();
                    TopGraphComponent.this.view.scaleAndTranslate(newScale, translate.getX() + oldTranslate.getX(), translate.getY() + oldTranslate.getY());
                    TopGraphComponent.this.restartTimer();
                }
            }
        });
    }

    protected mxPoint getTranslate(Point point, double oldScale, double newScale) {
        int x = point.x;
        int y = point.y;
        double f = (newScale - oldScale) / (oldScale * newScale);
        return new mxPoint((double)(-x) * f, (double)(-y) * f);
    }

    public void zoomToRectangle(Rectangle rect) {
        if (rect != null) {
            double newScale = 1.0;
            double gw = rect.width;
            double gh = rect.height;
            if (gw > 0.0 && gh > 0.0) {
                Dimension viewSize = this.getViewport().getSize();
                double w = viewSize.getWidth() - (double)(this.margin * 2);
                double h = viewSize.getHeight() - (double)(this.margin * 2);
                newScale = Math.min(w / gw, h / gh);
            }
            double oldScale = this.view.getScale();
            mxPoint trans = this.view.getTranslate();
            this.view.scaleAndTranslate(oldScale * newScale, (double)(-rect.x) / oldScale + trans.getX(), (double)(-rect.y) / oldScale + trans.getY());
        }
    }

    protected void restartTimer() {
        if (this.repaintTimer == null) {
            this.repaintTimer = new Timer(250, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TopGraphComponent.this.repaintTimer != null) {
                        TopGraphComponent.this.updateGraph();
                    }
                }
            });
            this.repaintTimer.setRepeats(false);
        }
        this.repaintTimer.restart();
    }

    protected void clearTimer() {
        if (this.repaintTimer != null) {
            if (this.repaintTimer.isRunning()) {
                this.repaintTimer.stop();
            }
            this.repaintTimer = null;
        }
    }

    class GraphControl
    extends mxGraphComponent.mxGraphControl {
        private static final long serialVersionUID = 2776035858098303467L;
        private final AtomicReference<GraphBuffer> graphBufferRef;

        GraphControl() {
            super((mxGraphComponent)TopGraphComponent.this);
            this.graphBufferRef = new AtomicReference<Object>(null);
        }

        public void updateBuffer(final int maxW, final int maxH) {
            final int id = TopGraphComponent.this.imageId.incrementAndGet();
            TopGraphComponent.this.updateService.submit(new Runnable(){

                @Override
                public void run() {
                    GraphBuffer graphBuffer = GraphControl.this.createGraphBuffer(id, maxW, maxH);
                    GraphControl.this.graphBufferRef.set(graphBuffer);
                    GraphControl.this.repaint();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected GraphBuffer createGraphBuffer(int id, int maxW, int maxH) {
            if (id < TopGraphComponent.this.imageId.get()) {
                return this.graphBufferRef.get();
            }
            long t = System.currentTimeMillis();
            BufferedImage img = null;
            mxPoint newTrans = TopGraphComponent.this.view.getTranslate();
            double newScale = TopGraphComponent.this.view.getScale();
            try {
                mxRectangle bounds = TopGraphComponent.this.graph.getGraphBounds();
                int width = (int)Math.ceil(bounds.getX() + bounds.getWidth() + 2.0);
                int height = (int)Math.ceil(bounds.getY() + bounds.getHeight() + 2.0);
                if (width > maxW || height > maxH) {
                    width = maxW;
                    height = maxH;
                }
                img = mxUtils.createBufferedImage((int)width, (int)height, null);
                Graphics2D g2d = img.createGraphics();
                try {
                    super.paint((Graphics)g2d);
                }
                finally {
                    g2d.dispose();
                }
            }
            catch (Throwable throwable) {
                log.info("Create GraphBuffer-" + id + " " + (img == null ? "" : img.getWidth() + "x" + img.getHeight()) + " on " + TopGraphComponent.this.graph + " in " + (System.currentTimeMillis() - t) + " ms");
                throw throwable;
            }
            log.info("Create GraphBuffer-" + id + " " + (img == null ? "" : img.getWidth() + "x" + img.getHeight()) + " on " + TopGraphComponent.this.graph + " in " + (System.currentTimeMillis() - t) + " ms");
            return new GraphBuffer(TopGraphComponent.this.view, img, newTrans, newScale);
        }

        public void paint(Graphics g) {
            GraphBuffer graphBuffer = this.graphBufferRef.get();
            if (graphBuffer != null) {
                AffineTransform transform = new AffineTransform();
                double scale = graphBuffer.graphView.getScale();
                mxPoint graphBufferTrans = graphBuffer.trans;
                double graphBufferScale = graphBuffer.scale;
                mxPoint trans = graphBuffer.graphView.getTranslate();
                double dx = trans.getX() - graphBufferTrans.getX();
                double dy = trans.getY() - graphBufferTrans.getY();
                transform.translate(dx * scale, dy * scale);
                double newScale = scale / graphBufferScale;
                transform.scale(newScale, newScale);
                ((Graphics2D)g).drawImage(graphBuffer.image, transform, (ImageObserver)((Object)this));
            }
        }

        public void updatePreferredSize() {
        }

        private class GraphBuffer {
            mxGraphView graphView;
            BufferedImage image;
            mxPoint trans;
            double scale;

            public GraphBuffer(mxGraphView graphView, BufferedImage image, mxPoint trans, double scale) {
                this.graphView = graphView;
                this.image = image;
                this.trans = trans;
                this.scale = scale;
            }
        }
    }

    class GraphHandler
    extends mxGraphHandler {
        private boolean hasHighlight;

        public GraphHandler(mxGraphComponent graphComponent) {
            super(graphComponent);
            this.cloneEnabled = false;
        }

        public void mousePressed(MouseEvent e) {
            if (this.isDragTrigger(e)) {
                super.mousePressed(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            Object cell;
            if (this.first != null) {
                super.mouseReleased(e);
            } else if (!e.isConsumed() && !SwingUtilities.isRightMouseButton(e) && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1 && (cell = TopGraphComponent.this.getCellAt(e.getX(), e.getY(), false)) != null) {
                this.graphComponent.selectCellForEvent(cell, e);
            }
        }

        protected boolean isDragTrigger(MouseEvent e) {
            return e.isShiftDown() && SwingUtilities.isLeftMouseButton(e);
        }

        protected synchronized Cursor getCursor(MouseEvent e) {
            mxCell cell = (mxCell)this.graphComponent.getCellAt(e.getX(), e.getY(), false);
            this.updateHighlight(TopGraphComponent.this.cellFindingId.get(), cell);
            if (cell == null) {
                return null;
            }
            if (this.isMoveEnabled() && this.graphComponent.getGraph().isCellMovable((Object)cell) && this.isDragTrigger(e)) {
                return MOVE_CURSOR;
            }
            return FOLD_CURSOR;
        }

        protected void updateHighlight(final int id, final mxCell cell) {
            TopGraphComponent.this.updateService.submit(new Runnable(){

                @Override
                public void run() {
                    if (id != TopGraphComponent.this.cellFindingId.get()) {
                        return;
                    }
                    if (cell != null && cell.isVertex()) {
                        if (GraphHandler.this.hasHighlight) {
                            ((TopGraph)TopGraphComponent.this.graph).clearHighlightedEdges();
                        }
                        ((TopGraph)TopGraphComponent.this.graph).highlightConnections(cell, true);
                        GraphHandler.this.hasHighlight = true;
                        TopGraphComponent.this.updateGraph();
                    } else if (GraphHandler.this.hasHighlight) {
                        ((TopGraph)TopGraphComponent.this.graph).clearHighlightedEdges();
                        GraphHandler.this.hasHighlight = false;
                        TopGraphComponent.this.updateGraph();
                    }
                }
            });
        }
    }

    class PanningHandler
    extends mxPanningHandler {
        public PanningHandler(mxGraphComponent graphComponent) {
            super(graphComponent);
        }

        public void mousePressed(final MouseEvent e) {
            if (this.isEnabled() && !e.isConsumed() && this.graphComponent.isPanningEvent(e) && !e.isPopupTrigger()) {
                TopGraphComponent.this.graphControl.setCursor(mxGraphHandler.FOLD_CURSOR);
                TopGraphComponent.this.updateService.submit(new Runnable(){

                    @Override
                    public void run() {
                        PanningHandler.this.start = e.getPoint();
                        TopGraphComponent.this.viewTranslate = TopGraphComponent.this.view.getTranslate();
                    }
                });
            }
        }

        public void mouseDragged(final MouseEvent e) {
            if (!e.isConsumed() && this.start != null) {
                final int id = TopGraphComponent.this.transId.incrementAndGet();
                TopGraphComponent.this.updateService.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (id == TopGraphComponent.this.transId.get()) {
                            int dx = e.getX() - ((PanningHandler)PanningHandler.this).start.x;
                            int dy = e.getY() - ((PanningHandler)PanningHandler.this).start.y;
                            double scale = TopGraphComponent.this.view.getScale();
                            TopGraphComponent.this.view.setTranslate(new mxPoint(TopGraphComponent.this.viewTranslate.getX() + (double)dx / scale, TopGraphComponent.this.viewTranslate.getY() + (double)dy / scale));
                            TopGraphComponent.this.restartTimer();
                        }
                        e.consume();
                    }
                });
            }
        }

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            TopGraphComponent.this.graphControl.setCursor(mxGraphHandler.DEFAULT_CURSOR);
            TopGraphComponent.this.userTranslated = true;
        }
    }
}

