/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.ui.network.MarkedEdgeHandler;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopGraphComponent;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.handler.mxCellHandler;
import com.mxgraph.util.mxEvent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;

public class TopMarkedEdgesHandler {
    protected TopGraphComponent graphComponent;
    protected boolean enabled = true;
    protected Rectangle bounds = null;
    protected transient LinkedHashMap<Object, mxCellHandler> handlers = new LinkedHashMap();
    protected transient mxEventSource.mxIEventListener refreshHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object source, mxEventObject evt) {
            if (TopMarkedEdgesHandler.this.isEnabled()) {
                TopMarkedEdgesHandler.this.refresh();
            }
        }
    };

    public TopMarkedEdgesHandler(TopGraphComponent graphComponent) {
        this.graphComponent = graphComponent;
        this.addGraphListeners(graphComponent.getGraph());
        graphComponent.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("graph")) {
                    TopMarkedEdgesHandler.this.removeGraphListeners((mxGraph)evt.getOldValue());
                    TopMarkedEdgesHandler.this.addGraphListeners((mxGraph)evt.getNewValue());
                }
            }
        });
        graphComponent.addListener("paint", new mxEventSource.mxIEventListener(){

            public void invoke(Object sender, mxEventObject evt) {
                Graphics g = (Graphics)evt.getProperty("g");
                TopMarkedEdgesHandler.this.paintHandlers(g);
            }
        });
    }

    protected void addGraphListeners(mxGraph graph) {
        if (graph != null) {
            graph.addListener(mxEvent.MARK, this.refreshHandler);
            graph.getModel().addListener("change", this.refreshHandler);
            graph.getView().addListener("scale", this.refreshHandler);
            graph.getView().addListener("translate", this.refreshHandler);
            graph.getView().addListener("scaleAndTranslate", this.refreshHandler);
            graph.getView().addListener("down", this.refreshHandler);
            graph.getView().addListener("up", this.refreshHandler);
        }
    }

    protected void removeGraphListeners(mxGraph graph) {
        try {
            if (graph != null) {
                graph.removeListener(this.refreshHandler, mxEvent.MARK);
                graph.getModel().removeListener(this.refreshHandler, "change");
                graph.getView().removeListener(this.refreshHandler, "scale");
                graph.getView().removeListener(this.refreshHandler, "translate");
                graph.getView().removeListener(this.refreshHandler, "scaleAndTranslate");
                graph.getView().removeListener(this.refreshHandler, "down");
                graph.getView().removeListener(this.refreshHandler, "up");
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public synchronized void refresh() {
        TopGraph graph = (TopGraph)this.graphComponent.getGraph();
        this.handlers = new LinkedHashMap();
        Rectangle handlerBounds = this.calculateHandlerBounds(graph);
        Rectangle dirty = this.bounds;
        if (handlerBounds != null) {
            if (dirty != null) {
                dirty.add(handlerBounds);
            } else {
                dirty = handlerBounds;
            }
        }
        if (dirty != null) {
            this.graphComponent.getGraphControl().repaint(dirty);
        }
        this.bounds = handlerBounds;
    }

    private Rectangle calculateHandlerBounds(TopGraph graph) {
        Rectangle handlerBounds = null;
        LinkedHashMap<Object, mxCellHandler> oldHandlers = this.handlers;
        mxIGraphModel model = graph.getModel();
        Object parent = graph.getDefaultParent();
        int count = model.getChildCount(parent);
        for (int i = 0; i < count; ++i) {
            Rectangle bounds;
            mxCellState state;
            mxCell cell = (mxCell)model.getChildAt(parent, i);
            if (!cell.isEdge() || !graph.isMarked(cell) || (state = graph.getView().getState((Object)cell)) == null || state.getCell() == graph.getView().getCurrentRoot()) continue;
            mxCellHandler handler = (mxCellHandler)oldHandlers.remove(cell);
            if (handler != null) {
                handler.refresh(state);
            } else {
                handler = new MarkedEdgeHandler(this.graphComponent, state);
            }
            this.handlers.put(cell, handler);
            Stroke stroke = handler.getSelectionStroke();
            Rectangle rectangle = bounds = stroke == null ? handler.getBounds() : stroke.createStrokedShape(handler.getBounds()).getBounds();
            if (handlerBounds == null) {
                handlerBounds = bounds;
                continue;
            }
            handlerBounds.add(bounds);
        }
        return handlerBounds;
    }

    public synchronized void paintHandlers(Graphics g) {
        mxCellHandler[] tmp;
        for (mxCellHandler handler : tmp = this.handlers.values().toArray(new mxCellHandler[0])) {
            handler.paint(g);
        }
    }
}

