/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.LinkRecordBean;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.model.GraphCells;
import com.intel.stl.ui.model.GraphEdge;
import com.intel.stl.ui.model.GraphNode;
import com.intel.stl.ui.model.LayoutType;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.network.GraphBuilder;
import com.intel.stl.ui.network.IModelChange;
import com.intel.stl.ui.network.ITopologyListener;
import com.intel.stl.ui.network.ResourceController;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopologyTreeController;
import com.intel.stl.ui.network.TopologyTreeModel;
import com.intel.stl.ui.network.TopologyUpdateController;
import com.intel.stl.ui.network.TreeLayout;
import com.intel.stl.ui.network.task.LayoutTask;
import com.intel.stl.ui.network.task.RefreshGraphTask;
import com.intel.stl.ui.network.task.ShowAllTask;
import com.intel.stl.ui.network.task.ShowEdgesTask;
import com.intel.stl.ui.network.task.ShowGroupTask;
import com.intel.stl.ui.network.task.ShowNodeTask;
import com.intel.stl.ui.network.task.ShowRoutesTask;
import com.intel.stl.ui.network.view.TopologyGraphView;
import com.intel.stl.ui.network.view.TopologyGuideView;
import com.intel.stl.ui.network.view.TopologyView;
import com.intel.stl.ui.publisher.CallbackAdapter;
import com.intel.stl.ui.publisher.CancellableCall;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.SingleTaskManager;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import net.engio.mbassy.bus.MBassador;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyGraphController
implements ITopologyListener {
    private static final Logger log = LoggerFactory.getLogger(TopologyGraphController.class);
    private static final boolean DEBUG = true;
    private final TopologyTreeController parent;
    private final TopologyGraphView graphView;
    private final TopologyGuideView guideView;
    private ISubnetApi subnetApi;
    private final SingleTaskManager taskMgr;
    private TopologyTreeModel fullTopTreeModel;
    private TopologyTreeModel topTreeModel;
    private TopologyUpdateController updateCtrl;
    private final ResourceController resourceController;
    private final LayoutType[] availableLayouts;
    private final LayoutType defaultLayout;
    private LayoutType currentLayout;
    private GraphCells lastGraphSelection;
    private FVResourceNode[] lastResourceSelection;

    public TopologyGraphController(TopologyTreeController parent, MBassador<IAppEvent> eventBus) {
        this.currentLayout = this.defaultLayout = LayoutType.TREE_SLASH;
        this.parent = parent;
        TopologyView topView = (TopologyView)parent.getView();
        this.graphView = topView.getGraphView();
        this.graphView.setTopologyListener(this);
        this.availableLayouts = LayoutType.values();
        this.graphView.setAvailableLayouts(this.availableLayouts);
        this.guideView = topView.getGuideView();
        this.resourceController = new ResourceController(topView.getResourceView(), eventBus);
        this.taskMgr = new SingleTaskManager();
    }

    public void setContext(Context pContext, IProgressObserver observer) {
        IProgressObserver[] subObservers = observer.createSubObservers(3);
        if (this.updateCtrl != null) {
            this.updateCtrl.cancel();
        }
        this.resourceController.setContext(pContext, subObservers[0]);
        subObservers[0].onFinish();
        this.subnetApi = pContext.getSubnetApi();
        List<NodeRecordBean> nodes = null;
        List<LinkRecordBean> links = null;
        try {
            nodes = this.subnetApi.getNodes(false);
            links = this.subnetApi.getLinks(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            RuntimeException rte = new RuntimeException("Could not retrieve nodes and links.", e);
            throw rte;
        }
        if (nodes == null || links == null) {
            observer.onFinish();
            return;
        }
        subObservers[1].onFinish();
        if (observer.isCancelled()) {
            return;
        }
        final TopGraph fullGraph = TopGraph.createGraph();
        if (observer.isCancelled()) {
            return;
        }
        GraphBuilder builder = new GraphBuilder();
        this.fullTopTreeModel = this.topTreeModel = builder.build(fullGraph, nodes, links);
        if (this.topTreeModel == null || observer.isCancelled()) {
            return;
        }
        fullGraph.expandAll();
        TreeLayout layout = new TreeLayout(fullGraph, this.fullTopTreeModel, TreeLayout.Style.SLASH);
        layout.execute(fullGraph.getDefaultParent());
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                TopGraph outlineGraph = TopGraph.createGraph();
                outlineGraph.setModel(fullGraph.getModel());
                TopologyGraphController.this.guideView.setGraph(outlineGraph);
                TopologyGraphController.this.graphView.setGraph(fullGraph);
            }
        });
        this.updateCtrl = new TopologyUpdateController(fullGraph, (TopologyView)this.parent.getView());
        subObservers[2].onFinish();
        if (observer.isCancelled()) {
            return;
        }
    }

    public void onRefresh(IProgressObserver observer, final ICallback<Void> callback) {
        if (this.updateCtrl == null) {
            TopGraph fullGraph = TopGraph.createGraph();
            TopGraph outlineGraph = TopGraph.createGraph();
            this.guideView.setGraph(outlineGraph);
            this.graphView.setGraph(fullGraph);
            this.updateCtrl = new TopologyUpdateController(fullGraph, (TopologyView)this.parent.getView());
        }
        RefreshGraphTask task = new RefreshGraphTask(this, null, null, this.defaultLayout, observer){

            @Override
            public void onSuccess(ICancelIndicator indicator, TopGraph graph) {
                TopologyGraphController.this.updateCtrl.setGraph(graph);
                super.onSuccess(indicator, graph);
                if (callback != null) {
                    callback.onDone(null);
                } else {
                    TopologyGraphController.this.onSelectionChange(TopologyGraphController.this.lastGraphSelection, null, TopologyGraphController.this.lastResourceSelection);
                }
            }
        };
        this.updateCtrl.update(task);
    }

    public ISubnetApi getSubnetApi() {
        return this.subnetApi;
    }

    public TopologyGraphView getGraphView() {
        return this.graphView;
    }

    public TopologyGuideView getGuideView() {
        return this.guideView;
    }

    public ResourceController getResourceController() {
        return this.resourceController;
    }

    public TopologyTreeModel getFullTopTreeModel() {
        return this.fullTopTreeModel;
    }

    public void setFullTopTreeModel(TopologyTreeModel fullTopTreeModel) {
        this.fullTopTreeModel = fullTopTreeModel;
    }

    public TopologyTreeModel getTopTreeModel() {
        return this.topTreeModel;
    }

    public void setTopTreeModel(TopologyTreeModel topTreeModel) {
        this.topTreeModel = topTreeModel;
    }

    public LayoutType getCurrentLayout() {
        return this.currentLayout;
    }

    public void setCurrentLayout(LayoutType currentLayout) {
        this.currentLayout = currentLayout;
    }

    protected void processTreeGroups(final FVResourceNode[] groups) {
        CancellableCall<GraphCells> caller = new CancellableCall<GraphCells>(){

            @Override
            public GraphCells call(ICancelIndicator indicator) throws Exception {
                GraphCells current = new GraphCells();
                for (FVResourceNode group : groups) {
                    for (FVResourceNode node : group.getChildren()) {
                        if (indicator.isCancelled()) {
                            return null;
                        }
                        GraphNode gNode = TopologyGraphController.this.updateCtrl.getGraphNode(node.getId());
                        current.addNode(gNode);
                    }
                }
                return current;
            }
        };
        CallbackAdapter<GraphCells> callback = new CallbackAdapter<GraphCells>(){

            @Override
            public void onDone(GraphCells result) {
                TopologyGraphController.this.onSelectionChange(result, TopologyGraphController.this, groups);
            }
        };
        this.taskMgr.submit(caller, callback);
    }

    protected void processTreeNodes(final FVResourceNode[] nodes) {
        CancellableCall<GraphCells> caller = new CancellableCall<GraphCells>(){

            @Override
            public GraphCells call(ICancelIndicator indicator) throws Exception {
                GraphCells current = new GraphCells();
                for (FVResourceNode node : nodes) {
                    if (indicator.isCancelled()) {
                        return null;
                    }
                    GraphNode gNode = TopologyGraphController.this.updateCtrl.getGraphNode(node.getId());
                    current.addNode(gNode);
                }
                return current;
            }
        };
        CallbackAdapter<GraphCells> callback = new CallbackAdapter<GraphCells>(){

            @Override
            public void onDone(GraphCells result) {
                TopologyGraphController.this.onSelectionChange(result, TopologyGraphController.this, nodes);
            }
        };
        this.taskMgr.submit(caller, callback);
    }

    protected void processTreePorts(final FVResourceNode[] nodes) {
        CancellableCall<GraphCells> caller = new CancellableCall<GraphCells>(){

            @Override
            public GraphCells call(ICancelIndicator indicator) throws Exception {
                GraphCells current = new GraphCells();
                HashMap<Point, GraphEdge> edges = new HashMap<Point, GraphEdge>();
                for (FVResourceNode node : nodes) {
                    if (indicator.isCancelled()) {
                        return null;
                    }
                    FVResourceNode parent = node.getParent();
                    int lid = parent.getId();
                    TreeNodeType type = parent.getType();
                    if (type == TreeNodeType.SWITCH && node.getId() == 0) {
                        GraphNode gNode = TopologyGraphController.this.updateCtrl.getGraphNode(lid);
                        current.addNode(gNode);
                        continue;
                    }
                    int portNum = node.getId();
                    GraphNode gNode = TopologyGraphController.this.updateCtrl.getGraphNode(lid);
                    if (gNode != null) {
                        GraphNode toNode = gNode.getNeighbor(portNum);
                        if (toNode != null) {
                            Integer toPort = gNode.getLinkPorts(toNode).get(portNum);
                            TreeMap<Integer, Integer> linkPorts = new TreeMap<Integer, Integer>();
                            if (toPort != null) {
                                linkPorts.put(portNum, toPort);
                            }
                            GraphEdge tmp = new GraphEdge(lid, TreeNodeType.getNodeTypeCode(type), toNode.getLid(), toNode.getType(), linkPorts);
                            GraphEdge edge = (GraphEdge)edges.get(new Point(lid, toNode.getLid()));
                            if (edge == null && (edge = (GraphEdge)edges.get(new Point(toNode.getLid(), lid))) != null) {
                                tmp = tmp.normalize();
                            }
                            if (edge == null) {
                                current.addEdge(tmp);
                                edges.put(new Point(lid, toNode.getLid()), tmp);
                                continue;
                            }
                            edge.getLinks().putAll(tmp.getLinks());
                            continue;
                        }
                        log.warn("Couldn't find connection for Lid=" + lid + " PortNum=" + portNum);
                        continue;
                    }
                    log.warn("Couldn't find node with Lid=" + lid);
                }
                return current;
            }
        };
        CallbackAdapter<GraphCells> callback = new CallbackAdapter<GraphCells>(){

            @Override
            public void onDone(GraphCells result) {
                TopologyGraphController.this.onSelectionChange(result, TopologyGraphController.this, nodes);
            }
        };
        this.taskMgr.submit(caller, callback);
    }

    protected void setLayout(LayoutType type, IModelChange preChange) {
        LayoutTask updateTask = new LayoutTask(this, type, preChange);
        this.updateCtrl.update(updateTask);
    }

    @Override
    public void onUndo() {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                TopologyGraphController.this.graphView.enableUndo(TopologyGraphController.this.updateCtrl.undo());
                TopologyGraphController.this.graphView.enableRedo(true);
                TopologyGraphController.this.graphView.revalidate();
            }
        });
    }

    @Override
    public void onRedo() {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                TopologyGraphController.this.graphView.enableUndo(true);
                TopologyGraphController.this.graphView.enableRedo(TopologyGraphController.this.updateCtrl.redo());
                TopologyGraphController.this.graphView.revalidate();
            }
        });
    }

    @Override
    public void onReset() {
        this.setLayout(this.currentLayout, null);
    }

    @Override
    public void onLayoutTypeChange(int typeIndex) {
        LayoutType layout = this.availableLayouts[typeIndex];
        if (this.currentLayout != layout) {
            this.setLayout(layout, null);
        }
    }

    @Override
    public void onExpandAll() {
        if (this.currentLayout != null) {
            IModelChange expandAllchange = new IModelChange(){

                @Override
                public boolean execute(TopGraph graph, ICancelIndicator indicator) {
                    graph.expandAll();
                    return true;
                }
            };
            this.setLayout(this.currentLayout, expandAllchange);
        }
    }

    @Override
    public void onCollapseAll() {
        if (this.currentLayout != null) {
            IModelChange collapseAllchange = new IModelChange(){

                @Override
                public boolean execute(TopGraph graph, ICancelIndicator indicator) {
                    graph.collapseAll();
                    return true;
                }
            };
            this.setLayout(this.currentLayout, collapseAllchange);
        }
    }

    @Override
    public void onSelectionChange(final GraphCells current, final Object source, FVResourceNode[] selecedResources) {
        System.out.println("Current " + Arrays.toString(selecedResources) + " " + current + " " + Thread.currentThread());
        System.out.println("Last " + this.lastGraphSelection);
        if (this.currentLayout == null) {
            return;
        }
        this.lastGraphSelection = current;
        this.lastResourceSelection = selecedResources;
        if (selecedResources == null) {
            ArrayList<FVResourceNode> resources = new ArrayList<FVResourceNode>();
            if (current.hasNodes()) {
                for (GraphNode node : current.getNodes()) {
                    FVResourceNode resource = new FVResourceNode(Integer.toString(node.getLid()), node.isEndNode() ? TreeNodeType.HFI : TreeNodeType.SWITCH, node.getLid());
                    resources.add(resource);
                }
            } else if (current.hasEdges()) {
                for (GraphEdge edge : current.getEdges()) {
                    Map<Integer, Integer> links = edge.getLinks();
                    int portNum = links.keySet().iterator().next();
                    FVResourceNode resource = new FVResourceNode(edge.getFromLid() + ":" + portNum, TreeNodeType.ACTIVE_PORT, portNum);
                    resources.add(resource);
                }
            }
            selecedResources = resources.toArray(new FVResourceNode[0]);
        }
        final FVResourceNode firstResource = selecedResources == null || selecedResources.length == 0 ? null : selecedResources[0];
        final FVResourceNode[] resourceSelection = selecedResources;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List<GraphNode> tmpNodes = current.getNodes();
                ArrayList<GraphNode> nodes = new ArrayList<GraphNode>();
                if (tmpNodes != null) {
                    for (GraphNode tmpNode : tmpNodes) {
                        if (tmpNode == null) continue;
                        nodes.add(TopologyGraphController.this.updateCtrl.getGraphNode(tmpNode.getLid()));
                    }
                }
                if (firstResource == null || firstResource.getType() == TreeNodeType.ALL) {
                    TopologyGraphController.this.onEmptySelection(source, resourceSelection);
                } else if (firstResource.isNode()) {
                    if (resourceSelection.length == 1) {
                        TopologyGraphController.this.onSingleNode((GraphNode)nodes.get(0), source, resourceSelection);
                    } else {
                        TopologyGraphController.this.onMultipleNodes(nodes, source, resourceSelection);
                    }
                } else if (firstResource.isPort()) {
                    if (firstResource.getId() > 0) {
                        List<GraphEdge> edges = current.getEdges();
                        TopologyGraphController.this.onEdges(edges, source, resourceSelection);
                    } else {
                        FVResourceNode[] nodeSelection = new FVResourceNode[resourceSelection.length];
                        for (int i = 0; i < nodeSelection.length; ++i) {
                            nodeSelection[i] = resourceSelection[i].getParent();
                        }
                        if (resourceSelection.length == 1) {
                            TopologyGraphController.this.onEdges(null, source, nodeSelection);
                        } else {
                            TopologyGraphController.this.onMultipleNodes(nodes, source, nodeSelection);
                        }
                    }
                } else {
                    TopologyGraphController.this.onNodeSet(nodes, source, resourceSelection);
                }
            }
        });
    }

    protected void onEmptySelection(Object source, FVResourceNode[] selectedResources) {
        ShowAllTask updateTask = new ShowAllTask(this, source, selectedResources);
        this.updateCtrl.update(updateTask);
    }

    protected void onNodeSet(List<GraphNode> nodes, Object source, FVResourceNode[] selectedResources) {
        ShowGroupTask updateTask = new ShowGroupTask(this, source, selectedResources, nodes);
        this.updateCtrl.update(updateTask);
    }

    protected void onSingleNode(GraphNode node, Object source, FVResourceNode[] selectedResources) {
        ShowNodeTask updateTask = new ShowNodeTask(this, source, selectedResources, node);
        this.updateCtrl.update(updateTask);
    }

    protected void onMultipleNodes(List<GraphNode> nodes, Object source, FVResourceNode[] selectedResources) {
        ShowRoutesTask updateTask = new ShowRoutesTask(this, source, selectedResources, nodes);
        this.updateCtrl.update(updateTask);
    }

    protected void onEdges(List<GraphEdge> edges, Object source, FVResourceNode[] selectedResources) {
        ShowEdgesTask updateTask = new ShowEdgesTask(this, source, selectedResources, edges);
        this.updateCtrl.update(updateTask);
    }

    public void clearTreeSelection() {
        this.parent.clearTreeSelection();
    }

    public FVResourceNode[] selectTreeNodes(List<GraphNode> nodes, ICancelIndicator indicator) {
        return this.parent.selectTreeNodes(nodes, indicator);
    }

    public FVResourceNode[] selectTreePorts(List<GraphEdge> edges, ICancelIndicator indicator) {
        return this.parent.selectTreePorts(edges, indicator);
    }

    public void setCurrentSubpage(String subpageName) {
        this.resourceController.setCurrentSubpage(subpageName);
    }

    public String getPreviousSubpage() {
        return this.resourceController.getPreviousSubpage();
    }

    public String getCurrentSubpage() {
        return this.resourceController.getCurrentSubpage();
    }

    public void cleanup() {
        try {
            if (this.updateCtrl != null) {
                this.updateCtrl.cancel();
            }
            this.graphView.getUpdateService().shutdown();
            log.info("GraphView update service shutdown");
        }
        finally {
            this.guideView.getUpdateService().shutdown();
            log.info("GuideView update service shutdown");
        }
    }
}

