/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network.task;

import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.model.GraphNode;
import com.intel.stl.ui.model.LayoutType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.network.LayoutChange;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopologyGraphController;
import com.intel.stl.ui.network.TopologyTreeModel;
import com.intel.stl.ui.network.task.TopologyUpdateTask;
import com.mxgraph.model.mxCell;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;

public class ShowGroupTask
extends TopologyUpdateTask {
    private TopGraph oldGraph;
    private final List<GraphNode> nodes;
    private TopologyTreeModel tmpTreeMode;
    private final TopologyTreeModel fullTopTreeModel;
    private final LayoutType defaultLayout = LayoutType.TREE_SLASH;

    public ShowGroupTask(TopologyGraphController controller, Object source, FVResourceNode[] selectedResources, List<GraphNode> nodes) {
        super(controller, source, selectedResources);
        this.nodes = nodes;
        this.fullTopTreeModel = controller.getFullTopTreeModel();
        this.setIncludeNeighbors(false);
    }

    @Override
    protected Collection<Integer> getInvolvedNodes(ICancelIndicator indicator, TopGraph oldGraph) {
        this.oldGraph = oldGraph;
        if (this.nodes.size() == this.fullTopTreeModel.getNumTotalNodes()) {
            return null;
        }
        HashSet<Integer> involvedNodes = new HashSet<Integer>();
        for (GraphNode node : this.nodes) {
            if (involvedNodes == null || node == null) continue;
            involvedNodes.add(node.getLid());
        }
        return involvedNodes;
    }

    @Override
    public boolean applyChanges(ICancelIndicator indicator, TopGraph newGraph) {
        this.tmpTreeMode = this.fullTopTreeModel.filterBy(newGraph);
        LayoutChange change = new LayoutChange(this.defaultLayout, this.tmpTreeMode);
        change.execute(newGraph, indicator);
        String name = null;
        ImageIcon icon = null;
        if (this.selectedResources.length == 1) {
            name = this.selectedResources[0].getName();
            icon = this.selectedResources[0].getType().getIcon();
        } else {
            name = STLConstants.K2078_DEVIE_SET.getValue();
            icon = UIImages.DEVICE_SET.getImageIcon();
        }
        this.resourceController.showGroup(this.selectedResources, name, icon, this.tmpTreeMode, newGraph, this.oldGraph);
        return true;
    }

    @Override
    public void onSuccess(final ICancelIndicator indicator, TopGraph newGraph) {
        super.onSuccess(indicator, newGraph);
        this.controller.setTopTreeModel(this.tmpTreeMode);
        final mxCell[] cells = new mxCell[this.nodes.size()];
        for (int i = 0; i < cells.length; ++i) {
            cells[i] = newGraph.getVertex(this.nodes.get(i).getLid());
        }
        this.submitGraphTask(new Runnable(){

            @Override
            public void run() {
                ShowGroupTask.this.graphView.clearEdges();
                if (!indicator.isCancelled()) {
                    ShowGroupTask.this.graphView.selectNodes(cells);
                }
                ShowGroupTask.this.graphView.updateGraph();
            }
        });
        this.submitOutlineTask(new Runnable(){

            @Override
            public void run() {
                ShowGroupTask.this.guideView.clearEdges();
                if (!indicator.isCancelled()) {
                    ShowGroupTask.this.guideView.selectNodes(cells);
                }
                ShowGroupTask.this.guideView.updateGraph();
            }
        });
        this.guideView.setSelectedResources(this.selectedResources);
        this.setLayout(this.defaultLayout);
    }
}

