/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network.view;

import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.view.ISectionListener;
import com.intel.stl.ui.common.view.IntelTabbedPaneUI;
import com.intel.stl.ui.common.view.JSectionView;
import com.intel.stl.ui.main.view.IPageListener;
import com.intel.stl.ui.network.IResourceNodeSubpageController;
import java.awt.BorderLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ResourceSubpageView
extends JSectionView<ISectionListener>
implements ChangeListener {
    private static final long serialVersionUID = 5656598693998044183L;
    private JTabbedPane tabbedPane;
    private IntelTabbedPaneUI tabUI;
    private JPanel ctrPanel;
    private IPageListener listener;
    private String currentTab = null;

    public ResourceSubpageView(String title) {
        super(title);
        this.getMainComponent();
    }

    @Override
    protected JComponent getMainComponent() {
        if (this.tabbedPane != null) {
            return this.tabbedPane;
        }
        this.tabbedPane = new JTabbedPane();
        this.tabUI = new IntelTabbedPaneUI();
        this.ctrPanel = this.tabUI.getControlPanel();
        this.ctrPanel.setLayout(new BorderLayout());
        this.ctrPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 5));
        this.tabbedPane.setUI(this.tabUI);
        this.tabUI.setFont(UIConstants.H4_FONT);
        this.tabUI.setTabAreaInsets(new Insets(2, 5, 4, 5));
        return this.tabbedPane;
    }

    public String getCurrentSubpage() {
        int currentTab = this.tabbedPane.getSelectedIndex();
        if (currentTab < 0) {
            return null;
        }
        return this.tabbedPane.getTitleAt(currentTab);
    }

    public void setCurrentSubpage(String name) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (!this.tabbedPane.getTitleAt(i).equals(name)) continue;
            this.tabbedPane.setSelectedIndex(i);
            break;
        }
    }

    public void setTabs(List<IResourceNodeSubpageController> subpages, int selection) {
        this.tabbedPane.removeChangeListener(this);
        this.tabbedPane.removeAll();
        for (IResourceNodeSubpageController subpage : subpages) {
            this.tabbedPane.addTab(subpage.getName(), subpage.getIcon(), subpage.getView(), subpage.getDescription());
        }
        this.tabbedPane.setSelectedIndex(selection > 0 ? selection : 0);
        int index = this.tabbedPane.getSelectedIndex();
        this.currentTab = this.tabbedPane.getTitleAt(index);
        this.tabbedPane.addChangeListener(this);
    }

    public void clearPage(NodeType type) {
    }

    public void setPageListener(IPageListener listener) {
        this.listener = listener;
        this.tabbedPane.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.listener == null) {
            return;
        }
        String oldTab = this.currentTab;
        int index = this.tabbedPane.getSelectedIndex();
        this.currentTab = this.tabbedPane.getTitleAt(index);
        if (oldTab != null && this.currentTab != null) {
            this.listener.onPageChanged(oldTab, this.currentTab);
        }
    }
}

