/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network.view;

import com.intel.stl.ui.common.IBackgroundService;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopGraphComponent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxGraphView;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyOutlinePanel
extends JPanel {
    private static final long serialVersionUID = -2802225776501250477L;
    private static final Logger log = LoggerFactory.getLogger(TopologyOutlinePanel.class);
    private static final int MAX_OUTLINE_HEIGHT = 300;
    private final Fit fit;
    private TopGraphComponent graphComp;
    private double ratio;
    private double scale;
    private BufferedImage img;
    private Timer repaintTimer;
    private IProgressObserver progressObserver;
    private final IBackgroundService updateService;
    private final AtomicInteger imageId = new AtomicInteger();
    protected mxEventSource.mxIEventListener repaintHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object sender, mxEventObject evt) {
            TopologyOutlinePanel.this.repaint();
        }
    };

    public TopologyOutlinePanel(IBackgroundService updateService) {
        this(updateService, Fit.WINDOW);
    }

    public TopologyOutlinePanel(IBackgroundService updateService, Fit fit) {
        this.updateService = updateService;
        this.fit = fit;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TopologyOutlinePanel.this.restartTimer();
            }
        });
    }

    public void setProgressObserver(IProgressObserver progressObserver) {
        this.progressObserver = progressObserver;
    }

    public void setGraph(TopGraph graph) {
        this.clearTimer();
        if (this.graphComp == null) {
            this.graphComp = new TopGraphComponent(this.updateService, graph);
            this.graphComp.setSelectionListener(null);
        } else {
            this.graphComp.getGraph().removeListener(this.repaintHandler, "repaint");
            this.graphComp.setGraph(graph);
        }
        graph.addListener("repaint", this.repaintHandler);
        this.restartTimer();
    }

    protected void updateImage() {
        if (this.graphComp == null || this.graphComp.getGraph() == null) {
            return;
        }
        if (this.progressObserver != null) {
            this.progressObserver.publishProgress(0.0);
        }
        final int id = this.imageId.incrementAndGet();
        this.updateService.submit(new Runnable(){

            @Override
            public void run() {
                TopologyOutlinePanel.this.img = TopologyOutlinePanel.this.createImage(id);
                TopologyOutlinePanel.this.revalidate();
                TopologyOutlinePanel.this.repaint();
                if (TopologyOutlinePanel.this.progressObserver != null) {
                    TopologyOutlinePanel.this.progressObserver.onFinish();
                }
            }
        });
    }

    public BufferedImage getImage() {
        return this.img;
    }

    public void setImage(final BufferedImage image) {
        this.updateService.submit(new Runnable(){

            @Override
            public void run() {
                TopologyOutlinePanel.this.img = image;
                TopologyOutlinePanel.this.repaint();
                if (TopologyOutlinePanel.this.progressObserver != null) {
                    TopologyOutlinePanel.this.progressObserver.onFinish();
                }
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (this.fit == Fit.WIDTH && this.ratio > 0.0) {
            double panelWidth = Math.max(dim.width, this.getWidth());
            dim.height = (int)Math.ceil(panelWidth * this.ratio);
            if (dim.height > 300) {
                dim.height = 300;
                dim.width = (int)Math.ceil((double)dim.height / this.ratio);
            }
        }
        return dim;
    }

    protected Dimension adjustSize(Dimension dim) {
        if (this.ratio > 0.0) {
            switch (this.fit) {
                case WIDTH: {
                    dim.height = (int)(dim.getWidth() * this.ratio);
                    if (dim.height <= 300) break;
                    dim.height = 300;
                    dim.width = (int)((double)dim.height / this.ratio);
                    break;
                }
                case WINDOW: {
                    double newHeight = dim.getWidth() * this.ratio;
                    if (newHeight > (double)dim.height) {
                        dim.width = (int)((double)dim.height / this.ratio);
                        break;
                    }
                    dim.height = (int)newHeight;
                }
            }
        }
        return dim;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.img != null) {
            this.clearTimer();
            Dimension dim = this.getSize();
            this.paintImage((Graphics2D)g, this.img, this.adjustSize(dim));
        }
    }

    protected void restartTimer() {
        if (this.repaintTimer == null) {
            this.repaintTimer = new Timer(250, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TopologyOutlinePanel.this.repaintTimer != null) {
                        TopologyOutlinePanel.this.updateImage();
                    }
                }
            });
            this.repaintTimer.setRepeats(false);
        }
        this.repaintTimer.restart();
    }

    protected void clearTimer() {
        if (this.repaintTimer != null) {
            if (this.repaintTimer.isRunning()) {
                this.repaintTimer.stop();
            }
            this.repaintTimer = null;
        }
    }

    public void initView() {
        this.restartTimer();
    }

    protected void paintImage(Graphics2D g2d, BufferedImage img, Dimension dim) {
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.drawImage(img, 0, 0, dim.width, dim.height, this);
    }

    protected void paintImage2(Graphics2D g2d, BufferedImage img, Dimension dim) {
        int scale = dim.width / img.getWidth();
        int mode = scale < 1 ? 16 : 4;
        Image scaledImage = img.getScaledInstance(dim.width, dim.height, mode);
        g2d.drawImage(scaledImage, 0, 0, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage createImage(int id) {
        BufferedImage bufferedImage;
        if (id < this.imageId.get()) {
            return this.img;
        }
        long t = System.currentTimeMillis();
        BufferedImage img = null;
        mxGraphView view = this.graphComp.getGraph().getView();
        double graphScale = view.getScale();
        mxPoint graphTrans = view.getTranslate();
        try {
            Rectangle orgGrapSize = view.getGraphBounds().getRectangle();
            view.setTranslate(new mxPoint(-orgGrapSize.getX() + graphTrans.getX(), -orgGrapSize.getY() + graphTrans.getY()));
            this.ratio = (double)orgGrapSize.height / (double)orgGrapSize.width;
            Insets insets = this.getInsets();
            int w = this.getSize().width - insets.left - insets.right;
            int h = this.getSize().height - insets.top - insets.bottom;
            Dimension dim = this.adjustSize(new Dimension(w, h));
            this.scale = (double)dim.width / (double)orgGrapSize.width * graphScale;
            view.setScale(this.scale);
            img = mxUtils.createBufferedImage((int)(dim.width + insets.left + insets.right), (int)(dim.height + insets.top + insets.bottom), null);
            if (img != null) {
                Graphics2D g2 = img.createGraphics();
                try {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    AffineTransform trans = new AffineTransform();
                    trans.translate(insets.left, insets.top);
                    g2.setTransform(trans);
                    this.graphComp.getGraphControl().paintComponent((Graphics)g2);
                }
                finally {
                    g2.dispose();
                }
            }
            bufferedImage = img;
        }
        catch (Exception e) {
            BufferedImage bufferedImage2;
            try {
                e.printStackTrace();
                bufferedImage2 = null;
            }
            catch (Throwable throwable) {
                view.setScale(graphScale);
                view.setTranslate(graphTrans);
                log.info("Create OutlineBuffer-" + id + " " + (img == null ? "" : img.getWidth() + "x" + img.getHeight() + " " + img.hashCode()) + " on " + this.graphComp.getGraph() + " in " + (System.currentTimeMillis() - t) + " ms @ " + Thread.currentThread());
                throw throwable;
            }
            view.setScale(graphScale);
            view.setTranslate(graphTrans);
            log.info("Create OutlineBuffer-" + id + " " + (img == null ? "" : img.getWidth() + "x" + img.getHeight() + " " + img.hashCode()) + " on " + this.graphComp.getGraph() + " in " + (System.currentTimeMillis() - t) + " ms @ " + Thread.currentThread());
            return bufferedImage2;
        }
        view.setScale(graphScale);
        view.setTranslate(graphTrans);
        log.info("Create OutlineBuffer-" + id + " " + (img == null ? "" : img.getWidth() + "x" + img.getHeight() + " " + img.hashCode()) + " on " + this.graphComp.getGraph() + " in " + (System.currentTimeMillis() - t) + " ms @ " + Thread.currentThread());
        return bufferedImage;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.graphComp != null) {
            String tip;
            Insets insets = this.getInsets();
            int x = event.getX() - insets.left;
            int y = event.getY() - insets.top;
            mxGraphView view = this.graphComp.getGraph().getView();
            double graphScale = view.getScale();
            Rectangle graphSize = view.getGraphBounds().getRectangle();
            Object cell = this.graphComp.getCellAt(x = (int)(((double)x / this.scale + graphSize.getX()) * graphScale), y = (int)(((double)y / this.scale + graphSize.getY()) * graphScale));
            if (cell != null && (tip = this.graphComp.getGraph().getToolTipForCell(cell)) != null && !tip.isEmpty()) {
                return tip;
            }
        }
        return null;
    }

    public static enum Fit {
        WIDTH,
        WINDOW;

    }
}

