/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance;

import com.intel.stl.ui.common.ChartsCard;
import com.intel.stl.ui.common.view.ChartsView;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.model.DatasetDescription;
import com.intel.stl.ui.performance.AbstractGroupController;
import com.intel.stl.ui.performance.ChartArgument;
import com.intel.stl.ui.performance.GroupChartArgument;
import com.intel.stl.ui.performance.GroupSource;
import com.intel.stl.ui.performance.item.AbstractPerformanceItem;
import com.intel.stl.ui.performance.item.IPerformanceItem;
import com.intel.stl.ui.performance.item.TopNItem;
import com.intel.stl.ui.performance.item.TrendItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.engio.mbassy.bus.MBassador;

public class BaseGroupController
extends AbstractGroupController<GroupSource> {
    private ChartsCard trendCard;
    private ChartsCard topNCard;
    private ChartsCard histogramCard;

    public BaseGroupController(MBassador<IAppEvent> eventBus, String name, TrendItem<GroupSource> trendItem, AbstractPerformanceItem<GroupSource> histogramItem, TopNItem topNItem) {
        super(eventBus, name, new IPerformanceItem[]{trendItem, histogramItem, topNItem});
    }

    @Override
    protected List<ChartsCard> initCards(Map<String, DatasetDescription> map) {
        ArrayList<ChartsCard> res = new ArrayList<ChartsCard>();
        if (this.allItems[0] != null) {
            this.trendCard = this.createTrendCard(this.allItems[0], map);
            res.add(this.trendCard);
        }
        if (this.allItems[1] != null) {
            this.histogramCard = this.createHistogramCard(this.allItems[1], map);
            res.add(this.histogramCard);
        }
        if (this.allItems[2] != null) {
            this.topNCard = this.createTopNCard(this.allItems[2], map);
            res.add(this.topNCard);
        }
        return res;
    }

    public void setHelpIDs(String trendHelpID, String histogramHelpID, String topNHelpID) {
        if (this.trendCard != null) {
            this.trendCard.setHelpID(trendHelpID);
        }
        if (this.histogramCard != null) {
            this.histogramCard.setHelpID(histogramHelpID);
        }
        if (this.topNCard != null) {
            this.topNCard.setHelpID(topNHelpID);
        }
    }

    protected ChartsCard createTrendCard(IPerformanceItem<GroupSource> item, Map<String, DatasetDescription> map) {
        return this.createOptionCard(item, map, true, false);
    }

    protected ChartsCard createHistogramCard(IPerformanceItem<GroupSource> item, Map<String, DatasetDescription> map) {
        return this.createCard(item, map);
    }

    protected ChartsCard createTopNCard(IPerformanceItem<GroupSource> item, Map<String, DatasetDescription> map) {
        return this.createCard(item, map);
    }

    @Override
    protected ChartsView getItemView(IPerformanceItem<GroupSource> item) {
        if (this.allItems[0] == item) {
            return (ChartsView)this.trendCard.getView();
        }
        if (this.allItems[1] == item) {
            return (ChartsView)this.histogramCard.getView();
        }
        if (this.allItems[2] == item) {
            return (ChartsView)this.topNCard.getView();
        }
        return null;
    }

    @Override
    protected ChartArgument<GroupSource> getChartArgument(IPerformanceItem<GroupSource> item) {
        GroupChartArgument arg = new GroupChartArgument();
        String name = item.getName();
        arg.setName(name);
        arg.setFullName(item.getFullName());
        arg.setProvider(item.getCurrentProviderName().name());
        if (item.getType() != null) {
            arg.setDataType(item.getType());
        }
        if (item.getHistoryType() != null) {
            arg.setHistoryType(item.getHistoryType());
        }
        arg.setSources((GroupSource[])item.getSources());
        return arg;
    }
}

