/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance;

import com.intel.stl.ui.common.ChartsCard;
import com.intel.stl.ui.common.PinDescription;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ChartsView;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.model.DataType;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.performance.BaseGroupController;
import com.intel.stl.ui.performance.GroupSource;
import com.intel.stl.ui.performance.OptionBaseGroupController;
import com.intel.stl.ui.performance.item.BBHistogramItem;
import com.intel.stl.ui.performance.item.BBTopNItem;
import com.intel.stl.ui.performance.item.BBTrendItem;
import com.intel.stl.ui.performance.item.BWHistogramItem;
import com.intel.stl.ui.performance.item.BWTopNItem;
import com.intel.stl.ui.performance.item.BWTrendItem;
import com.intel.stl.ui.performance.item.CGHistogramItem;
import com.intel.stl.ui.performance.item.CGTopNItem;
import com.intel.stl.ui.performance.item.CGTrendItem;
import com.intel.stl.ui.performance.item.IntegrityHistogramItem;
import com.intel.stl.ui.performance.item.IntegrityTopNItem;
import com.intel.stl.ui.performance.item.IntegrityTrendItem;
import com.intel.stl.ui.performance.item.PRTopNItem;
import com.intel.stl.ui.performance.item.PRTrendItem;
import com.intel.stl.ui.performance.item.REHistogramItem;
import com.intel.stl.ui.performance.item.RETopNItem;
import com.intel.stl.ui.performance.item.RETrendItem;
import com.intel.stl.ui.performance.item.SCHistogramItem;
import com.intel.stl.ui.performance.item.SCTopNItem;
import com.intel.stl.ui.performance.item.SCTrendItem;
import com.intel.stl.ui.performance.item.SEHistogramItem;
import com.intel.stl.ui.performance.item.SETopNItem;
import com.intel.stl.ui.performance.item.SETrendItem;
import java.util.List;
import net.engio.mbassy.bus.MBassador;

public class BaseGroupFactory {
    private static DataType[] ERR_DATA_TYPE = new DataType[]{DataType.ALL, DataType.INTERNAL, DataType.EXTERNAL};
    private static final String TOP_N_CHART = "Top";

    public static BaseGroupController createBandwidthGroup(MBassador<IAppEvent> eventBus, int topN, DataType type, HistoryType historyType, GroupSource ... sourceNames) {
        OptionBaseGroupController res = new OptionBaseGroupController(eventBus, STLConstants.K0041_BANDWIDTH.getValue(), new BWTrendItem(), new BWHistogramItem(), new BWTopNItem(topN), DataType.values(), HistoryType.values());
        res.setDataSources(sourceNames);
        res.setType(type);
        res.setHistoryType(historyType);
        res.setPinID(PinDescription.PinID.PERF_BW);
        BaseGroupFactory.setComponentNames(res, STLConstants.K0890_BANDWIDTH.getValue());
        BaseGroupFactory.setUnitGroupHelp(res);
        return res;
    }

    public static BaseGroupController createPacketRateGroup(MBassador<IAppEvent> eventBus, int topN, DataType type, HistoryType historyType, GroupSource ... sourceNames) {
        OptionBaseGroupController res = new OptionBaseGroupController(eventBus, STLConstants.K0065_PACKET_RATE.getValue(), new PRTrendItem(), null, new PRTopNItem(topN), DataType.values(), HistoryType.values());
        res.setDataSources(sourceNames);
        res.setType(type);
        res.setHistoryType(historyType);
        res.setPinID(PinDescription.PinID.PERF_PR);
        BaseGroupFactory.setComponentNames(res, STLConstants.K0891_PKT_RATE.getValue());
        BaseGroupFactory.setUnitGroupHelp(res);
        return res;
    }

    private static void setUnitGroupHelp(BaseGroupController group) {
        HelpAction helpAction = HelpAction.getInstance();
        group.setHelpIDs(helpAction.getTrend(), helpAction.getHistogram(), helpAction.getTopN());
    }

    public static BaseGroupController createCongestionGroup(MBassador<IAppEvent> eventBus, int topN, DataType type, HistoryType historyType, GroupSource ... sourceNames) {
        OptionBaseGroupController res = new OptionBaseGroupController(eventBus, STLConstants.K0043_CONGESTION_ERROR.getValue(), new CGTrendItem(), new CGHistogramItem(), new CGTopNItem(topN), ERR_DATA_TYPE, HistoryType.values());
        res.setDataSources(sourceNames);
        res.setType(type);
        res.setHistoryType(historyType);
        res.setPinID(PinDescription.PinID.PERF_CG);
        BaseGroupFactory.setComponentNames(res, STLConstants.K0892_CONGESTION.getValue());
        BaseGroupFactory.setErrorGroupHelp(res);
        return res;
    }

    public static BaseGroupController createSignalIntegrityGroup(MBassador<IAppEvent> eventBus, int topN, DataType type, HistoryType historyType, GroupSource ... sourceNames) {
        OptionBaseGroupController res = new OptionBaseGroupController(eventBus, STLConstants.K0067_INTEGRITY_ERROR.getValue(), new IntegrityTrendItem(), new IntegrityHistogramItem(), new IntegrityTopNItem(topN), ERR_DATA_TYPE, HistoryType.values());
        res.setDataSources(sourceNames);
        res.setType(type);
        res.setHistoryType(historyType);
        res.setPinID(PinDescription.PinID.PERF_SI);
        BaseGroupFactory.setComponentNames(res, STLConstants.K0894_INTEGRITY.getValue());
        BaseGroupFactory.setErrorGroupHelp(res);
        return res;
    }

    public static BaseGroupController createSmaCongestionGroup(MBassador<IAppEvent> eventBus, int topN, DataType type, HistoryType historyType, GroupSource ... sourceNames) {
        OptionBaseGroupController res = new OptionBaseGroupController(eventBus, STLConstants.K0070_SMA_CONGESTION_ERROR.getValue(), new SCTrendItem(), new SCHistogramItem(), new SCTopNItem(topN), ERR_DATA_TYPE, HistoryType.values());
        res.setDataSources(sourceNames);
        res.setType(type);
        res.setHistoryType(historyType);
        res.setPinID(PinDescription.PinID.PERF_SC);
        BaseGroupFactory.setComponentNames(res, STLConstants.K0893_SMA_CONGESTION.getValue());
        BaseGroupFactory.setErrorGroupHelp(res);
        return res;
    }

    public static BaseGroupController createBubbleGroup(MBassador<IAppEvent> eventBus, int topN, DataType type, HistoryType historyType, GroupSource ... sourceNames) {
        OptionBaseGroupController res = new OptionBaseGroupController(eventBus, STLConstants.K0487_BUBBLE_ERROR.getValue(), new BBTrendItem(), new BBHistogramItem(), new BBTopNItem(topN), ERR_DATA_TYPE, HistoryType.values());
        res.setDataSources(sourceNames);
        res.setType(type);
        res.setHistoryType(historyType);
        res.setPinID(PinDescription.PinID.PERF_BB);
        BaseGroupFactory.setComponentNames(res, STLConstants.K0895_BUBBLE.getValue());
        BaseGroupFactory.setErrorGroupHelp(res);
        return res;
    }

    public static BaseGroupController createSecurityGroup(MBassador<IAppEvent> eventBus, int topN, DataType type, HistoryType historyType, GroupSource ... sourceNames) {
        OptionBaseGroupController res = new OptionBaseGroupController(eventBus, STLConstants.K0072_SECURITY.getValue(), new SETrendItem(), new SEHistogramItem(), new SETopNItem(topN), ERR_DATA_TYPE, HistoryType.values());
        res.setDataSources(sourceNames);
        res.setType(type);
        res.setHistoryType(historyType);
        res.setPinID(PinDescription.PinID.PERF_SE);
        BaseGroupFactory.setComponentNames(res, STLConstants.K0896_SECURITY.getValue());
        BaseGroupFactory.setErrorGroupHelp(res);
        return res;
    }

    public static BaseGroupController createRoutingGroup(MBassador<IAppEvent> eventBus, int topN, DataType type, HistoryType historyType, GroupSource ... sourceNames) {
        OptionBaseGroupController res = new OptionBaseGroupController(eventBus, STLConstants.K0074_ROUTING_ERROR.getValue(), new RETrendItem(), new REHistogramItem(), new RETopNItem(topN), ERR_DATA_TYPE, HistoryType.values());
        res.setDataSources(sourceNames);
        res.setType(type);
        res.setHistoryType(historyType);
        res.setPinID(PinDescription.PinID.PERF_RT);
        BaseGroupFactory.setComponentNames(res, STLConstants.K0897_ROUTING.getValue());
        BaseGroupFactory.setErrorGroupHelp(res);
        return res;
    }

    private static void setComponentNames(BaseGroupController res, String sectionName) {
        List<ChartsCard> cards = res.getCards();
        for (ChartsCard card : cards) {
            String chartName = card.getCurrentChart();
            ChartsView view = (ChartsView)card.getView();
            String helpBtnName = "";
            String pinBtnName = "";
            String panelName = "";
            if (chartName.equals(STLConstants.K0078_TREND.getValue())) {
                helpBtnName = WidgetName.PP_PERF_TREND_HELP_.name();
                pinBtnName = WidgetName.PP_PERF_TREND_PIN_.name();
                panelName = WidgetName.PP_PERF_TREND_PANEL_.name();
            } else if (chartName.startsWith(TOP_N_CHART)) {
                helpBtnName = WidgetName.PP_PERF_TOPN_HELP_.name();
                pinBtnName = WidgetName.PP_PERF_TOPN_PIN_.name();
                panelName = WidgetName.PP_PERF_TOPN_PANEL_.name();
            } else if (chartName.equals(STLConstants.K0079_HISTOGRAM.getValue())) {
                helpBtnName = WidgetName.PP_PERF_HISTOGRAM_HELP_.name();
                pinBtnName = WidgetName.PP_PERF_HISTOGRAM_PIN_.name();
                panelName = WidgetName.PP_PERF_HISTOGRAM_PANEL_.name();
            }
            view.setHelpButtonName(helpBtnName + sectionName);
            view.setPinButtonName(pinBtnName + sectionName);
            view.setMainPanelName(panelName + sectionName);
        }
    }

    private static void setErrorGroupHelp(BaseGroupController group) {
        HelpAction helpAction = HelpAction.getInstance();
        group.setHelpIDs(helpAction.getErrorGroup(), helpAction.getErrorGroup(), helpAction.getErrorGroup());
    }
}

