/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance;

import com.intel.stl.ui.common.PinArgument;
import com.intel.stl.ui.model.DataType;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.performance.GroupChartArgument;
import com.intel.stl.ui.performance.ISource;
import com.intel.stl.ui.performance.PortChartArgument;
import com.intel.stl.ui.performance.PortCounterChartArgument;
import java.util.Properties;

public abstract class ChartArgument<S extends ISource>
extends PinArgument {
    private static final long serialVersionUID = 5414961409003011918L;
    public static final String NAME = "Name";
    public static final String FULL_NAME = "Full Name";
    public static final String PROVIDER = "Provider";
    public static final String DATA_TYPE = "Data Type";
    public static final String HISTORY_TYPE = "History Type";
    private static final String DELIMITER = ",";

    public void setName(String name) {
        this.put(NAME, name);
    }

    public String getName() {
        return this.getProperty(NAME);
    }

    public void setFullName(String fullName) {
        this.put(FULL_NAME, fullName);
    }

    public String getFullName() {
        return this.getProperty(FULL_NAME);
    }

    public void setProvider(String name) {
        this.put(PROVIDER, name);
    }

    public String getProvider() {
        return this.getProperty(PROVIDER);
    }

    public void setDataType(DataType type) {
        this.put(DATA_TYPE, type.name());
    }

    public DataType getDataType() {
        String str = this.getProperty(DATA_TYPE);
        if (str != null) {
            return DataType.valueOf(str);
        }
        return null;
    }

    public void setHistoryType(HistoryType type) {
        this.put(HISTORY_TYPE, type.name());
    }

    public HistoryType getHistoryTpe() {
        String str = this.getProperty(HISTORY_TYPE);
        if (str != null) {
            return HistoryType.valueOf(str);
        }
        return null;
    }

    public abstract S[] getSources();

    public abstract void setSources(S[] var1);

    protected String toString(String[] sourceNames) {
        StringBuffer sb = new StringBuffer();
        for (String source : sourceNames) {
            if (source.contains(DELIMITER)) {
                throw new IllegalArgumentException("Source name '" + source + "' contains DELIMITER '" + DELIMITER + "'");
            }
            if (sb.length() == 0) {
                sb.append(source);
                continue;
            }
            sb.append(DELIMITER + source);
        }
        return sb.toString();
    }

    protected String[] toArray(String str) {
        if (str == null) {
            return new String[0];
        }
        return str.split(DELIMITER);
    }

    @Override
    public int hashCode() {
        String name = this.getName();
        int prime = 31;
        int result = 1;
        result = 31 * result + (name == null ? 0 : name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChartArgument other = (ChartArgument)obj;
        String name = this.getName();
        String otherName = other.getName();
        return !(name == null ? otherName != null : !name.equals(otherName));
    }

    public static ChartArgument<?> asChartArgument(Properties props) {
        if (props instanceof ChartArgument) {
            return (ChartArgument)props;
        }
        if (props.getProperty("Groups") != null || props.getProperty("VFs") != null) {
            GroupChartArgument gca = new GroupChartArgument();
            for (String name : props.stringPropertyNames()) {
                gca.put(name, props.getProperty(name));
            }
            return gca;
        }
        if (props.getProperty("Node LID") != null) {
            if (props.getProperty("Field Name") == null) {
                PortChartArgument pca = new PortChartArgument();
                for (String name : props.stringPropertyNames()) {
                    pca.put(name, props.getProperty(name));
                }
                return pca;
            }
            PortCounterChartArgument pcca = new PortCounterChartArgument();
            for (String name : props.stringPropertyNames()) {
                pcca.put(name, props.getProperty(name));
            }
            return pcca;
        }
        throw new IllegalArgumentException("Unknow properties " + props);
    }
}

